/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.ProcessingState;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

class Processing {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_ITEMS_TO_RECEIVE = "ItemsToReceive";
    private static final String NBT_FLUIDS_TO_RECEIVE = "FluidsToReceive";
    private static final String NBT_ITEMS_TO_PUT = "ItemsToPut";
    private static final String NBT_FLUIDS_TO_PUT = "FluidsToPut";
    private static final String NBT_STATE = "State";
    private static final String NBT_ROOT = "Root";
    private ICraftingPattern pattern;
    private IStackList<ItemStack> itemsToReceive;
    private IStackList<FluidStack> fluidsToReceive;
    private ArrayList<ItemStack> itemsToPut;
    private ArrayList<FluidStack> fluidsToPut;
    private ProcessingState state = ProcessingState.READY;
    private boolean root;

    public Processing(ICraftingPattern pattern, IStackList<ItemStack> itemsToReceive, IStackList<FluidStack> fluidsToReceive, ArrayList<ItemStack> itemsToPut, ArrayList<FluidStack> fluidsToPut, boolean root) {
        this.pattern = pattern;
        this.itemsToReceive = itemsToReceive;
        this.fluidsToReceive = fluidsToReceive;
        this.itemsToPut = itemsToPut;
        this.fluidsToPut = fluidsToPut;
        this.root = root;
    }

    public Processing(INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.world());
        this.itemsToReceive = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_TO_RECEIVE, 10));
        this.fluidsToReceive = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_TO_RECEIVE, 10));
        this.root = tag.func_74767_n(NBT_ROOT);
        this.itemsToPut = new ArrayList();
        NBTTagList itemsToPutList = tag.func_150295_c(NBT_ITEMS_TO_PUT, 10);
        for (int i = 0; i < itemsToPutList.func_74745_c(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(itemsToPutList.func_150305_b(i));
            if (stack.func_190926_b()) {
                throw new CraftingTaskReadException("Stack is empty!");
            }
            this.itemsToPut.add(stack);
        }
        this.fluidsToPut = new ArrayList();
        NBTTagList fluidsToPutList = tag.func_150295_c(NBT_FLUIDS_TO_PUT, 10);
        for (int i = 0; i < fluidsToPutList.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidsToPutList.func_150305_b(i));
            if (stack == null) {
                throw new CraftingTaskReadException("Stack is empty!");
            }
            this.fluidsToPut.add(stack);
        }
        this.state = ProcessingState.values()[tag.func_74762_e(NBT_STATE)];
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public IStackList<ItemStack> getItemsToReceive() {
        return this.itemsToReceive;
    }

    public IStackList<FluidStack> getFluidsToReceive() {
        return this.fluidsToReceive;
    }

    public List<ItemStack> getItemsToPut() {
        return this.itemsToPut;
    }

    public List<FluidStack> getFluidsToPut() {
        return this.fluidsToPut;
    }

    public void setState(ProcessingState state) {
        this.state = state;
    }

    public ProcessingState getState() {
        return this.state;
    }

    public boolean isRoot() {
        return this.root;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN, (NBTBase)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74782_a(NBT_ITEMS_TO_RECEIVE, (NBTBase)CraftingTask.writeItemStackList(this.itemsToReceive));
        tag.func_74782_a(NBT_FLUIDS_TO_RECEIVE, (NBTBase)CraftingTask.writeFluidStackList(this.fluidsToReceive));
        tag.func_74757_a(NBT_ROOT, this.root);
        NBTTagList itemsToPutList = new NBTTagList();
        for (ItemStack stack : this.itemsToPut) {
            itemsToPutList.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(stack));
        }
        tag.func_74782_a(NBT_ITEMS_TO_PUT, (NBTBase)itemsToPutList);
        NBTTagList fluidsToPutList = new NBTTagList();
        for (FluidStack stack : this.fluidsToPut) {
            fluidsToPutList.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_FLUIDS_TO_PUT, (NBTBase)fluidsToPutList);
        tag.func_74768_a(NBT_STATE, this.state.ordinal());
        return tag;
    }
}

