/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.entities;

import com.google.common.base.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.PacketActionOptionToClient;
import mcjty.meecreeps.actions.ServerActionManager;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.blocks.ModBlocks;
import mcjty.meecreeps.entities.MeeCreepWorkerTask;
import mcjty.meecreeps.network.MeeCreepsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityMeeCreeps
extends EntityCreature
implements IMeeCreep {
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EntityMeeCreeps.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Integer> FACE_VARIATION = EntityDataManager.func_187226_a(EntityMeeCreeps.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final ResourceLocation LOOT = new ResourceLocation("meecreeps", "entities/meecreeps");
    public static final int INVENTORY_SIZE = 4;
    private int actionId = 0;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private MeeCreepWorkerTask workerTask;
    private int variationHair = 0;
    private NBTTagCompound carriedNBT = null;

    public EntityMeeCreeps(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.variationHair = worldIn.field_73012_v.nextInt(9);
        this.func_110163_bv();
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.equals(DamageSource.field_76367_g)) {
            return true;
        }
        if (source.equals(DamageSource.field_76369_e)) {
            return true;
        }
        if (source.equals(DamageSource.field_76379_h)) {
            return true;
        }
        if (source.equals(DamageSource.field_76368_d)) {
            return true;
        }
        if (source.equals(DamageSource.field_191291_g)) {
            return true;
        }
        if (source.equals(DamageSource.field_76377_j)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public Random getRandom() {
        return this.func_70681_au();
    }

    @Override
    public EntityCreature getEntity() {
        return this;
    }

    public WorkerHelper getHelper() {
        return this.workerTask.getHelper();
    }

    @Override
    public World getWorld() {
        return this.func_130014_f_();
    }

    public void cancelJob() {
        if (this.workerTask != null) {
            this.workerTask.cancelJob();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        int variationFace = this.field_70170_p.field_73012_v.nextInt(9);
        while (variationFace == 1) {
            variationFace = this.field_70170_p.field_73012_v.nextInt(9);
        }
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FACE_VARIATION, (Object)variationFace);
    }

    public int getVariationFace() {
        return (Integer)this.field_70180_af.func_187225_a(FACE_VARIATION);
    }

    public int getVariationHair() {
        return this.variationHair;
    }

    public void setVariationFace(int variationFace) {
        this.field_70180_af.func_187227_b(FACE_VARIATION, (Object)variationFace);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.13);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.workerTask = new MeeCreepWorkerTask(this);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.workerTask);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ActionOptions options;
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        ServerActionManager manager = ServerActionManager.getManager();
        if (this.actionId != 0 && (options = manager.getOptions(this.actionId)) != null) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketActionOptionToClient(options, 2), (EntityPlayerMP)player);
            options.setPaused(true);
        }
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            ServerActionManager manager = ServerActionManager.getManager();
            if (this.actionId != 0) {
                ActionOptions options = manager.getOptions(this.actionId);
                if (options == null) {
                    manager.updateEntityCache(this.actionId, null);
                    this.killMe();
                } else {
                    manager.updateEntityCache(this.actionId, this);
                }
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void setHeldBlockState(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    @Nullable
    public IBlockState getHeldBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orNull();
    }

    @Nullable
    public NBTTagCompound getCarriedNBT() {
        return this.carriedNBT;
    }

    public void setCarriedNBT(NBTTagCompound carriedNBT) {
        this.carriedNBT = carriedNBT;
    }

    public void placeDownBlock(BlockPos pos) {
        IBlockState state = this.getHeldBlockState();
        if (state == null) {
            return;
        }
        if (state.func_177230_c() == ModBlocks.heldCubeBlock) {
            return;
        }
        this.field_70170_p.func_180501_a(pos, state, 3);
        NBTTagCompound tc = this.getCarriedNBT();
        if (tc != null) {
            tc.func_74768_a("x", pos.func_177958_n());
            tc.func_74768_a("y", pos.func_177956_o());
            tc.func_74768_a("z", pos.func_177952_p());
            TileEntity tileEntity = TileEntity.func_190200_a((World)this.field_70170_p, (NBTTagCompound)tc);
            if (tileEntity != null) {
                this.field_70170_p.func_175726_f(pos).func_150813_a(tileEntity);
                tileEntity.func_70296_d();
                this.field_70170_p.func_184138_a(pos, state, state, 3);
            }
        }
        this.carriedNBT = null;
        this.setHeldBlockState(null);
    }

    @Override
    public ItemStack addStack(ItemStack stack) {
        ItemStack itemstack;
        int i;
        if (stack.func_77985_e()) {
            for (i = 0; !stack.func_190926_b() && i < 4; ++i) {
                int maxSize;
                itemstack = (ItemStack)this.inventory.get(i);
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack)) continue;
                int newsize = itemstack.func_190916_E() + stack.func_190916_E();
                if (newsize <= (maxSize = itemstack.func_77976_d())) {
                    stack.func_190920_e(0);
                    itemstack.func_190920_e(newsize);
                    return ItemStack.field_190927_a;
                }
                if (itemstack.func_190916_E() >= maxSize) continue;
                stack.func_190918_g(maxSize - itemstack.func_190916_E());
                itemstack.func_190920_e(maxSize);
            }
        }
        if (!stack.func_190926_b()) {
            for (i = 0; i < 4; ++i) {
                itemstack = (ItemStack)this.inventory.get(i);
                if (!itemstack.func_190926_b()) continue;
                this.inventory.set(i, (Object)stack);
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public Predicate<ItemStack> getInventoryMatcher() {
        return stack -> {
            for (ItemStack s : this.inventory) {
                if (!ItemStack.func_77989_b((ItemStack)s, (ItemStack)stack)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public boolean hasEmptyInventory() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasStuffInInventory() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItem(Predicate<ItemStack> matcher) {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b() || !matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItems(Predicate<ItemStack> matcher, int amount) {
        int cnt = 0;
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b() || !matcher.test(stack) || (cnt += stack.func_190916_E()) < amount) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRoom(Predicate<ItemStack> matcher) {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) {
                return true;
            }
            if (stack.func_190926_b() || !matcher.test(stack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dropInventory() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (!stack.func_190926_b()) {
                this.func_70099_a(stack, 0.0f);
            }
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public ItemStack consumeItem(Predicate<ItemStack> matcher, int amount) {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b() || !matcher.test(stack)) continue;
            return stack.func_77979_a(amount);
        }
        return ItemStack.field_190927_a;
    }

    public int func_70641_bl() {
        return 5;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void func_70037_a(NBTTagCompound compound) {
        IBlockState iblockstate;
        super.func_70037_a(compound);
        this.actionId = compound.func_74762_e("actionId");
        NBTTagList list = compound.func_150295_c("items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (i >= this.inventory.size()) continue;
            this.inventory.set(i, (Object)new ItemStack(list.func_150305_b(i)));
        }
        if (compound.func_74764_b("worker") && this.workerTask != null) {
            this.workerTask.readFromNBT(compound.func_74775_l("worker"));
        }
        if ((iblockstate = compound.func_150297_b("carried", 8) ? Block.func_149684_b((String)compound.func_74779_i("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF) : Block.func_149729_e((int)compound.func_74765_d("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF)) == null || iblockstate.func_177230_c() == null || iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlockState(iblockstate);
        if (compound.func_74764_b("carriedNBT")) {
            this.carriedNBT = compound.func_74775_l("carriedNBT");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        IBlockState iblockstate;
        super.func_70014_b(compound);
        compound.func_74768_a("actionId", this.actionId);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.inventory) {
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("items", (NBTBase)list);
        if (this.workerTask != null) {
            NBTTagCompound workerTag = new NBTTagCompound();
            this.workerTask.writeToNBT(workerTag);
            compound.func_74782_a("worker", (NBTBase)workerTag);
        }
        if ((iblockstate = this.getHeldBlockState()) != null) {
            compound.func_74777_a("carried", (short)Block.func_149682_b((Block)iblockstate.func_177230_c()));
            compound.func_74777_a("carriedData", (short)iblockstate.func_177230_c().func_176201_c(iblockstate));
        }
        if (this.carriedNBT != null) {
            compound.func_74782_a("carriedNBT", (NBTBase)this.carriedNBT);
        }
    }

    private void spawnDeathParticles() {
        for (int i = 0; i < 40; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, new int[0]);
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187570_aq, this.func_184176_by(), 1.0f, 1.0f, false);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.spawnDeathParticles();
    }

    private void killMe() {
        this.func_70106_y();
        this.dropInventory();
        this.placeDownBlock(this.func_180425_c());
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.killMe();
    }
}

