/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.meecreeps.actions.workers.ChopTreeActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.api.PreferedChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChopTreeAndCollectActionWorker
extends ChopTreeActionWorker {
    private static final PreferedChest[] PREFERED_CHESTS = new PreferedChest[]{PreferedChest.MARKED, PreferedChest.FIND_MATCHING_INVENTORY};
    private AxisAlignedBB actionBox = null;

    public ChopTreeAndCollectActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-10, -5, -10), this.options.getTargetPos().func_177982_a(10, 5, 10));
        }
        return this.actionBox;
    }

    private void harvest(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        this.helper.harvestAndPickup(pos);
        this.findLeaves(pos, world);
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        if (this.blocks.isEmpty()) {
            this.findTree();
        }
        if (this.blocks.isEmpty() && this.leavesToTick.isEmpty()) {
            this.helper.taskIsDone();
            return;
        }
        if (!this.leavesToTick.isEmpty()) {
            this.decayLeaves();
        }
        if (!this.blocks.isEmpty()) {
            BlockPos toRemove = (BlockPos)this.blocks.remove(0);
            this.helper.navigateTo(this.options.getTargetPos(), blockPos -> this.harvest(toRemove));
        } else {
            this.helper.taskIsDone();
        }
    }

    private void decayLeaves() {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        Counter newmap = new Counter();
        for (Map.Entry entry : this.leavesToTick.entrySet()) {
            Integer counter;
            BlockPos pos = (BlockPos)entry.getKey();
            if (world.func_175623_d(pos)) continue;
            IBlockState state = world.func_180495_p(pos);
            this.helper.registerHarvestableBlock(pos);
            state.func_177230_c().func_180650_b(world, pos, state, entity.getRandom());
            if (world.func_175623_d(pos)) continue;
            Integer n = counter = (Integer)entry.getValue();
            Integer n2 = counter = Integer.valueOf(counter - 1);
            if (counter <= 0) continue;
            newmap.put((Object)pos, (Object)counter);
        }
        this.leavesToTick = newmap;
    }

    @Override
    public PreferedChest[] getPreferedChests() {
        return PREFERED_CHESTS;
    }
}

