/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps;

import java.util.HashMap;
import java.util.Map;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.ServerActionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ForgeEventHandlers {
    public static final Map<BlockPos, Integer> harvestableBlocksToCollect = new HashMap<BlockPos, Integer>();

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> registry) {
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "teleport")).setRegistryName(new ResourceLocation("meecreeps", "teleport")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "portal")).setRegistryName(new ResourceLocation("meecreeps", "portal")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "intro1")).setRegistryName(new ResourceLocation("meecreeps", "intro1")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "intro2")).setRegistryName(new ResourceLocation("meecreeps", "intro2")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "intro3")).setRegistryName(new ResourceLocation("meecreeps", "intro3")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "intro4")).setRegistryName(new ResourceLocation("meecreeps", "intro4")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "ok")).setRegistryName(new ResourceLocation("meecreeps", "ok")));
        registry.getRegistry().register(new SoundEvent(new ResourceLocation("meecreeps", "ok2")).setRegistryName(new ResourceLocation("meecreeps", "ok2")));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ServerTickEvent event) {
        ServerActionManager.getManager().tick();
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        BlockPos pos = event.getPos();
        if (harvestableBlocksToCollect.containsKey(pos)) {
            Integer actionId = harvestableBlocksToCollect.get(pos);
            ActionOptions options = ServerActionManager.getManager().getOptions(actionId);
            if (options != null) {
                options.registerDrops(pos, event.getDrops());
                event.getDrops().clear();
                ServerActionManager.getManager().save();
            } else {
                harvestableBlocksToCollect.remove(pos);
            }
        }
    }
}

