/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.item.ItemBOPPlant;
import biomesoplenty.common.util.block.VariantPagingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IHornHarvestable;

@Optional.Interface(iface="vazkii.botania.api.item.IHornHarvestable", modid="botania")
public class BlockBOPPlant
extends BlockBOPDecoration
implements IShearable,
IHornHarvestable {
    public static VariantPagingHelper<BlockBOPPlant, BOPPlants> paging = new VariantPagingHelper(16, BOPPlants.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPPlant());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPPlant.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            default: 
        }
        return plant.func_176610_l();
    }

    public static ColoringType getColoringType(BOPPlants plant) {
        switch (plant) {
            case SHRUB: 
            case LEAFPILE: 
            case POISONIVY: 
            case BUSH: 
            case BERRYBUSH: {
                return ColoringType.LIKE_LEAVES;
            }
            case SHORTGRASS: 
            case MEDIUMGRASS: 
            case SPROUT: 
            case KORU: 
            case CLOVERPATCH: 
            case WHEATGRASS: 
            case DAMPGRASS: 
            case DEVILWEED: {
                return ColoringType.LIKE_GRASS;
            }
        }
        return ColoringType.PLAIN;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                boolean inWorld = world != null && pos != null;
                switch (BlockBOPPlant.getColoringType((BOPPlants)((Object)state.func_177229_b(BlockBOPPlant.this.variantProperty)))) {
                    case LIKE_LEAVES: {
                        return inWorld ? BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
                    }
                    case LIKE_GRASS: {
                        return inWorld ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                    }
                }
                return 0xFFFFFF;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
                case SHRUB: 
                case BUSH: 
                case BERRYBUSH: {
                    return 0xFFFFFF;
                }
            }
            return this.getBlockColor().func_186720_a(state, null, null, tintIndex);
        };
    }

    private BlockBOPPlant() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta)));
    }

    public int func_176201_c(IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        return paging.getIndex(plant);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case DEADGRASS: {
                return MapColor.field_151650_B;
            }
            case DESERTGRASS: {
                return MapColor.field_193562_N;
            }
            case THORN: {
                return MapColor.field_193569_U;
            }
            case BARLEY: {
                return MapColor.field_151673_t;
            }
            case RAFFLESIA: {
                return MapColor.field_151645_D;
            }
        }
        return this.field_181083_K;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            case SHORTGRASS: 
            case MEDIUMGRASS: 
            case WHEATGRASS: 
            case DAMPGRASS: {
                if (rand.nextInt(8) != 0) break;
                ret.add(ForgeHooks.getGrassSeed((Random)rand, (int)fortune));
                break;
            }
            case SPROUT: {
                if (rand.nextInt(50) != 0) break;
                ret.add(new ItemStack(rand.nextInt(2) == 0 ? Items.field_151172_bF : Items.field_151174_bG));
                break;
            }
            case BERRYBUSH: {
                ret.add(new ItemStack(BOPItems.berries));
                break;
            }
            case WILDRICE: {
                if (rand.nextInt(5) != 0) break;
                ret.add(paging.getVariantItem(plant));
                break;
            }
            case BARLEY: {
                if (rand.nextInt(3) != 0) break;
                ret.add(new ItemStack(Items.field_151014_N));
                break;
            }
            case RAFFLESIA: 
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: 
            case REED: 
            case ROOT: {
                ret.add(paging.getVariantItem(plant));
                break;
            }
        }
        return ret;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            case THORN: 
            case RAFFLESIA: 
            case WILDRICE: 
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: {
                return false;
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            case CLOVERPATCH: 
            case RAFFLESIA: {
                return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4000000357627869, 0.9375);
            }
            case LEAFPILE: 
            case DEADLEAFPILE: {
                return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);
            }
            case SHORTGRASS: 
            case DESERTGRASS: 
            case DESERTSPROUTS: {
                return new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, 0.4000000357627869, (double)0.9f);
            }
            case TINYCACTUS: {
                return new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
            }
            case ROOT: {
                return new AxisAlignedBB(0.09999999403953552, 0.199999988079071, 0.09999999403953552, (double)0.9f, 1.0, (double)0.9f);
            }
        }
        return new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        switch (plant) {
            case DEADGRASS: 
            case DESERTGRASS: {
                return BlockQueries.litDry.matches(world, pos.func_177977_b()) || BlockQueries.sustainsNether.matches(world, pos.func_177977_b());
            }
            case TINYCACTUS: {
                return BlockQueries.litDry.matches(world, pos.func_177977_b()) || BlockQueries.litFertile.matches(world, pos.func_177977_b());
            }
            case DESERTSPROUTS: 
            case DUNEGRASS: {
                return BlockQueries.litSand.matches(world, pos.func_177977_b());
            }
            case SPECTRALFERN: {
                return BlockQueries.spectralMoss.matches(world, pos.func_177977_b());
            }
            case THORN: {
                return BlockQueries.fertileOrNetherrack.matches(world, pos.func_177977_b()) || BlockQueries.sustainsNether.matches(world, pos.func_177977_b());
            }
            case CATTAIL: {
                return BlockQueries.litFertileWaterside.matches(world, pos.func_177977_b());
            }
            case RIVERCANE: {
                return BlockQueries.litFertileWaterside.matches(world, pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()) == state;
            }
            case DEVILWEED: {
                return BlockQueries.fertile.matches(world, pos.func_177977_b());
            }
            case REED: {
                return BlockQueries.suitableForReed.matches(world, pos.func_177977_b());
            }
            case ROOT: {
                return BlockQueries.fertile.matches(world, pos.func_177984_a());
            }
            case LEAFPILE: 
            case DEADLEAFPILE: {
                return BlockQueries.solid.matches(world, pos.func_177977_b());
            }
        }
        return BlockQueries.litFertile.matches(world, pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case POISONIVY: {
                if (rand.nextInt(32) != 0) break;
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
        super.func_180655_c(state, world, pos, rand);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case BUSH: {
                if (rand.nextInt(80) != 0 || worldIn.func_175671_l(pos.func_177984_a()) < 9) break;
                worldIn.func_175656_a(pos, paging.getVariantState(BOPPlants.BERRYBUSH));
                break;
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case POISONIVY: {
                if (!(entity instanceof EntityPlayer)) break;
                InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                if (inventory.field_70460_b.get(0) != ItemStack.field_190927_a && inventory.field_70460_b.get(1) != ItemStack.field_190927_a) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                break;
            }
            case THORN: 
            case TINYCACTUS: {
                if (!(entity instanceof EntityPlayer)) break;
                InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                if (inventory.field_70460_b.get(0) != ItemStack.field_190927_a && inventory.field_70460_b.get(1) != ItemStack.field_190927_a) break;
                entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                break;
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case BERRYBUSH: {
                worldIn.func_175656_a(pos, paging.getVariantState(BOPPlants.BUSH));
                EntityItem berries = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(BOPItems.berries));
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)berries);
                    if (!(playerIn instanceof FakePlayer)) {
                        berries.func_70100_b_(playerIn);
                    }
                }
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case CATTAIL: 
            case RIVERCANE: {
                return false;
            }
        }
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: 
            case REED: 
            case ROOT: {
                break;
            }
            case BERRYBUSH: {
                ret.add(paging.getVariantItem(BOPPlants.BUSH));
                break;
            }
            default: {
                ret.add(paging.getVariantItem(plant));
            }
        }
        return ret;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case WILDRICE: {
                return 0;
            }
            case CATTAIL: {
                return 0;
            }
            case RIVERCANE: {
                return 0;
            }
            case DEVILWEED: {
                return 0;
            }
            case REED: {
                return 0;
            }
            case ROOT: {
                return 0;
            }
            case RAFFLESIA: {
                return 0;
            }
        }
        return Blocks.field_150329_H.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case WILDRICE: {
                return 0;
            }
            case CATTAIL: {
                return 0;
            }
            case RIVERCANE: {
                return 0;
            }
            case DEVILWEED: {
                return 0;
            }
            case REED: {
                return 0;
            }
            case ROOT: {
                return 0;
            }
            case RAFFLESIA: {
                return 0;
            }
        }
        return Blocks.field_150329_H.getFireSpreadSpeed(world, pos, face);
    }

    @Optional.Method(modid="botania")
    public boolean canHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        if (hornType != IHornHarvestable.EnumHornType.WILD) {
            return false;
        }
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case BUSH: 
            case BERRYBUSH: 
            case RIVERCANE: 
            case TINYCACTUS: {
                return false;
            }
        }
        return true;
    }

    @Optional.Method(modid="botania")
    public boolean hasSpecialHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Optional.Method(modid="botania")
    public void harvestByHorn(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
    }

    public static enum ColoringType {
        PLAIN,
        LIKE_LEAVES,
        LIKE_GRASS;

    }
}

