/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib3.multiblock.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IBlockOffset;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IMBComponent;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IMBStructure;
import com.valkyrieofnight.vlib3.multiblock.structure.BlockOffset;
import com.valkyrieofnight.vlib3.multiblock.structure.StructureSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class MBStructure
implements IMBStructure {
    protected Map<IMBComponent, List<IBlockOffset>> layout = Maps.newHashMap();
    protected List<EnumFacing> validDirections = Lists.newArrayList();
    protected StructureSize size;

    @Override
    public boolean isValidDirection(EnumFacing facing) {
        return this.validDirections.contains(facing);
    }

    @Override
    public List<EnumFacing> getValidDirections() {
        return this.validDirections;
    }

    @Override
    public List<IBlockOffset> getComponentLayout(IMBComponent component) {
        return this.layout.get(component);
    }

    @Override
    public Map<IMBComponent, List<IBlockOffset>> getLayout() {
        return this.layout;
    }

    @Override
    public List<IMBComponent> getComponents() {
        ArrayList comps = Lists.newArrayList();
        comps.addAll(this.layout.keySet());
        return comps;
    }

    @Override
    public void addComponent(IMBComponent comp, int xOffset, int yOffset, int zOffset) {
        BlockOffset nbp;
        ArrayList bos = this.layout.get(comp);
        if (bos == null) {
            bos = Lists.newArrayList();
            this.layout.put(comp, bos);
        }
        if (!bos.contains(nbp = new BlockOffset(xOffset, yOffset, zOffset))) {
            bos.add(nbp);
        }
    }
}

