/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib3.core.item;

import com.valkyrieofnight.vlib3.core.base.IProvideRarity;
import com.valkyrieofnight.vlib3.core.base.IProvideTooltip;
import com.valkyrieofnight.vlib3.core.util.client.InfoUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VLItemBlock
extends ItemBlock
implements IProvideRarity {
    protected EnumRarity rarity = EnumRarity.COMMON;
    protected IProvideTooltip tooltipProvider;

    public VLItemBlock(Block block) {
        super(block);
        if (block instanceof IProvideTooltip) {
            this.tooltipProvider = (IProvideTooltip)block;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.tooltipProvider == null) {
            return;
        }
        this.tooltipProvider.addTooltip(stack, world, tooltip, flag);
        if (this.tooltipProvider.hasShiftTooltip()) {
            if (InfoUtil.ENABLE_SHIFT_INFORMATION && !InfoUtil.isShiftDown()) {
                tooltip.add(InfoUtil.shiftForInfo());
            }
            if (InfoUtil.isShiftDown()) {
                this.tooltipProvider.addShiftTooltip(stack, world, tooltip, flag);
            }
        }
    }

    @Override
    public void setRarity(EnumRarity rarity) {
        this.rarity = rarity;
    }
}

