/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.m_guide.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.vlib.lib.sys.init.IModNamespace;
import com.valkyrieofnight.vlib.m_guide.client.elements.GuiGuidePage;
import com.valkyrieofnight.vlib.m_guide.client.elements.ModGuide;
import com.valkyrieofnight.vlib.m_guide.json.GuidePage;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOContainerHorizontal;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOContainerVertical;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOImage;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOItemStack;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOParagraph;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOPlainText;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOSpacing;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOText;
import com.valkyrieofnight.vlib.m_guide.json.objects.GOTileData;
import com.valkyrieofnight.vlib.m_guide.json.objects.GuideObject;
import io.netty.util.internal.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GuideHandler
implements IModNamespace {
    private static List<GuideHandler> REGISTRY = new ArrayList<GuideHandler>();
    private final Class MOD_CLASS;
    private static String FS = "/";
    public List<GuidePage> guidePages;
    private static Gson GSON = new GsonBuilder().registerTypeAdapter(GuidePage.class, (Object)new GuidePage.GuidePageSerializer()).registerTypeAdapter(GOContainerHorizontal.class, (Object)new GOContainerHorizontal.GOContainerHorizontalSerializer()).registerTypeAdapter(GOContainerVertical.class, (Object)new GOContainerVertical.GOContainerVerticalSerializer()).registerTypeAdapter(GOImage.class, (Object)new GOImage.GOImageSerializer()).registerTypeAdapter(GOItemStack.class, (Object)new GOItemStack.GOItemStackSerializer()).registerTypeAdapter(GOParagraph.class, (Object)new GOParagraph.GOParagraphSerializer()).registerTypeAdapter(GOSpacing.class, (Object)new GOSpacing.GOSpacingSerializer()).registerTypeAdapter(GOText.class, (Object)new GOText.GOTextSerializer()).registerTypeAdapter(GOTileData.class, (Object)new GOTileData.GOTileDataSerializer()).registerTypeAdapter(GOPlainText.class, (Object)new GOPlainText.GOPlainTextSerializer()).setPrettyPrinting().create();
    private static Map<String, Class> map = new TreeMap<String, Class>();

    public static void reloadAllRegistries() {
        for (GuideHandler guideHandler : REGISTRY) {
            guideHandler.reload();
        }
    }

    public GuideHandler(Class modClass) {
        this.MOD_CLASS = modClass;
        REGISTRY.add(this);
    }

    public void reload() {
        this.guidePages = new ArrayList<GuidePage>();
        try {
            this.loadPages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<InputStream> getAllStreamsFromFolder(String location) throws URISyntaxException, IOException {
        Path path;
        if (this.MOD_CLASS == null) {
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)location)) {
            return null;
        }
        URI uri = this.MOD_CLASS.getResource(location).toURI();
        if (uri.getScheme().equals("jar")) {
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            path = fs.getPath(location, new String[0]);
        } else {
            path = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(path, 1, new FileVisitOption[0]);
        Files.list(path).collect(Collectors.toList());
        ArrayList ps = new ArrayList();
        walk.forEach(ps::add);
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (Path p : ps) {
            if (!p.toString().endsWith(".json")) continue;
            InputStream is = Files.newInputStream(p, new OpenOption[0]);
            streams.add(is);
        }
        return streams;
    }

    public void loadPages() throws Exception {
        List<InputStream> isl = this.getAllStreamsFromFolder(FS + "assets" + FS + this.getModNamespace() + FS + "guide" + FS);
        for (InputStream is : isl) {
            GuidePage gp;
            BufferedReader jsReader = new BufferedReader(new InputStreamReader(is));
            if (jsReader.ready() && (gp = (GuidePage)GuideHandler.getGson().fromJson((Reader)jsReader, GuidePage.class)) != null) {
                this.guidePages.add(gp);
            }
            jsReader.close();
        }
        Collections.sort(this.guidePages);
    }

    public List<GuiGuidePage> addGuiPages(ModGuide.GuideTOCPage mainMenu, int xSize) {
        ArrayList<GuiGuidePage> r = new ArrayList<GuiGuidePage>();
        for (GuidePage guidePage : this.guidePages) {
            GuiGuidePage gp = guidePage.addPage(mainMenu, mainMenu.getXSize());
            if (gp == null) continue;
            r.add(gp);
        }
        return r;
    }

    public static Map<String, Class> getTypes() {
        return map;
    }

    public static Gson getGson() {
        return GSON;
    }

    public static void registerType(String name, Class clazz) {
        map.put(name, clazz);
    }

    static {
        map.put(GuideObject.BLANK.getType(), GuideObject.class);
        map.put(GOContainerHorizontal.BLANK.getType(), GOContainerHorizontal.class);
        map.put(GOContainerVertical.BLANK.getType(), GOContainerVertical.class);
        map.put(GOImage.BLANK.getType(), GOImage.class);
        map.put(GOItemStack.BLANK.getType(), GOItemStack.class);
        map.put(GOParagraph.BLANK.getType(), GOParagraph.class);
        map.put(GOSpacing.BLANK.getType(), GOSpacing.class);
        map.put(GOText.BLANK.getType(), GOText.class);
        map.put(GOTileData.BLANK.getType(), GOTileData.class);
        map.put(GOPlainText.BLANK.getType(), GOPlainText.class);
    }
}

