/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tilemodule.progress;

import com.valkyrieofnight.vlib.lib.sys.io.nbt.INBTHandler;
import net.minecraft.nbt.NBTTagCompound;

public class ProgressTracker
implements INBTHandler<ProgressTracker> {
    private int currentDuration = 0;
    private int currentProgress = 0;

    public void resetTracker(int duration) {
        this.currentDuration = duration + 1;
        this.currentProgress = 0;
    }

    public void startTracker() {
        if (this.currentProgress <= 0) {
            this.tick();
        }
    }

    public boolean hasStarted() {
        return this.currentProgress >= 1 && !this.isComplete();
    }

    public boolean isComplete() {
        return this.currentProgress >= this.currentDuration;
    }

    public void tick() {
        ++this.currentProgress;
    }

    public void tick(int tickAmount) {
        this.currentProgress += tickAmount;
    }

    @Override
    public ProgressTracker readFromNBT(NBTTagCompound nbt) {
        this.currentDuration = nbt.func_74762_e("cur_dur");
        this.currentProgress = nbt.func_74762_e("cur_pro");
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("cur_dur", this.currentDuration);
        nbt.func_74768_a("cur_pro", this.currentProgress);
        return nbt;
    }

    public int getTicksRemaining() {
        return this.currentDuration - this.currentProgress;
    }

    public int getDuration() {
        return this.currentDuration - 1;
    }

    public int getProgress() {
        if (this.currentProgress == 0) {
            return 0;
        }
        return this.currentProgress - 1;
    }
}

