/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock.slave;

import com.valkyrieofnight.vlib.lib.sys.owner.Owner;
import com.valkyrieofnight.vlib.lib.tile.VLTile;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileController;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileSlave;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class VLTileSlave
extends VLTile
implements ITileSlave {
    BlockPos controllerPosition;
    Block controllerBlock;
    IBlockState controllerBlockState;
    boolean hasController = false;

    public boolean hasValidController() {
        if (!this.hasController) {
            return false;
        }
        return this.func_145831_w().func_180495_p(this.controllerPosition).func_177230_c() == this.controllerBlock && this.func_145831_w().func_175625_s(this.controllerPosition) instanceof ITileController;
    }

    @Override
    public void setController(TileEntity controller) {
        this.controllerPosition = controller.func_174877_v();
        this.hasController = true;
        this.controllerBlockState = this.func_145831_w().func_180495_p(this.controllerPosition);
    }

    public BlockPos getControllerPosition() {
        return this.controllerPosition;
    }

    @Override
    public boolean hasController() {
        ITileController cont;
        if (!this.hasController) {
            return false;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.controllerPosition);
        if (te != null && te instanceof ITileController && (cont = (ITileController)te).isSlave(this.func_174877_v())) {
            return true;
        }
        this.hasController = false;
        return false;
    }

    @Override
    public void onBreak() {
        if (this.hasController()) {
            ITileController cont = (ITileController)this.func_145831_w().func_175625_s(this.controllerPosition);
            cont.onSlaveBreak(this, this.func_174877_v());
        }
    }

    @Override
    public void removeController() {
        this.hasController = false;
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean dropping) {
        super.saveTileData(nbt, dropping);
        if (dropping) {
            return nbt;
        }
        if (this.hasController) {
            nbt.func_74757_a("has_controller", this.hasController);
            nbt.func_74768_a("cx", this.controllerPosition.func_177958_n());
            nbt.func_74768_a("cy", this.controllerPosition.func_177956_o());
            nbt.func_74768_a("cz", this.controllerPosition.func_177952_p());
        }
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean dropping) {
        super.loadTileData(nbt, dropping);
        if (dropping) {
            return;
        }
        if (nbt.func_74764_b("has_controller")) {
            this.hasController = nbt.func_74767_n("has_controller");
            this.controllerPosition = new BlockPos(nbt.func_74762_e("cx"), nbt.func_74762_e("cy"), nbt.func_74762_e("cz"));
        }
    }

    @Override
    public Owner getOwner() {
        TileEntity te;
        Owner owner = Owner.NO_OWNER;
        if (this.hasController() && (te = this.func_145831_w().func_175625_s(this.controllerPosition)) instanceof ITileController) {
            owner = ((ITileController)te).getOwner();
        }
        return owner;
    }
}

