/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.module;

import com.valkyrieofnight.vlib.lib.module.AFeature;
import com.valkyrieofnight.vlib.lib.module.IFeature;
import com.valkyrieofnight.vlib.lib.sys.init.IModInit;
import com.valkyrieofnight.vlib.lib.sys.init.IModPostInit;
import com.valkyrieofnight.vlib.lib.sys.init.IModPreInit;
import com.valkyrieofnight.vlib.lib.sys.init.IRegisterBlock;
import com.valkyrieofnight.vlib.lib.sys.init.IRegisterItem;
import com.valkyrieofnight.vlib.lib.sys.init.client.IClientInit;
import com.valkyrieofnight.vlib.lib.sys.init.client.IClientPostInit;
import com.valkyrieofnight.vlib.lib.sys.init.client.IClientPreInit;
import com.valkyrieofnight.vlib.lib.sys.init.client.IRegisterModels;
import com.valkyrieofnight.vlib.lib.sys.init.server.IServerInit;
import com.valkyrieofnight.vlib.lib.sys.init.server.IServerPostInit;
import com.valkyrieofnight.vlib.lib.sys.init.server.IServerPreInit;
import com.valkyrieofnight.vlib.lib.sys.init.server.IServerStarting;
import com.valkyrieofnight.vlib.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vlib.m_guide.registry.TDPModSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VLModule
implements IClientPostInit,
IClientInit,
IClientPreInit,
IServerStarting,
IServerPostInit,
IServerInit,
IServerPreInit,
IModPostInit,
IModInit,
IModPreInit,
IRegisterBlock,
IRegisterItem,
IRegisterModels {
    private String name;
    private boolean enabled;
    private VLModule parent;
    private ConfigCategory config;
    private List<VLModule> children = new ArrayList<VLModule>();
    private List<IFeature> features = new ArrayList<IFeature>();

    public VLModule(String name, VLModule parent) {
        this.name = name;
        this.parent = parent;
        this.getOrCreateConfigs();
        this.parent.addChild(this);
    }

    protected VLModule(ConfigCategory config) {
        this.name = config.getName();
        this.config = config;
    }

    public TDPModSection getTDPModSection() {
        return this.parent.getTDPModSection();
    }

    public final void preInitModule() {
        this.initModule();
        this.addFeatures();
        for (IFeature feat : this.features) {
            feat.initFeature(this.config);
        }
        for (VLModule vlModule : this.children) {
            vlModule.preInitModule();
        }
    }

    protected abstract void initModule();

    protected void addFeature(IFeature feature) {
        this.features.add(feature);
        if (feature instanceof AFeature) {
            ((AFeature)feature).setOwner(this);
        }
    }

    protected abstract void addFeatures();

    private void getOrCreateConfigs() {
        boolean parentHasThisConfig = false;
        Set parentConfigCats = this.parent.config.getChildren();
        for (ConfigCategory configCategory : parentConfigCats) {
            if (!configCategory.getName().equalsIgnoreCase(this.name)) continue;
            parentHasThisConfig = true;
            this.config = configCategory;
            break;
        }
        if (!parentHasThisConfig) {
            this.config = new ConfigCategory(this.name, this.parent.config);
        }
        this.enabled = this.allowDisable() ? ConfigCategoryUtil.getBoolean(this.config, "enabled", this.enabledByDefault(), "Is Module Enabled?") : this.enabledByDefault();
    }

    public final void regenConfigs(Configuration config) {
        if (config == null) {
            return;
        }
        ConfigCategory cfg = config.getCategory(this.name);
        Map data = this.config.getValues();
        cfg.putAll(data);
        cfg.setComment(this.config.getComment());
        cfg.setLanguageKey(this.config.getLanguagekey());
        for (VLModule vlModule : this.children) {
            vlModule.genConfig(cfg);
        }
    }

    protected final ConfigCategory genConfig(ConfigCategory parent) {
        ConfigCategory cfg = parent != null ? new ConfigCategory(this.name, parent) : new ConfigCategory(this.name);
        Map data = this.config.getValues();
        cfg.putAll(data);
        cfg.setComment(this.config.getComment());
        cfg.setLanguageKey(this.config.getLanguagekey());
        for (VLModule vlModule : this.children) {
            vlModule.genConfig(cfg);
        }
        return cfg;
    }

    public final void addChild(VLModule child) {
        this.children.add(child);
    }

    public boolean hasChanged() {
        if (this.config.hasChanged()) {
            return true;
        }
        for (VLModule vlModule : this.children) {
            if (!vlModule.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getLocation() {
        if (this.parent != null) {
            return this.parent.getLocation() + this.name + "/";
        }
        return this.name + "/";
    }

    public void setDescription(String description) {
        this.config.setComment(description);
    }

    public String getDescription() {
        return this.config.getComment();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    protected abstract boolean enabledByDefault();

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isEnabledAndParent() {
        if (this.parent != null) {
            return this.parent.isEnabled() ? this.enabled : false;
        }
        return this.enabled;
    }

    protected boolean allowDisable() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void clientPreInit(FMLPreInitializationEvent event) {
        this.preInitClient(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IClientPreInit)) continue;
            IClientPreInit ft = (IClientPreInit)((Object)feat);
            ft.clientPreInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.clientPreInit(event);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void clientInit(FMLInitializationEvent event) {
        this.initClient(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IClientInit)) continue;
            IClientInit ft = (IClientInit)((Object)feat);
            ft.clientInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.clientInit(event);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPostInit(FMLPostInitializationEvent event) {
        this.postInitClient(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IClientPostInit)) continue;
            IClientPostInit ft = (IClientPostInit)((Object)feat);
            ft.clientPostInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.clientPostInit(event);
        }
    }

    @Override
    public final void preInit(FMLPreInitializationEvent event) {
        this.preInitCommon(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IModPreInit)) continue;
            IModPreInit ft = (IModPreInit)((Object)feat);
            ft.preInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.preInit(event);
        }
    }

    @Override
    public final void init(FMLInitializationEvent event) {
        this.initCommon(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IModInit)) continue;
            IModInit ft = (IModInit)((Object)feat);
            ft.init(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.init(event);
        }
    }

    @Override
    public final void postInit(FMLPostInitializationEvent event) {
        this.postInitCommon(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IModPostInit)) continue;
            IModPostInit ft = (IModPostInit)((Object)feat);
            ft.postInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.postInit(event);
        }
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public final void serverPreInit(FMLPreInitializationEvent event) {
        this.preInitServer(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IServerPreInit)) continue;
            IServerPreInit ft = (IServerPreInit)((Object)feat);
            ft.serverPreInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.serverPreInit(event);
        }
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public final void serverInit(FMLInitializationEvent event) {
        this.initServer(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IServerInit)) continue;
            IServerInit ft = (IServerInit)((Object)feat);
            ft.serverInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.serverInit(event);
        }
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public final void serverPostInit(FMLPostInitializationEvent event) {
        this.postInitServer(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IServerPostInit)) continue;
            IServerPostInit ft = (IServerPostInit)((Object)feat);
            ft.serverPostInit(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.serverPostInit(event);
        }
    }

    @Override
    public final void serverStarting(FMLServerStartingEvent event) {
        this.startingServer(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IServerStarting)) continue;
            IServerStarting ft = (IServerStarting)((Object)feat);
            ft.serverStarting(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.serverStarting(event);
        }
    }

    @Override
    public final void registerBlocks(RegistryEvent.Register<Block> event) {
        this.registerBlocksEvent(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IRegisterBlock)) continue;
            IRegisterBlock ft = (IRegisterBlock)((Object)feat);
            ft.registerBlocks(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.registerBlocks(event);
        }
    }

    @Override
    public final void registerItems(RegistryEvent.Register<Item> event) {
        this.registerItemsEvent(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IRegisterItem)) continue;
            IRegisterItem ft = (IRegisterItem)((Object)feat);
            ft.registerItems(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.registerItems(event);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        this.registerModelsEvent(event);
        for (IFeature feat : this.features) {
            if (!(feat instanceof IRegisterModels)) continue;
            IRegisterModels rm = (IRegisterModels)((Object)feat);
            rm.registerModels(event);
        }
        for (VLModule vlModule : this.children) {
            if (vlModule == null || !vlModule.isEnabled()) continue;
            vlModule.registerModels(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void preInitClient(FMLPreInitializationEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void initClient(FMLInitializationEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void postInitClient(FMLPostInitializationEvent event) {
    }

    protected abstract void preInitCommon(FMLPreInitializationEvent var1);

    protected abstract void initCommon(FMLInitializationEvent var1);

    protected abstract void postInitCommon(FMLPostInitializationEvent var1);

    @SideOnly(value=Side.SERVER)
    protected void preInitServer(FMLPreInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    protected void initServer(FMLInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    protected void postInitServer(FMLPostInitializationEvent event) {
    }

    protected void startingServer(FMLServerStartingEvent event) {
    }

    protected void registerBlocksEvent(RegistryEvent.Register<Block> event) {
    }

    protected void registerItemsEvent(RegistryEvent.Register<Item> event) {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModelsEvent(ModelRegistryEvent event) {
    }
}

