/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.client.gui.elements;

import com.valkyrieofnight.vlib.lib.client.gui.VLGui;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDrawTooltip;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiInput;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiInputAction;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiUpdate;
import com.valkyrieofnight.vlib.lib.client.gui.base.ToolTipList;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;

public abstract class VLElementIndex
extends VLElement
implements IGuiInput,
IGuiInputAction,
IGuiDraw,
IGuiDrawTooltip,
IGuiUpdate,
VLGui {
    protected Map<String, VLElement> indices = new HashMap<String, VLElement>();
    protected Map<String, Integer> idToNum = new HashMap<String, Integer>();
    protected Map<Integer, String> numToId = new HashMap<Integer, String>();
    protected int indexTotal = 0;
    protected String currentIndex;
    protected ToolTipList tooltips;

    public VLElementIndex(String elementID) {
        super(elementID);
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tn = nbt.func_74775_l(this.elementID);
        this.setIndex(tn.func_74779_i("index"));
        this.getCurrentIndex().readFromNBT(tn);
    }

    @Override
    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tn = new NBTTagCompound();
        tn.func_74778_a("index", this.currentIndex);
        this.getCurrentIndex().writeToNBT(tn);
        nbt.func_74782_a(this.elementID, (NBTBase)tn);
        return nbt;
    }

    public void addIndex(VLElement index) {
        if (index != null) {
            index.setGui(this);
            this.indices.put(index.elementID, index);
            this.idToNum.put(index.elementID, this.indexTotal);
            this.numToId.put(this.indexTotal, index.elementID);
            ++this.indexTotal;
            if (StringUtils.func_151246_b((String)this.currentIndex)) {
                this.currentIndex = index.elementID;
            }
        }
    }

    public boolean hasIndex(String indexID) {
        if (StringUtils.func_151246_b((String)indexID)) {
            return false;
        }
        return this.indices.containsKey(indexID);
    }

    public boolean setIndex(String indexID) {
        if (this.hasIndex(indexID)) {
            this.currentIndex = indexID;
            return true;
        }
        return false;
    }

    public VLElement getCurrentIndex() {
        return this.indices.get(this.currentIndex);
    }

    public VLElement getIndex(String index) {
        if (!this.indices.containsKey(index)) {
            return null;
        }
        return this.indices.get(index);
    }

    public boolean setIndex(int index) {
        return false;
    }

    public String getNextIndex() {
        int next = this.idToNum.get(this.currentIndex) + 1;
        if (next < this.indices.size()) {
            return this.numToId.get(next);
        }
        return this.numToId.get(0);
    }

    public String getPrevIndex() {
        int prev = this.idToNum.get(this.currentIndex) - 1;
        if (prev >= 0) {
            return this.numToId.get(prev);
        }
        return this.numToId.get(this.indices.size() - 1);
    }

    public boolean hasNextIndex() {
        return this.idToNum.get(this.currentIndex) < this.indices.size() - 1;
    }

    public boolean hasPrevIndex() {
        return this.idToNum.get(this.currentIndex) > 0;
    }

    public boolean isCurrentIndex(String index) {
        return index != null ? index.equals(this.currentIndex) : false;
    }

    @Override
    public void update() {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiUpdate) {
            ((IGuiUpdate)((Object)ci)).update();
        }
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiDraw) {
            ((IGuiDraw)((Object)ci)).drawBackgroundLayer(mx, my, partialTicks);
        }
    }

    @Override
    public void drawForegroundLayer(int mx, int my, float partialTicks) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiDraw) {
            ((IGuiDraw)((Object)ci)).drawForegroundLayer(mx, my, partialTicks);
        }
    }

    @Override
    public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiInputAction) {
            ((IGuiInputAction)((Object)ci)).mouseClicked(ele, mx, my, mouseButton);
        }
    }

    @Override
    public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiInputAction) {
            ((IGuiInputAction)((Object)ci)).mouseScrolled(ele, mx, my, scroll);
        }
    }

    @Override
    public void keyTyped(VLElement ele, char character, int keyCode) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiInputAction) {
            ((IGuiInputAction)((Object)ci)).keyTyped(ele, character, keyCode);
        }
    }

    @Override
    public boolean onMouseClicked(int mx, int my, int mouseButton) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiInput) {
            ((IGuiInput)((Object)ci)).onMouseClicked(mx, my, mouseButton);
        }
        return false;
    }

    @Override
    public boolean onMouseScrolled(int mx, int my, int scroll) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiInput) {
            ((IGuiInput)((Object)ci)).onMouseScrolled(mx, my, scroll);
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keyCode) {
        return false;
    }

    @Override
    public Gui getGui() {
        return this.gui.getGui();
    }

    @Override
    public int getGuiLeft() {
        return this.gui.getGuiLeft() + this.xPosOffset;
    }

    @Override
    public int getGuiTop() {
        return this.gui.getGuiTop() + this.yPosOffset;
    }

    @Override
    public int getGuiSizeX() {
        return this.gui.getGuiSizeX();
    }

    @Override
    public int getGuiSizeY() {
        return this.gui.getGuiSizeY();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.gui.getFontRenderer();
    }

    @Override
    public void addToolTip(String localizedToolTip) {
        this.tooltips.addToolTip(localizedToolTip);
    }

    @Override
    public void setToolTipList(List<String> toolTips) {
        this.tooltips.setToolTipList(toolTips);
    }

    @Override
    public void drawToolTip(int mx, int my) {
        VLElement ci = this.indices.get(this.currentIndex);
        if (ci != null && ci instanceof IGuiDrawTooltip) {
            ((IGuiDrawTooltip)((Object)ci)).drawToolTip(mx, my);
        }
    }

    @Override
    public void drawHoverText(List<String> list, int x, int y) {
        this.gui.drawHoverText(list, x, y);
    }

    @Override
    public boolean isInGUI(int x, int y) {
        return this.gui.isInBoxAndGUI(x, y, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize());
    }

    @Override
    public void onElementResize(@Nonnull VLElement ele) {
        if (ele.getXPosActualLargest() > this.getXPosActualLargest()) {
            this.xSize = ele.getXPosOffsetLargest();
        }
        if (ele.getYPosActualLargest() > this.getYPosActualLargest()) {
            this.ySize = ele.getXPosOffsetLargest();
        }
        this.gui.onElementResize(ele);
    }

    @Override
    public int getXSize() {
        if (this.hasIndex(this.currentIndex)) {
            return this.getCurrentIndex().getXSize();
        }
        return this.gui.getGuiSizeX();
    }

    @Override
    public int getYSize() {
        if (this.hasIndex(this.currentIndex)) {
            return this.getCurrentIndex().getYSize();
        }
        return this.gui.getGuiSizeY();
    }

    @Override
    public int getXPosActual() {
        return this.getGuiLeft();
    }

    @Override
    public int getYPosActual() {
        return this.getGuiTop();
    }
}

