/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.block;

import com.valkyrieofnight.vlib.lib.item.VLItemBlockSlab;
import com.valkyrieofnight.vlib.lib.module.feature.VLBlocks;
import com.valkyrieofnight.vlib.lib.sys.init.IModNamespace;
import com.valkyrieofnight.vlib.lib.sys.init.IRegisterSlab;
import com.valkyrieofnight.vlib.lib.sys.init.client.IRegisterModels;
import com.valkyrieofnight.vlib.lib.sys.item.tooltip.IProvideTooltipInfo;
import com.valkyrieofnight.vlib3.core.util.client.LangUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VLBlockSlab
extends BlockSlab
implements IRegisterModels,
IRegisterSlab,
IModNamespace,
IProvideTooltipInfo {
    private String blockName;
    private VLBlockSlab otherSlab;
    private boolean doubleSlab = false;
    protected VLItemBlockSlab itemBlock;
    public static final PropertyEnum PROP = PropertyEnum.func_177709_a((String)"prop", EnumSlabDummy.class);
    private boolean playerBreakOnly = false;

    private VLBlockSlab(String blockName, Material mat, boolean doubleSlab) {
        super(mat);
        this.doubleSlab = doubleSlab;
        this.blockName = blockName;
        this.func_149663_c(this.getModNamespace() + "." + blockName);
        this.setRegistryName(this.getModNamespace(), blockName);
        if (!doubleSlab) {
            this.field_149783_u = true;
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)PROP, (Comparable)((Object)EnumSlabDummy.NORMAL)));
        }
    }

    public VLBlockSlab(String blockName, Material mat, VLBlocks vb) {
        this(blockName, mat, false);
        final String mns = this.getModNamespace();
        final String mn = this.getModNameLocalized();
        this.otherSlab = new VLBlockSlab(blockName + "_double", mat, true){

            @Override
            public String getModNamespace() {
                return mns;
            }

            @Override
            public String getModNameLocalized() {
                return mn;
            }
        };
        this.otherSlab.setOtherSlab(this);
        vb.addBlock((Block)this.otherSlab);
    }

    @Override
    public ItemBlock getItemBlock() {
        if (!this.doubleSlab) {
            this.otherSlab.func_149752_b(this.field_149781_w);
            this.otherSlab.func_149711_c(this.field_149782_v);
            this.otherSlab.setPlayerBreakOnly(this.playerBreakOnly);
            this.otherSlab.setHarvestLevel(this.getHarvestTool(this.func_176223_P()), this.getHarvestLevel(this.func_176223_P()));
            if (this.itemBlock == null) {
                this.itemBlock = new VLItemBlockSlab(this);
            }
            return this.itemBlock;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasShiftTooltipInfo() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftTooltipInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.playerBreakOnly()) {
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.witherproof"));
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.playerbreakonly"));
        }
    }

    private void setOtherSlab(VLBlockSlab slab) {
        this.otherSlab = slab;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        if (!this.isDoubleSlab()) {
            ModelLoader.setCustomModelResourceLocation((Item)this.itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)this.otherSlab.getItemBlock(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public Item func_180660_a(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        if (this.doubleSlab) {
            return Item.func_150898_a((Block)this.otherSlab);
        }
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return super.quantityDropped(state, fortune, random);
    }

    public BlockSlab getFullBlock() {
        if (this.doubleSlab) {
            return this;
        }
        return this.otherSlab;
    }

    public BlockSlab getOtherSlab() {
        return this.otherSlab;
    }

    public BlockStateContainer func_180661_e() {
        return this.doubleSlab ? new BlockStateContainer((Block)this, new IProperty[]{PROP}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, PROP});
    }

    public IBlockState func_176203_a(int meta) {
        if (this.doubleSlab) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 8 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        if (this.doubleSlab) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.doubleSlab) {
            return new ItemStack((Block)this.otherSlab);
        }
        return new ItemStack((Block)this);
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    @Override
    public boolean isDoubleSlab() {
        return this.func_176552_j();
    }

    public boolean func_176552_j() {
        return this.doubleSlab;
    }

    public IProperty<?> func_176551_l() {
        return PROP;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumSlabDummy.NORMAL;
    }

    public boolean playerBreakOnly() {
        return this.doubleSlab ? this.otherSlab.playerBreakOnly() : this.playerBreakOnly;
    }

    public void setPlayerBreakOnly(boolean opt) {
        this.playerBreakOnly = opt;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        return !this.playerBreakOnly();
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.playerBreakOnly()) {
            world.func_175698_g(pos);
            this.func_180652_a(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (this.playerBreakOnly()) {
            return false;
        }
        return super.func_149659_a(explosionIn);
    }

    public static enum EnumSlabDummy implements IStringSerializable
    {
        NORMAL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

