/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerDataEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftblib.lib.EnumMessageLocation;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.PlayerData;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.TeleporterDimPos;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.IScheduledTask;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentParser;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.BlockDimPosStorage;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesPlayerData
extends PlayerData {
    private boolean renderBadge = true;
    private boolean disableGlobalBadge = false;
    private boolean enablePVP = true;
    private String nickname = "";
    private EnumMessageLocation afkMesageLocation = EnumMessageLocation.CHAT;
    public ForgeTeam lastChunkTeam;
    public final Collection<ForgePlayer> tpaRequestsFrom;
    public long afkTime;
    private ITextComponent cachedNameForChat;
    private BlockDimPos lastDeath;
    private BlockDimPos lastSafePos;
    private long[] lastTeleport;
    public final BlockDimPosStorage homes = new BlockDimPosStorage();
    private boolean fly;

    public static FTBUtilitiesPlayerData get(ForgePlayer player) {
        return (FTBUtilitiesPlayerData)player.getData().get("ftbutilities");
    }

    @SubscribeEvent
    public static void registerPlayerData(ForgePlayerDataEvent event) {
        event.register((PlayerData)new FTBUtilitiesPlayerData(event.getPlayer()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (ServerUtils.isFirstLogin((EntityPlayer)player, (String)"ftbutilities_starting_items") && FTBUtilitiesConfig.login.enable_starting_items) {
            for (ItemStack stack : FTBUtilitiesConfig.login.getStartingItems()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
            }
        }
        if (FTBUtilitiesConfig.login.enable_motd) {
            for (ITextComponent t : FTBUtilitiesConfig.login.getMOTD()) {
                player.func_145747_a(t);
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(ForgePlayerLoggedOutEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        FTBUtilitiesUniverseData.updateBadge(event.getPlayer().getId());
    }

    @SubscribeEvent
    public static void getPlayerSettings(ForgePlayerConfigEvent event) {
        FTBUtilitiesPlayerData.get(event.getPlayer()).addConfig(event.getConfig());
    }

    private FTBUtilitiesPlayerData(ForgePlayer player) {
        super(player);
        this.tpaRequestsFrom = new HashSet<ForgePlayer>();
        this.lastTeleport = new long[Timer.VALUES.length];
    }

    public String func_176610_l() {
        return "ftbutilities";
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("RenderBadge", this.renderBadge);
        nbt.func_74757_a("DisableGlobalBadges", this.disableGlobalBadge);
        nbt.func_74757_a("EnablePVP", this.enablePVP);
        nbt.func_74782_a("Homes", (NBTBase)this.homes.serializeNBT());
        nbt.func_74757_a("AllowFlying", this.fly);
        if (this.lastDeath != null) {
            nbt.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        nbt.func_74778_a("Nickname", this.nickname);
        nbt.func_74778_a("AFK", EnumMessageLocation.NAME_MAP.getName((Object)this.afkMesageLocation));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.renderBadge = !nbt.func_74764_b("RenderBadge") || nbt.func_74767_n("RenderBadge");
        this.disableGlobalBadge = nbt.func_74767_n("DisableGlobalBadges");
        this.enablePVP = !nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP");
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.fly = nbt.func_74767_n("AllowFlying");
        this.lastDeath = BlockDimPos.fromIntArray((int[])nbt.func_74759_k("LastDeath"));
        this.nickname = nbt.func_74779_i("Nickname");
        this.afkMesageLocation = (EnumMessageLocation)EnumMessageLocation.NAME_MAP.get(nbt.func_74779_i("AFK"));
    }

    private void addConfig(ConfigGroup main) {
        ConfigGroup config = main.getGroup("ftbutilities");
        config.setDisplayName((ITextComponent)new TextComponentString("FTB Utilities"));
        config.addBool("render_badge", () -> this.renderBadge, v -> {
            this.renderBadge = v;
        }, true);
        config.addBool("disable_global_badge", () -> this.disableGlobalBadge, v -> {
            this.disableGlobalBadge = v;
        }, false);
        config.addBool("enable_pvp", () -> this.enablePVP, v -> {
            this.enablePVP = v;
        }, true);
        if (FTBUtilitiesConfig.commands.nick && this.player.hasPermission("ftbutilities.chat.nickname.set")) {
            config.addString("nickname", () -> this.nickname, v -> {
                this.nickname = v;
            }, "");
        }
        if (FTBUtilitiesConfig.afk.isEnabled(this.player.team.universe.server)) {
            config.addEnum("afk", () -> this.afkMesageLocation, v -> {
                this.afkMesageLocation = v;
            }, EnumMessageLocation.NAME_MAP);
        }
    }

    public boolean renderBadge() {
        return this.renderBadge;
    }

    public boolean disableGlobalBadge() {
        return this.disableGlobalBadge;
    }

    public boolean enablePVP() {
        return this.enablePVP;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String name) {
        this.nickname = name.equals(this.player.func_176610_l()) ? "" : name;
        this.player.markDirty();
        this.clearCache();
    }

    public EnumMessageLocation getAFKMessageLocation() {
        return this.afkMesageLocation;
    }

    public void setFly(boolean v) {
        this.fly = v;
        this.player.markDirty();
    }

    public boolean getFly() {
        return this.fly;
    }

    public void setLastDeath(@Nullable BlockDimPos pos) {
        this.lastDeath = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastDeath() {
        return this.lastDeath;
    }

    public void setLastSafePos(@Nullable BlockDimPos pos) {
        this.lastSafePos = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastSafePos() {
        return this.lastSafePos;
    }

    public void checkTeleportCooldown(ICommandSender sender, Timer timer) throws CommandException {
        long cooldown = this.lastTeleport[timer.ordinal()] + this.player.getRankConfig(timer.cooldown).getTimer().millis() - System.currentTimeMillis();
        if (cooldown > 0L) {
            throw FTBLib.error((ICommandSender)sender, (String)"cant_use_now_cooldown", (Object[])new Object[]{StringUtils.getTimeString((long)cooldown)});
        }
    }

    public void clearCache() {
        this.cachedNameForChat = null;
        if (this.player.isOnline()) {
            this.player.getPlayer().refreshDisplayName();
        }
    }

    public ITextComponent getNameForChat() {
        if (this.cachedNameForChat != null) {
            return this.cachedNameForChat;
        }
        String text = this.player.getRankConfig(FTBUtilitiesPermissions.CHAT_NAME_FORMAT).getString();
        try {
            this.cachedNameForChat = TextComponentParser.parse((String)text, (Function)FTBLibCommon.chatFormattingSubstituteFunction((ForgePlayer)this.player));
        }
        catch (Exception ex) {
            String s = "Error parsing " + text + ": " + ex.getLocalizedMessage();
            FTBUtilities.LOGGER.error(s);
            this.cachedNameForChat = new TextComponentString("BrokenFormatting");
            this.cachedNameForChat.func_150256_b().func_150238_a(TextFormatting.RED);
            this.cachedNameForChat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(s)));
        }
        this.cachedNameForChat.func_150258_a(" ");
        return this.cachedNameForChat;
    }

    private static class TeleportTask
    implements IScheduledTask {
        private final EntityPlayerMP player;
        private final Timer timer;
        private final BlockDimPos startPos;
        private final Function<EntityPlayerMP, TeleporterDimPos> pos;
        private final float startHP;
        private final int startSeconds;
        private final int secondsLeft;
        private final IScheduledTask extraTask;

        private TeleportTask(EntityPlayerMP p, Timer t, int ss, int s, Function<EntityPlayerMP, TeleporterDimPos> to, @Nullable IScheduledTask e) {
            this.player = p;
            this.timer = t;
            this.startPos = new BlockDimPos((Entity)this.player);
            this.startHP = this.player.func_110143_aJ();
            this.pos = to;
            this.startSeconds = ss;
            this.secondsLeft = s;
            this.extraTask = e;
        }

        public void execute(Universe universe) {
            if (!this.startPos.equalsPos(new BlockDimPos((Entity)this.player)) || this.startHP > this.player.func_110143_aJ()) {
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still_failed", (Object[])new Object[0]), (TextFormatting)TextFormatting.RED), true);
            } else if (this.secondsLeft <= 1) {
                TeleporterDimPos teleporter = this.pos.apply(this.player);
                if (teleporter != null) {
                    teleporter.teleport((Entity)this.player);
                    if (this.player.func_184187_bx() != null) {
                        teleporter.teleport(this.player.func_184187_bx());
                    }
                    FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)this.player));
                    ((FTBUtilitiesPlayerData)data).lastTeleport[this.timer.ordinal()] = System.currentTimeMillis();
                    if (this.secondsLeft != 0) {
                        this.player.func_146105_b(FTBLib.lang((ICommandSender)this.player, (String)"teleporting", (Object[])new Object[0]), true);
                    }
                    if (this.extraTask != null) {
                        this.extraTask.execute(universe);
                    }
                }
            } else {
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(this.player, this.timer, this.startSeconds, this.secondsLeft - 1, this.pos, this.extraTask));
                this.player.func_146105_b((ITextComponent)new TextComponentString(Integer.toString(this.secondsLeft - 1)), true);
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still", (Object[])new Object[]{this.startSeconds}).func_150258_a(" [" + (this.secondsLeft - 1) + "]"), (TextFormatting)TextFormatting.GOLD), true);
            }
        }
    }

    public static enum Timer {
        HOME(FTBUtilitiesPermissions.HOMES_COOLDOWN, FTBUtilitiesPermissions.HOMES_WARMUP),
        WARP(FTBUtilitiesPermissions.WARPS_COOLDOWN, FTBUtilitiesPermissions.WARPS_WARMUP),
        BACK(FTBUtilitiesPermissions.BACK_COOLDOWN, FTBUtilitiesPermissions.BACK_WARMUP),
        SPAWN(FTBUtilitiesPermissions.SPAWN_COOLDOWN, FTBUtilitiesPermissions.SPAWN_WARMUP),
        TPA(FTBUtilitiesPermissions.TPA_COOLDOWN, FTBUtilitiesPermissions.TPA_WARMUP),
        RTP(FTBUtilitiesPermissions.RTP_COOLDOWN, FTBUtilitiesPermissions.RTP_WARMUP);

        public static final Timer[] VALUES;
        private final Node cooldown;
        private final Node warmup;

        private Timer(Node c, Node w) {
            this.cooldown = c;
            this.warmup = w;
        }

        public void teleport(EntityPlayerMP player, Function<EntityPlayerMP, TeleporterDimPos> pos, @Nullable IScheduledTask extraTask) {
            Universe universe = Universe.get();
            int seconds = (int)RankConfigAPI.get((EntityPlayerMP)player, (Node)this.warmup).getTimer().seconds();
            if (seconds > 0) {
                player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)player, (String)"stand_still", (Object[])new Object[]{seconds}).func_150258_a(" [" + seconds + "]"), (TextFormatting)TextFormatting.GOLD), true);
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(player, this, seconds, seconds, pos, extraTask));
            } else {
                new TeleportTask(player, this, 0, 0, pos, extraTask).execute(universe);
            }
        }

        static {
            VALUES = Timer.values();
        }
    }
}

