/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom.component;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.FluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IItemStacksRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsRecipeComponent;

public class IngredientsAndFluidStackRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IItemStacksRecipeComponent,
IFluidStackRecipeComponent {
    private final IngredientsRecipeComponent ingredient;
    private final FluidStackRecipeComponent fluidStack;
    private float chance;

    public IngredientsAndFluidStackRecipeComponent(NonNullList<Ingredient> ingredient, FluidStack fluidStack) {
        this.ingredient = new IngredientsRecipeComponent(ingredient);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    public IngredientsAndFluidStackRecipeComponent(List<IngredientRecipeComponent> ingredientComponents, FluidStack fluidStack) {
        this.ingredient = new IngredientsRecipeComponent(ingredientComponents);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    @Override
    public List<ItemStack> getIngredients() {
        return this.ingredient.getIngredients();
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack.getFluidStack();
    }

    public List<IngredientRecipeComponent> getSubIngredientComponents() {
        return this.ingredient.getSubIngredientComponents();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngredientsAndFluidStackRecipeComponent)) {
            return false;
        }
        IngredientsAndFluidStackRecipeComponent that = (IngredientsAndFluidStackRecipeComponent)o;
        if (!this.fluidStack.equals(that.fluidStack)) {
            return false;
        }
        return this.ingredient.equals(that.ingredient);
    }

    public int hashCode() {
        int result = this.ingredient.hashCode();
        result = 31 * result + this.fluidStack.hashCode();
        return result;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public String toString() {
        return "IngredientsAndFluidStackRecipeComponent(ingredient=" + this.ingredient + ", fluidStack=" + this.getFluidStack() + ", chance=" + this.getChance() + ")";
    }
}

