/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.util;

import it.zerono.mods.zerocore.internal.ZeroCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class CodeHelper {
    public static String getModIdFromActiveModContainer() {
        String modId;
        ModContainer mc = Loader.instance().activeModContainer();
        String string = modId = null != mc ? mc.getModId() : null;
        if (null == modId || modId.isEmpty()) {
            throw new RuntimeException("Cannot retrieve the MOD ID from FML");
        }
        return modId;
    }

    public static IThreadListener getClientThreadListener() {
        return ZeroCore.getProxy().getClientThreadListener();
    }

    public static IThreadListener getServerThreadListener() {
        return ZeroCore.getProxy().getServerThreadListener();
    }

    public static String i18nValue(boolean value) {
        return I18n.func_135052_a((String)(value ? "debug.zerocore.true" : "debug.zerocore.false"), (Object[])new Object[0]);
    }

    public static void sendChatMessage(@Nonnull ICommandSender sender, @Nonnull ITextComponent component) {
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_146105_b(component, false);
        } else {
            sender.func_145747_a(component);
        }
    }

    public static void sendStatusMessage(@Nonnull EntityPlayer player, @Nonnull ITextComponent message) {
        ZeroCore.getProxy().sendPlayerStatusMessage(player, message);
    }

    public static boolean runningInDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static NBTTagCompound nbtLoadFrom(File file) {
        if (null == file) {
            throw new IllegalArgumentException("The file to read from cannot be null");
        }
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            return nBTTagCompound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static boolean nbtSaveTo(File file, NBTTagCompound data) {
        if (null == file) {
            throw new IllegalArgumentException("The file to write to cannot be null");
        }
        if (null == data) {
            throw new IllegalArgumentException("The data to write cannot be null");
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static float mathLerp(float from, float to, float modifier) {
        modifier = Math.min(1.0f, Math.max(0.0f, modifier));
        return from + modifier * (to - from);
    }

    public static int mathVolume(BlockPos minimum, BlockPos maximum) {
        return minimum == null || maximum == null ? 0 : CodeHelper.mathVolume(minimum.func_177958_n(), minimum.func_177956_o(), minimum.func_177952_p(), maximum.func_177958_n(), maximum.func_177956_o(), maximum.func_177952_p());
    }

    public static int mathVolume(int x1, int y1, int z1, int x2, int y2, int z2) {
        int cx = Math.abs(x2 - x1) + 1;
        int cy = Math.abs(y2 - y1) + 1;
        int cz = Math.abs(z2 - z1) + 1;
        return cx * cy * cz;
    }

    public static int argb(float red, float green, float blue, float alpha) {
        return CodeHelper.argb(MathHelper.func_76141_d((float)(red * 255.0f)), MathHelper.func_76141_d((float)(green * 255.0f)), MathHelper.func_76141_d((float)(blue * 255.0f)), MathHelper.func_76141_d((float)(alpha * 255.0f)));
    }

    public static int argb(int red, int green, int blue, int alpha) {
        int color = (alpha << 8) + red;
        color = (color << 8) + green;
        color = (color << 8) + blue;
        return color;
    }
}

