/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.attributes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.world.WorldGenAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GenAttributeRockCrystals
extends WorldGenAttribute {
    private final ConfigEntry entry;
    private boolean doGenerate = false;
    private boolean doIgnoreBiomeSpecifications = true;
    private boolean doIgnoreDimensionSpecifications = true;
    private List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    private List<Integer> applicableDimensions = new ArrayList<Integer>();
    private int crystalDensity = 15;
    private List<IBlockState> replaceableStates = null;
    private List<String> replaceableStatesSerialized = new ArrayList<String>();

    public GenAttributeRockCrystals() {
        super(0);
        this.entry = new ConfigEntry(ConfigEntry.Section.WORLDGEN, "rockcrystals"){

            @Override
            public void loadFromConfig(Configuration cfg) {
                GenAttributeRockCrystals.this.doGenerate = cfg.getBoolean("Generate", this.getConfigurationSection(), true, "Generate " + this.getKey());
                GenAttributeRockCrystals.this.doIgnoreBiomeSpecifications = cfg.getBoolean("IgnoreBiomeSpecification", this.getConfigurationSection(), GenAttributeRockCrystals.this.doIgnoreBiomeSpecifications, "Ignore Biome specifications when trying to generate " + this.getKey());
                GenAttributeRockCrystals.this.doIgnoreDimensionSpecifications = cfg.getBoolean("IgnoreDimensionSettings", this.getConfigurationSection(), GenAttributeRockCrystals.this.doIgnoreDimensionSpecifications, "Ignore dimension-whitelist when trying to generate " + this.getKey());
                GenAttributeRockCrystals.this.crystalDensity = cfg.getInt("CrystalDensity", this.getConfigurationSection(), GenAttributeRockCrystals.this.crystalDensity, 1, 40, "Defines how rarely Rock crystal ores spawn. The higher, the more rare.");
                String[] strTypes = cfg.getStringList("BiomeTypes", this.getConfigurationSection(), new String[0], "Set the BiomeTypes (according to the BiomeDicitionary) this structure will spawn in.");
                LinkedList<BiomeDictionary.Type> resolvedTypes = new LinkedList<BiomeDictionary.Type>();
                for (String s : strTypes) {
                    try {
                        resolvedTypes.add(BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                    }
                    catch (Exception e) {
                        AstralSorcery.log.error("Could not find BiomeType by name '" + s + "' - Ignoring BiomeType specification for structure " + this.getKey());
                    }
                }
                GenAttributeRockCrystals.this.biomeTypes = Lists.newArrayList(resolvedTypes);
                String[] dimensionWhitelist = cfg.getStringList("DimensionWhitelist", this.getConfigurationSection(), new String[0], "Define an array of dimensionID's where the structure is allowed to spawn in.");
                GenAttributeRockCrystals.this.applicableDimensions = new ArrayList();
                for (String s : dimensionWhitelist) {
                    try {
                        GenAttributeRockCrystals.this.applicableDimensions.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException exc) {
                        AstralSorcery.log.error("Could not add " + s + " to dimension whitelist for " + this.getKey() + " - It is not a number!");
                    }
                }
                String[] applicableReplacements = cfg.getStringList("ReplacementStates", this.getConfigurationSection(), new String[]{"minecraft:stone:0"}, "Defines the blockstates that may be replaced by rock crystal ore when trying to generate a rock crystal ore. format: <modid>:<name>:<meta> - Use meta -1 for wildcard");
                GenAttributeRockCrystals.this.replaceableStatesSerialized = Arrays.asList(applicableReplacements);
            }
        };
        Config.addDynamicEntry(this.entry);
    }

    private boolean isApplicableWorld(World world) {
        if (this.doIgnoreDimensionSpecifications) {
            return true;
        }
        Integer dimId = world.field_73011_w.getDimension();
        if (this.applicableDimensions.isEmpty()) {
            return false;
        }
        for (Integer dim : this.applicableDimensions) {
            if (!dim.equals(dimId)) continue;
            return true;
        }
        return false;
    }

    private boolean fitsBiome(World world, BlockPos pos) {
        if (this.doIgnoreBiomeSpecifications) {
            return true;
        }
        Biome b = world.func_180494_b(pos);
        Set types = BiomeDictionary.getTypes((Biome)b);
        if (types.isEmpty()) {
            return false;
        }
        boolean applicable = false;
        for (BiomeDictionary.Type t : types) {
            if (!this.biomeTypes.contains(t)) continue;
            applicable = true;
        }
        return applicable;
    }

    private void resolveReplaceableStates() {
        this.replaceableStates = new LinkedList<IBlockState>();
        for (String stateStr : this.replaceableStatesSerialized) {
            Integer meta;
            String[] spl = stateStr.split(":");
            if (spl.length != 3) {
                AstralSorcery.log.info("Skipping invalid replacement state: " + stateStr);
                continue;
            }
            String strMeta = spl[2];
            try {
                meta = Integer.parseInt(strMeta);
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - Its 'meta' is not a number!");
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(spl[0], spl[1]));
            if (b == null || b == Blocks.field_150350_a) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - The block does not exist!");
                continue;
            }
            if (meta == -1) {
                this.replaceableStates.addAll((Collection<IBlockState>)b.func_176194_O().func_177619_a());
                continue;
            }
            this.replaceableStates.add(b.func_176203_a(meta.intValue()));
        }
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (this.replaceableStates == null) {
            this.resolveReplaceableStates();
        }
        if (this.doGenerate && random.nextInt(this.crystalDensity) == 0) {
            int xPos = chunkX * 16 + random.nextInt(16) + 8;
            int zPos = chunkZ * 16 + random.nextInt(16) + 8;
            int yPos = 2 + random.nextInt(4);
            BlockPos pos = new BlockPos(xPos, yPos, zPos);
            if (!this.fitsBiome(world, pos) || !this.isApplicableWorld(world)) {
                return;
            }
            IBlockState state = world.func_180495_p(pos);
            if (MiscUtils.getMatchingState(this.replaceableStates, state) != null) {
                IBlockState newState = BlocksAS.customOre.func_176223_P().func_177226_a(BlockCustomOre.ORE_TYPE, (Comparable)((Object)BlockCustomOre.OreType.ROCK_CRYSTAL));
                if (!world.func_175656_a(pos, newState)) {
                    return;
                }
                RockCrystalBuffer buf = (RockCrystalBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.ROCK_CRYSTAL);
                buf.addOre(pos);
                if (random.nextInt(4) == 0 && MiscUtils.getMatchingState(this.replaceableStates, state = world.func_180495_p(pos = pos.func_177982_a(random.nextInt(2), random.nextInt(2), random.nextInt(2)))) != null && world.func_175656_a(pos, newState)) {
                    buf.addOre(pos);
                }
            }
        }
    }
}

