/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.root;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.RootPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraftforge.fml.relauncher.Side;

public class VicioRootPerk
extends RootPerk
implements IPlayerTickPerk {
    private Map<StatBase, Map<UUID, Integer>> moveTrackMap = new HashMap<StatBase, Map<UUID, Integer>>();

    public VicioRootPerk(int x, int y) {
        super("vicio", Constellations.vicio, x, y);
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
        super.removePerkLogic(player, side);
        if (side == Side.SERVER) {
            this.moveTrackMap.computeIfAbsent(StatList.field_188100_j, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(StatList.field_188102_l, s -> new HashMap()).remove(player.func_110124_au());
        }
    }

    @Override
    public void clearCaches(Side side) {
        super.clearCaches(side);
        if (side == Side.SERVER) {
            this.moveTrackMap.clear();
        }
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER && player instanceof EntityPlayerMP) {
            UUID uuid = player.func_110124_au();
            StatisticsManagerServer manager = ((EntityPlayerMP)player).func_147099_x();
            int walked = manager.func_77444_a(StatList.field_188100_j);
            int sprint = manager.func_77444_a(StatList.field_188102_l);
            int lastWalked = this.moveTrackMap.computeIfAbsent(StatList.field_188100_j, s -> new HashMap()).computeIfAbsent(uuid, u -> walked);
            int lastSprint = this.moveTrackMap.computeIfAbsent(StatList.field_188102_l, s -> new HashMap()).computeIfAbsent(uuid, u -> sprint);
            float added = 0.0f;
            if (walked > lastWalked) {
                added += (float)(walked - lastWalked);
                this.moveTrackMap.get(StatList.field_188100_j).put(uuid, walked);
            }
            if (sprint > lastSprint) {
                added += (float)(sprint - lastSprint) * 1.2f;
                this.moveTrackMap.get(StatList.field_188102_l).put(uuid, sprint);
            }
            if (added > 0.0f) {
                added *= 0.0025f;
                added *= this.expMultiplier;
                added = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.expgain", added);
                ResearchManager.modifyExp(player, added);
            }
        }
    }
}

