/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;

public class KeySpawnLights
extends KeyPerk
implements IPlayerTickPerk {
    private int lightSpawnRate = 15;
    private int radiusToSpawnLight = 5;

    public KeySpawnLights(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeySpawnLights.this.lightSpawnRate = cfg.getInt("SpawnLightRate", this.getConfigurationSection(), KeySpawnLights.this.lightSpawnRate, 5, 100000, "Defines the rate in ticks a position to spawn a light in is attempted to be found near the player.");
                KeySpawnLights.this.radiusToSpawnLight = cfg.getInt("RadiusSpawnLight", this.getConfigurationSection(), KeySpawnLights.this.radiusToSpawnLight, 2, 10, "Defines the radius around the player the perk will search for a suitable position.");
            }
        });
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER && player.field_70173_aa % this.lightSpawnRate == 0) {
            for (int attempts = 4; attempts > 0; --attempts) {
                BlockPos pos = player.func_180425_c().func_177982_a(rand.nextInt(this.radiusToSpawnLight) * (rand.nextBoolean() ? 1 : -1), rand.nextInt(this.radiusToSpawnLight) * (rand.nextBoolean() ? 1 : -1), rand.nextInt(this.radiusToSpawnLight) * (rand.nextBoolean() ? 1 : -1));
                if (!MiscUtils.isChunkLoaded(player.func_130014_f_(), pos) || !TileIlluminator.illuminatorCheck.isStateValid(player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos)) || !player.func_130014_f_().func_175656_a(pos, BlocksAS.blockVolatileLight.func_176223_P())) continue;
                return;
            }
        }
    }
}

