/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.PerkAttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerAttributeMap {
    private Side side;
    private List<AbstractPerk> cacheAppliedPerks = new LinkedList<AbstractPerk>();
    private Map<PerkAttributeType, List<PerkAttributeModifier>> attributes = new HashMap<PerkAttributeType, List<PerkAttributeModifier>>();
    private List<PerkConverter> converters = new ArrayList<PerkConverter>();

    PlayerAttributeMap(Side side) {
        this.side = side;
    }

    public boolean applyModifier(EntityPlayer player, String type, PerkAttributeModifier modifier) {
        PerkAttributeType attributeType = AttributeTypeRegistry.getType(type);
        if (attributeType == null) {
            return false;
        }
        boolean noModifiers = this.getModifiersByType(attributeType, modifier.getMode()).isEmpty();
        List modifiers = this.attributes.computeIfAbsent(attributeType, t -> Lists.newArrayList());
        if (modifiers.contains(modifier)) {
            return false;
        }
        attributeType.onApply(player, this.side);
        if (noModifiers) {
            attributeType.onModeApply(player, modifier.getMode(), this.side);
        }
        return modifiers.add(modifier);
    }

    public boolean removeModifier(EntityPlayer player, String type, PerkAttributeModifier modifier) {
        PerkAttributeType attributeType = AttributeTypeRegistry.getType(type);
        if (attributeType == null) {
            return false;
        }
        if (this.attributes.computeIfAbsent(attributeType, t -> Lists.newArrayList()).remove(modifier)) {
            boolean completelyRemoved = this.attributes.get(attributeType).isEmpty();
            attributeType.onRemove(player, this.side, completelyRemoved);
            if (this.getModifiersByType(attributeType, modifier.getMode()).isEmpty()) {
                attributeType.onModeRemove(player, modifier.getMode(), this.side, completelyRemoved);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public PerkAttributeModifier convertModifier(@Nonnull PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
        for (PerkConverter converter : this.converters) {
            modifier = converter.convertModifier(modifier, owningPerk);
        }
        return modifier;
    }

    @Nonnull
    public Collection<PerkAttributeModifier> gainModifiers(@Nonnull PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
        ArrayList modifiers = Lists.newArrayList();
        for (PerkConverter converter : this.converters) {
            modifiers.addAll(converter.gainExtraModifiers(modifier, owningPerk));
        }
        return modifiers;
    }

    boolean markPerkApplied(AbstractPerk perk) {
        if (this.cacheAppliedPerks.contains(perk)) {
            return false;
        }
        return this.cacheAppliedPerks.add(perk);
    }

    boolean markPerkRemoved(AbstractPerk perk) {
        return this.cacheAppliedPerks.remove(perk);
    }

    boolean isPerkApplied(AbstractPerk perk) {
        return this.cacheAppliedPerks.contains(perk);
    }

    List<AbstractPerk> getCacheAppliedPerks() {
        return this.cacheAppliedPerks;
    }

    boolean applyConverter(EntityPlayer player, PerkConverter converter) {
        this.assertConvertersModifiable();
        if (this.converters.contains(converter)) {
            return false;
        }
        if (this.converters.add(converter)) {
            converter.onApply(player, this.side);
            return true;
        }
        return false;
    }

    boolean removeConverter(EntityPlayer player, PerkConverter converter) {
        this.assertConvertersModifiable();
        if (this.converters.remove(converter)) {
            converter.onRemove(player, this.side);
            return true;
        }
        return false;
    }

    void assertConvertersModifiable() {
        int appliedModifiers = 0;
        for (List<PerkAttributeModifier> modifiers : this.attributes.values()) {
            appliedModifiers += modifiers.size();
        }
        if (appliedModifiers > 0) {
            throw new IllegalStateException("Trying to modify PerkConverters while modifiers are applied!");
        }
    }

    private List<PerkAttributeModifier> getModifiersByType(PerkAttributeType type, PerkAttributeModifier.Mode mode) {
        return this.attributes.computeIfAbsent(type, t -> Lists.newArrayList()).stream().filter(mod -> mod.getMode() == mode).collect(Collectors.toList());
    }

    public float getModifier(String type) {
        return this.getModifier(type, Arrays.asList(PerkAttributeModifier.Mode.values()));
    }

    public float getModifier(String type, PerkAttributeModifier.Mode mode) {
        return this.getModifier(type, Lists.newArrayList((Object[])new PerkAttributeModifier.Mode[]{mode}));
    }

    public float getModifier(String type, Collection<PerkAttributeModifier.Mode> applicableModes) {
        PerkAttributeType attributeType = AttributeTypeRegistry.getType(type);
        if (attributeType == null) {
            return 1.0f;
        }
        float mod = 1.0f;
        if (applicableModes.contains((Object)PerkAttributeModifier.Mode.ADDITION)) {
            for (PerkAttributeModifier perkAttributeModifier : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.ADDITION)) {
                mod += perkAttributeModifier.getValue();
            }
        }
        if (applicableModes.contains((Object)PerkAttributeModifier.Mode.ADDED_MULTIPLY)) {
            float multiply = mod;
            for (PerkAttributeModifier modifier : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.ADDED_MULTIPLY)) {
                mod += multiply * modifier.getValue();
            }
        }
        if (applicableModes.contains((Object)PerkAttributeModifier.Mode.STACKING_MULTIPLY)) {
            for (PerkAttributeModifier perkAttributeModifier : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.STACKING_MULTIPLY)) {
                mod *= perkAttributeModifier.getValue();
            }
        }
        return mod;
    }

    public float modifyValue(String type, float value) {
        PerkAttributeType attributeType = AttributeTypeRegistry.getType(type);
        if (attributeType == null) {
            return value;
        }
        for (PerkAttributeModifier mod : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.ADDITION)) {
            value += mod.getValue();
        }
        float multiply = value;
        for (PerkAttributeModifier mod : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.ADDED_MULTIPLY)) {
            value += multiply * mod.getValue();
        }
        for (PerkAttributeModifier mod : this.getModifiersByType(attributeType, PerkAttributeModifier.Mode.STACKING_MULTIPLY)) {
            value *= mod.getValue();
        }
        return value;
    }
}

