/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;

public class PerkLevelManager {
    public static final PerkLevelManager INSTANCE = new PerkLevelManager();
    private final int LEVEL_CAP = 30;
    private Map<Integer, Integer> totalExpLevelRequired = new HashMap<Integer, Integer>();

    private PerkLevelManager() {
        this.setupLevels();
    }

    private void setupLevels() {
        for (int i = 1; i <= 30; ++i) {
            int prev = this.totalExpLevelRequired.getOrDefault(i - 1, 0);
            this.totalExpLevelRequired.put(i, prev + 150 + MathHelper.func_76128_c((double)Math.pow(2.0, i / 2 + 3)));
        }
    }

    public int getLevel(int totalExp) {
        if (totalExp <= 0) {
            return 1;
        }
        for (int i = 1; i <= 30; ++i) {
            if (totalExp >= this.totalExpLevelRequired.getOrDefault(i, Integer.MAX_VALUE)) continue;
            return i;
        }
        return 30;
    }

    public int getExpForLevel(int level) {
        if (level <= 1) {
            return 0;
        }
        if (level > 30) {
            level = 30;
        }
        return this.totalExpLevelRequired.get(level);
    }

    public float getNextLevelPercent(double totalExp) {
        int level = this.getLevel(MathHelper.func_76128_c((double)totalExp));
        if (level >= 30) {
            return 1.0f;
        }
        int nextLevel = this.totalExpLevelRequired.getOrDefault(level, 0);
        int prevLevel = this.totalExpLevelRequired.getOrDefault(level - 1, 0);
        return (float)(totalExp - (double)prevLevel) / (float)(nextLevel - prevLevel);
    }

    public int getLevelCap() {
        return 30;
    }
}

