/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public interface HerdableAnimal<T extends EntityLivingBase> {
    public static final Deque<HerdableAnimal> registryHerdable = new LinkedList<HerdableAnimal>();
    public static final List<ResourceLocation> blacklistedEntities = new LinkedList<ResourceLocation>();

    @Nullable
    public static <T extends EntityLivingBase> HerdableAnimal getHerdable(T entity) {
        ResourceLocation name = EntityList.func_191301_a(entity);
        if (name != null && blacklistedEntities.contains(name)) {
            return null;
        }
        for (HerdableAnimal herd : registryHerdable) {
            if (!herd.handles(entity)) continue;
            return herd;
        }
        return null;
    }

    public static void init() {
        HerdableAnimal.register(new Squid());
        HerdableAnimal.register(new GenericAnimal());
    }

    public static void register(HerdableAnimal herd) {
        registryHerdable.addLast(herd);
    }

    public <E extends EntityLivingBase> boolean handles(@Nonnull E var1);

    @Nonnull
    public List<ItemStack> getHerdingDropsTick(T var1, World var2, Random var3, float var4);

    @Nonnull
    default public <L extends EntityLiving> List<ItemStack> extractLootTable(L entity, World world, Random rand, float herdingLuck) {
        LootTable table = EntityUtils.getLootTable(entity);
        if (table == null) {
            return Lists.newArrayList();
        }
        LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
        builder.func_186473_a((DamageSource)CommonProxy.dmgSourceStellar).func_186472_a(entity).func_186469_a(herdingLuck);
        return table.func_186462_a(rand, builder.func_186471_a());
    }

    public static class HerdableAdapter
    implements ConfigDataAdapter<ConfigDataAdapter.DataSet.StringElement> {
        public static final HerdableAdapter INSTANCE = new HerdableAdapter();

        private HerdableAdapter() {
        }

        @Override
        public Iterable<ConfigDataAdapter.DataSet.StringElement> getDefaultDataSets() {
            return Collections.emptyList();
        }

        @Override
        public String getDataFileName() {
            return "herdable_animals_blacklist";
        }

        @Override
        public String getDescription() {
            return "Defines a list of animals that can not be used in an bootes ritual to gain drops from. List animals with their registry name (e.g. parrots would be 'minecraft:parrot')";
        }

        @Override
        @Nullable
        public Optional<ConfigDataAdapter.DataSet.StringElement> appendDataSet(String str) {
            blacklistedEntities.add(new ResourceLocation(str));
            return Optional.of(new ConfigDataAdapter.DataSet.StringElement(str));
        }

        @Override
        public void resetRegistry() {
            blacklistedEntities.clear();
        }
    }

    public static class Squid
    implements HerdableAnimal<EntitySquid> {
        @Override
        public <E extends EntityLivingBase> boolean handles(@Nonnull E entity) {
            return EntitySquid.class.isAssignableFrom(entity.getClass());
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntitySquid entity, World world, Random rand, float herdingLuck) {
            return this.extractLootTable(entity, world, rand, herdingLuck);
        }
    }

    public static class GenericAnimal
    implements HerdableAnimal<EntityAnimal> {
        @Override
        public <E extends EntityLivingBase> boolean handles(@Nonnull E entity) {
            return EntityAnimal.class.isAssignableFrom(entity.getClass());
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityAnimal entity, World world, Random rand, float herdingLuck) {
            return this.extractLootTable(entity, world, rand, herdingLuck);
        }
    }
}

