/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FluidRarityRegistry
implements ConfigDataAdapter<FluidRarityEntry> {
    private static final ResourceLocation CAP_FLUIDENTRY_NAME = new ResourceLocation("astralsorcery", "cap_chunk_fluid_fountain");
    public static FluidRarityRegistry INSTANCE = new FluidRarityRegistry();
    @CapabilityInject(value=ChunkFluidEntry.class)
    private static Capability<ChunkFluidEntry> CAPABILITY_CHUNK_FLUID = null;
    private static List<FluidRarityEntry> rarityList = new LinkedList<FluidRarityEntry>();

    private FluidRarityRegistry() {
    }

    @Override
    public Iterable<FluidRarityEntry> getDefaultDataSets() {
        LinkedList<FluidRarityEntry> entries = new LinkedList<FluidRarityEntry>();
        this.tryAddEntry("water", 14000, Integer.MAX_VALUE, Integer.MAX_VALUE, entries);
        this.tryAddEntry("lava", 7500, 4000000, 1000000, entries);
        this.tryAddEntry("crystaloil", 800, 600000, 400000, entries);
        this.tryAddEntry("empoweredoil", 200, 350000, 150000, entries);
        this.tryAddEntry("redstone", 500, 120000, 70000, entries);
        this.tryAddEntry("glowstone", 500, 120000, 70000, entries);
        this.tryAddEntry("ender", 250, 140000, 60000, entries);
        this.tryAddEntry("pyrotheum", 200, 200000, 120000, entries);
        this.tryAddEntry("cryotheum", 200, 200000, 120000, entries);
        this.tryAddEntry("refined_oil", 600, 480000, 400000, entries);
        this.tryAddEntry("refined_fuel", 550, 450000, 300000, entries);
        this.tryAddEntry("iron", 900, 600000, 350000, entries);
        this.tryAddEntry("gold", 600, 400000, 350000, entries);
        this.tryAddEntry("cobalt", 80, 150000, 150000, entries);
        this.tryAddEntry("ardite", 80, 150000, 150000, entries);
        this.tryAddEntry("emerald", 30, 60000, 90000, entries);
        this.tryAddEntry("fluidoil", 900, 500000, 350000, entries);
        this.tryAddEntry("fluidnitrodiesel", 450, 400000, 250000, entries);
        this.tryAddEntry("ic2uu_matter", 1, 600, 800, entries);
        this.tryAddEntry("ic2biomass", 600, 300000, 200000, entries);
        this.tryAddEntry("ic2biogas", 500, 250000, 150000, entries);
        this.tryAddEntry("mana", 1500, 550000, 120000, entries);
        this.tryAddEntry("nacre", 250, 150000, 250000, entries);
        return entries;
    }

    private void tryAddEntry(String fluidName, int rarity, int guaranteedAmt, int addRand, List<FluidRarityEntry> out) {
        out.add(new FluidRarityEntry(fluidName, rarity, guaranteedAmt, addRand));
    }

    @Override
    public String getDescription() {
        return "Defines fluid-rarities and amounts for the evershifting fountain's neromantic prime. The lower the relative rarity, the more rare the fluid. Format: <FluidName>;<guaranteedMbAmount>;<additionalRandomMbAmount>;<rarity>";
    }

    @Override
    public String getDataFileName() {
        return "fluid_rarities";
    }

    @Override
    public ConfigDataAdapter.LoadPhase getLoadPhase() {
        return ConfigDataAdapter.LoadPhase.INIT;
    }

    @Override
    @Nullable
    public Optional<FluidRarityEntry> appendDataSet(String str) {
        FluidRarityEntry entry = FluidRarityEntry.deserialize(str);
        if (entry == null) {
            return Optional.empty();
        }
        rarityList.add(entry);
        return Optional.of(entry);
    }

    @Override
    public void resetRegistry() {
        rarityList.clear();
    }

    @Nullable
    private static FluidRarityEntry selectFluidEntry(Random random) {
        FluidRarityEntry entry = (FluidRarityEntry)WeightedRandom.func_76271_a((Random)random, rarityList);
        if (entry.fluid == null || entry.fluid.equals(FluidRegistry.WATER)) {
            return null;
        }
        return entry;
    }

    @Nullable
    public static ChunkFluidEntry getChunkEntry(Chunk ch) {
        if (ch.hasCapability(CAPABILITY_CHUNK_FLUID, null)) {
            return (ChunkFluidEntry)ch.getCapability(CAPABILITY_CHUNK_FLUID, null);
        }
        return null;
    }

    @SubscribeEvent
    public void onChLoad(ChunkDataEvent.Load event) {
        ChunkFluidEntry entry;
        if (event.getChunk().hasCapability(CAPABILITY_CHUNK_FLUID, null) && (entry = (ChunkFluidEntry)event.getChunk().getCapability(CAPABILITY_CHUNK_FLUID, null)) != null && !entry.hadSomeData()) {
            World w = event.getWorld();
            long seed = w.func_72905_C();
            long chX = event.getChunk().field_76635_g;
            long chZ = event.getChunk().field_76647_h;
            seed ^= chX << 32;
            Random r = new Random(seed ^= chZ);
            for (int i = 0; i < r.nextInt(10); ++i) {
                r.nextLong();
            }
            FluidRarityEntry sample = FluidRarityRegistry.selectFluidEntry(r);
            if (sample != null && sample.fluid != null) {
                entry.generate(sample.fluid, sample.guaranteedAmount + r.nextInt(sample.additionalRandomAmount));
            } else {
                entry.generateEmpty();
            }
        }
    }

    @SubscribeEvent
    public void attachChunkCap(AttachCapabilitiesEvent<Chunk> chunkEvent) {
        chunkEvent.addCapability(CAP_FLUIDENTRY_NAME, (ICapabilityProvider)new ChunkFluidEntryProvider());
    }

    public static class ChunkFluidEntryFactory
    implements Callable<ChunkFluidEntry> {
        @Override
        public ChunkFluidEntry call() throws Exception {
            return new ChunkFluidEntry();
        }
    }

    public static class ChunkFluidEntryProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ChunkFluidEntry defaultImpl = new ChunkFluidEntry();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_CHUNK_FLUID;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNK_FLUID.cast((Object)this.defaultImpl) : null);
        }

        public NBTTagCompound serializeNBT() {
            return this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.defaultImpl.deserializeNBT(nbt);
        }
    }

    public static class ChunkFluidEntry
    implements INBTSerializable<NBTTagCompound> {
        private Fluid chunkFluid;
        private int mbRemaining;
        private boolean hadSomeData = false;

        public final boolean isValid() {
            return this.chunkFluid != null;
        }

        public final boolean hadSomeData() {
            return this.hadSomeData;
        }

        private void generate(Fluid fluid, int mbAmount) {
            this.chunkFluid = fluid;
            this.mbRemaining = mbAmount;
            this.hadSomeData = true;
            if (this.mbRemaining <= 0) {
                this.setEmpty();
            }
        }

        private void generateEmpty() {
            this.hadSomeData = true;
            this.setEmpty();
        }

        public int getMbRemaining() {
            if (!this.isValid()) {
                return 0;
            }
            return this.mbRemaining;
        }

        @Nullable
        public FluidStack tryDrain(int mbRequested, boolean consume) {
            if (!this.isValid()) {
                return null;
            }
            int drained = Math.min(mbRequested, this.mbRemaining);
            FluidStack generated = new FluidStack(this.chunkFluid, drained);
            if (consume) {
                this.mbRemaining -= drained;
                if (this.mbRemaining <= 0) {
                    this.setEmpty();
                }
            }
            return generated;
        }

        private void setEmpty() {
            this.chunkFluid = null;
            this.mbRemaining = 0;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74757_a("fluid_had", this.hadSomeData);
            if (this.chunkFluid != null) {
                cmp.func_74778_a("fluid_name", this.chunkFluid.getName());
                cmp.func_74768_a("fluid_amt", this.mbRemaining);
            }
            return cmp;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.hadSomeData = nbt.func_74767_n("fluid_had");
            if (nbt.func_74764_b("fluid_name")) {
                String fluidTest = nbt.func_74779_i("fluid_name");
                Fluid f = FluidRegistry.getFluid((String)fluidTest);
                if (f != null) {
                    this.chunkFluid = f;
                    this.mbRemaining = nbt.func_74762_e("fluid_amt");
                } else {
                    this.setEmpty();
                }
            } else {
                this.setEmpty();
            }
        }
    }

    public static class FluidRarityEntry
    extends WeightedRandom.Item
    implements ConfigDataAdapter.DataSet {
        private final String fluidNameTmp;
        public final Fluid fluid;
        public final int guaranteedAmount;
        public final int additionalRandomAmount;
        public final int rarity;

        private FluidRarityEntry(String fluidNameTmp, int rarity, int guaranteedAmount, int additionalRandomAmount) {
            super(rarity);
            this.fluidNameTmp = fluidNameTmp;
            this.fluid = null;
            this.rarity = rarity;
            this.guaranteedAmount = guaranteedAmount;
            this.additionalRandomAmount = additionalRandomAmount;
        }

        private FluidRarityEntry(Fluid fluid, int rarity, int guaranteedAmount, int additionalRandomAmount) {
            super(rarity);
            this.fluidNameTmp = null;
            this.fluid = fluid;
            this.rarity = rarity;
            this.guaranteedAmount = guaranteedAmount;
            this.additionalRandomAmount = additionalRandomAmount;
        }

        @Override
        @Nonnull
        public String serialize() {
            StringBuilder sb = new StringBuilder();
            if (this.fluid == null) {
                if (this.fluidNameTmp != null) {
                    sb.append(this.fluidNameTmp);
                } else {
                    sb.append("water");
                }
            } else {
                sb.append(this.fluid.getName());
            }
            sb.append(";").append(this.guaranteedAmount).append(";").append(this.additionalRandomAmount).append(";").append(this.rarity);
            return sb.toString();
        }

        @Nullable
        public static FluidRarityEntry deserialize(String str) {
            int rarity;
            int randomAmt;
            int guaranteed;
            String[] split = str.split(";");
            if (split.length != 4) {
                return null;
            }
            String fluidName = split[0];
            Fluid f = FluidRegistry.getFluid((String)fluidName);
            if (f == null) {
                AstralSorcery.log.info("Ignoring fluid " + fluidName + " for rarity registry - it doesn't exist in the current environment");
                return null;
            }
            String strGAmount = split[1];
            String strRAmount = split[2];
            String strRarity = split[3];
            try {
                guaranteed = Integer.parseInt(strGAmount);
                randomAmt = Integer.parseInt(strRAmount);
                rarity = Integer.parseInt(strRarity);
            }
            catch (NumberFormatException exc) {
                return null;
            }
            return new FluidRarityEntry(f, rarity, guaranteed, randomAmt);
        }
    }
}

