/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.BlockArrayRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class JournalPageStructure
implements IJournalPage {
    private BlockArray structure;
    private String unlocName;
    private Vector3 shift;

    public JournalPageStructure(BlockArray struct) {
        this(struct, null);
    }

    public JournalPageStructure(BlockArray struct, @Nullable String unlocName) {
        this(struct, unlocName, new Vector3());
    }

    public JournalPageStructure(BlockArray struct, @Nullable String unlocName, @Nonnull Vector3 shift) {
        this.structure = struct;
        this.unlocName = unlocName;
        this.shift = shift;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.structure, this.unlocName, this.shift.clone());
    }

    public static class Render
    implements IGuiRenderablePage {
        private final BlockArrayRenderHelper structRender;
        private final BlockArray blocks;
        private final Vector3 shift;
        private final List<Tuple<ItemStack, String>> descriptionStacks = new LinkedList<Tuple<ItemStack, String>>();
        private final String unlocName;
        private long totalRenderFrame = 0L;

        public Render(BlockArray structure, @Nullable String unlocName, @Nonnull Vector3 shift) {
            this.structRender = new BlockArrayRenderHelper(structure);
            this.blocks = structure;
            this.unlocName = unlocName;
            this.shift = shift;
            List<ItemStack> stacksNeeded = structure.getAsDescriptiveStacks();
            for (ItemStack stack : stacksNeeded) {
                if (stack.func_77973_b() instanceof UniversalBucket) {
                    FluidStack f = ((UniversalBucket)stack.func_77973_b()).getFluid(stack);
                    this.descriptionStacks.add(new Tuple<ItemStack, String>(stack, stack.func_190916_E() + "x " + I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[]{f.getLocalizedName()})));
                    continue;
                }
                this.descriptionStacks.add(new Tuple<ItemStack, String>(stack, stack.func_190916_E() + "x " + I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[0])));
            }
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            ++this.totalRenderFrame;
            this.renderStructure(offsetX, offsetY, pTicks);
            float shift = this.renderSizeDescription(offsetX, offsetY + 5.0f);
            if (this.unlocName != null) {
                this.renderHeadline(offsetX + shift, offsetY + 5.0f, this.unlocName);
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }

        @Override
        public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            Rectangle rect = this.drawInfoStar(offsetX + 160.0f, offsetY + 10.0f, zLevel, 15.0f, pTicks);
            if (rect.contains(mouseX, mouseY)) {
                RenderingUtils.renderBlueStackTooltip((int)offsetX + 160, (int)offsetY + 10, this.descriptionStacks, this.getStandardFontRenderer(), this.getRenderItem());
            }
        }

        private void renderHeadline(float offsetX, float offsetY, String unlocName) {
            String head = I18n.func_135052_a((String)unlocName, (Object[])new Object[0]);
            FontRenderer fr = this.getStandardFontRenderer();
            float scale = 1.3f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glDisable((int)2929);
            fr.func_175065_a(head, 0.0f, 0.0f, 0xDDDDDD, true);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private float renderSizeDescription(float offsetX, float offsetY) {
            Vec3i size = this.blocks.getSize();
            FontRenderer fr = this.getStandardFontRenderer();
            float scale = 1.3f;
            String desc = size.func_177958_n() + " - " + size.func_177956_o() + " - " + size.func_177952_p();
            float length = (float)fr.func_78256_a(desc) * scale;
            GL11.glPushMatrix();
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glDisable((int)2929);
            fr.func_175065_a(desc, 0.0f, 0.0f, 0xDDDDDD, true);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return length + 8.0f;
        }

        private void renderStructure(float offsetX, float offsetY, float pTicks) {
            Point2D.Double offset = this.renderOffset(offsetX + 8.0f, offsetY);
            if (Mouse.isButtonDown((int)0) && this.totalRenderFrame > 30L) {
                this.structRender.rotate(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
            }
            this.structRender.render3DGUI(offset.x + this.shift.getX(), offset.y + this.shift.getY(), pTicks);
        }

        private Point2D.Double renderOffset(float stdPageOffsetX, float stdPageOffsetY) {
            return new Point2D.Double((double)stdPageOffsetX + 70.0, (double)stdPageOffsetY + 146.66666666666666);
        }
    }
}

