/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkTree;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournalOverlay;
import hellfirepvp.astralsorcery.client.sky.RenderSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraManager;
import hellfirepvp.astralsorcery.client.util.obj.WavefrontObject;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.block.BlockObservatory;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.data.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeRevealer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHandRender;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHudRender;
import hellfirepvp.astralsorcery.common.item.tool.ItemSkyResonator;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopEffectHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ClientRenderEventHandler {
    private static final BindableResource texChargeFrame;
    private static final BindableResource texChargeCharge;
    public static final BindableResource texHUDItemFrame;
    public static final BindableResource texHUDItemFrameEx;
    private static final Map<ItemHudRender, ItemStackHudRenderInstance> ongoingItemRenders;
    private static final Random rand;
    private static final int fadeTicks = 15;
    private static final float visibilityChange = 0.06666667f;
    private static int chargePermRevealTicks;
    private static float visibilityPermCharge;
    private static int chargeTempRevealTicks;
    private static float visibilityTempCharge;
    private static final WavefrontObject obj;
    private static final ResourceLocation tex;
    private static int dList;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (Config.constellationSkyDimWhitelist.contains(world.field_73011_w.getDimension()) && !(world.field_73011_w.getSkyRenderer() instanceof RenderSkybox)) {
            world.field_73011_w.setSkyRenderer((IRenderHandler)new RenderSkybox((World)world, world.field_73011_w.getSkyRenderer()));
        }
        this.playHandAndHudRenders(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND), EnumHand.MAIN_HAND, event.getPartialTicks());
        this.playHandAndHudRenders(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.OFF_HAND), EnumHand.OFF_HAND, event.getPartialTicks());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiScreenJournal) {
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiScreenJournal && (event.getGui() == null || !(event.getGui() instanceof GuiScreenJournal) && !(event.getGui() instanceof GuiScreenJournalOverlay))) {
            SoundHelper.playSoundClient(Sounds.bookClose, 1.0f, 1.0f);
        }
    }

    public static void requestPermChargeReveal(int forTicks) {
        chargePermRevealTicks = forTicks;
    }

    public static void resetPermChargeReveal() {
        chargePermRevealTicks = 0;
        visibilityPermCharge = 0.0f;
    }

    public static void requestTempChargeReveal(int forTicks) {
        chargeTempRevealTicks = forTicks;
    }

    public static void resetTempChargeReveal() {
        chargeTempRevealTicks = 0;
        visibilityTempCharge = 0.0f;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null) {
            if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                PersistentDataManager.INSTANCE.setCreative();
            }
            this.playItemEffects(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND));
            this.playItemEffects(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.OFF_HAND));
            this.tickTimeFreezeEffects();
            if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiJournalPerkTree) {
                ClientRenderEventHandler.requestPermChargeReveal(20);
            }
            --chargeTempRevealTicks;
            if (--chargePermRevealTicks - 15 < 0) {
                if (visibilityPermCharge > 0.0f) {
                    visibilityPermCharge = Math.max(0.0f, visibilityPermCharge - 0.06666667f);
                }
            } else if (visibilityPermCharge < 1.0f) {
                visibilityPermCharge = Math.min(1.0f, visibilityPermCharge + 0.06666667f);
            }
            if (chargeTempRevealTicks - 15 < 0) {
                if (visibilityTempCharge > 0.0f) {
                    visibilityTempCharge = Math.max(0.0f, visibilityTempCharge - 0.06666667f);
                }
            } else if (visibilityTempCharge < 1.0f) {
                visibilityTempCharge = Math.min(1.0f, visibilityTempCharge + 0.06666667f);
            }
            Iterator<Map.Entry<ItemHudRender, ItemStackHudRenderInstance>> iterator = ongoingItemRenders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemHudRender, ItemStackHudRenderInstance> entry = iterator.next();
                ItemStackHudRenderInstance instance = entry.getValue();
                if (instance.active) {
                    instance.active = false;
                    continue;
                }
                if (instance.visibility <= 0.0f) {
                    iterator.remove();
                    continue;
                }
                instance.visibility = Math.max(0.0f, instance.visibility - instance.visibilityChange);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickTimeFreezeEffects() {
        List<TimeStopEffectHelper> effects;
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w != null && w.field_73011_w != null && (effects = ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.CLIENT, "TimeFreezeEffects")).client_getTimeStopEffects((World)w)) != null) {
            for (TimeStopEffectHelper helper : effects) {
                helper.playClientTickEffect();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playHandAndHudRenders(ItemStack inHand, EnumHand hand, float pTicks) {
        if (!inHand.func_190926_b()) {
            Item i = inHand.func_77973_b();
            if (i instanceof ItemHandRender) {
                ((ItemHandRender)i).onRenderWhileInHand(inHand, hand, pTicks);
            }
            if (i instanceof ItemHudRender && ((ItemHudRender)i).hasFadeIn()) {
                if (!ongoingItemRenders.containsKey(i)) {
                    ongoingItemRenders.put((ItemHudRender)i, new ItemStackHudRenderInstance(inHand, 1.0f / (float)((ItemHudRender)i).getFadeInTicks()));
                }
                ItemStackHudRenderInstance instance = ongoingItemRenders.get(i);
                instance.active = true;
                instance.stack = inHand;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playItemEffects(ItemStack inHand) {
        if (!inHand.func_190926_b()) {
            ItemStackHudRenderInstance instance;
            Item i = inHand.func_77973_b();
            if (i instanceof ItemAlignmentChargeRevealer) {
                if (((ItemAlignmentChargeRevealer)i).shouldReveal(ItemAlignmentChargeRevealer.ChargeType.PERM, inHand)) {
                    ClientRenderEventHandler.requestPermChargeReveal(20);
                }
                if (((ItemAlignmentChargeRevealer)i).shouldReveal(ItemAlignmentChargeRevealer.ChargeType.TEMP, inHand)) {
                    ClientRenderEventHandler.requestTempChargeReveal(20);
                }
            }
            if (i instanceof ItemSkyResonator) {
                ItemSkyResonator.ResonatorUpgrade upgrade = ItemSkyResonator.getCurrentUpgrade((EntityPlayer)Minecraft.func_71410_x().field_71439_g, inHand);
                upgrade.playResonatorEffects();
            }
            if (i instanceof ItemHudRender && (instance = ongoingItemRenders.get(i)) != null && instance.visibility < 1.0f) {
                instance.visibility = Math.min(1.0f, instance.visibility + instance.visibilityChange);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBoxDraw(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getPlayer().func_130014_f_().func_180495_p(event.getTarget().func_178782_a()).func_177230_c() instanceof BlockObservatory) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Item item;
            Item item2;
            ItemStack inHand;
            if (visibilityTempCharge > 0.0f) {
                SpriteSheetResource ssr = SpriteLibrary.spriteCharge;
                ssr.getResource().bindTexture();
                ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
                int width = scaledResolution.func_78326_a();
                int height = scaledResolution.func_78328_b();
                int barWidth = 194;
                int offsetLeft = width / 2 - barWidth / 2;
                int offsetTop = height + 3 - 54;
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                Tuple<Double, Double> uvPos = ssr.getUVOffset(ClientScheduler.getClientTick());
                float percFilled = Minecraft.func_71410_x().field_71439_g.func_184812_l_() ? 1.0f : PlayerChargeHandler.INSTANCE.clientCharge;
                double uLength = ssr.getULength() * (double)percFilled;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)visibilityTempCharge);
                Tessellator tes = Tessellator.func_178181_a();
                BufferBuilder vb = tes.func_178180_c();
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b((double)offsetLeft, (double)(offsetTop + 27), 10.0).func_187315_a(((Double)uvPos.key).doubleValue(), (Double)uvPos.value + ssr.getVLength()).func_181675_d();
                vb.func_181662_b((double)((float)offsetLeft + (float)barWidth * percFilled), (double)(offsetTop + 27), 10.0).func_187315_a((Double)uvPos.key + uLength, (Double)uvPos.value + ssr.getVLength()).func_181675_d();
                vb.func_181662_b((double)((float)offsetLeft + (float)barWidth * percFilled), (double)offsetTop, 10.0).func_187315_a((Double)uvPos.key + uLength, ((Double)uvPos.value).doubleValue()).func_181675_d();
                vb.func_181662_b((double)offsetLeft, (double)offsetTop, 10.0).func_187315_a(((Double)uvPos.key).doubleValue(), ((Double)uvPos.value).doubleValue()).func_181675_d();
                tes.func_78381_a();
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TextureHelper.refreshTextureBindState();
            }
            if (visibilityPermCharge > 0.0f) {
                this.renderAlignmentChargeOverlay(event.getPartialTicks());
            }
            if (!ongoingItemRenders.isEmpty()) {
                for (Map.Entry entry : new HashSet<Map.Entry<ItemHudRender, ItemStackHudRenderInstance>>(ongoingItemRenders.entrySet())) {
                    if (!((ItemHudRender)entry.getKey()).hasFadeIn()) {
                        ((ItemHudRender)entry.getKey()).onRenderInHandHUD(((ItemStackHudRenderInstance)entry.getValue()).stack, 1.0f, event.getPartialTicks());
                        continue;
                    }
                    ((ItemHudRender)entry.getKey()).onRenderInHandHUD(((ItemStackHudRenderInstance)entry.getValue()).stack, ((ItemStackHudRenderInstance)entry.getValue()).visibility, event.getPartialTicks());
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (!(inHand = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && (item2 = inHand.func_77973_b()) instanceof ItemHudRender && !((ItemHudRender)item2).hasFadeIn()) {
                ((ItemHudRender)item2).onRenderInHandHUD(inHand, 1.0f, event.getPartialTicks());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (!(inHand = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.OFF_HAND)).func_190926_b() && (item = inHand.func_77973_b()) instanceof ItemHudRender && !((ItemHudRender)item).hasFadeIn()) {
                ((ItemHudRender)item).onRenderInHandHUD(inHand, 1.0f, event.getPartialTicks());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAlignmentChargeOverlay(float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        float height = 128.0f;
        float width = 32.0f;
        float offsetX = 0.0f;
        float offsetY = 5.0f;
        texChargeFrame.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(visibilityPermCharge * 0.9f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)offsetX, (double)(offsetY + height), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)(offsetY + height), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)offsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)offsetX, (double)offsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        float filled = PerkLevelManager.INSTANCE.getNextLevelPercent(ResearchManager.clientProgress.getPerkExp());
        height = 78.0f;
        offsetY = 27.5f + (1.0f - filled) * height;
        GL11.glColor4f((float)1.0f, (float)0.9019608f, (float)0.0f, (float)(visibilityPermCharge * 0.9f));
        texChargeCharge.bind();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)offsetX, (double)(offsetY + (height *= filled)), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)(offsetY + height), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(offsetX + width), (double)offsetY, 10.0).func_187315_a(1.0, (double)(1.0f - filled)).func_181675_d();
        vb.func_181662_b((double)offsetX, (double)offsetY, 10.0).func_187315_a(0.0, (double)(1.0f - filled)).func_181675_d();
        tes.func_78381_a();
        GL11.glEnable((int)3008);
        TextureHelper.refreshTextureBindState();
        int level = PerkLevelManager.INSTANCE.getLevel(MathHelper.func_76128_c((double)ResearchManager.clientProgress.getPerkExp()));
        String strLevel = String.valueOf(level);
        int strLength = Minecraft.func_71410_x().field_71466_p.func_78256_a(strLevel);
        GL11.glColor4f((float)0.86f, (float)0.86f, (float)0.86f, (float)visibilityPermCharge);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 15.0f - (float)(strLength / 2)), (double)94.0, (double)0.0);
        GL11.glScaled((double)1.2, (double)1.2, (double)1.2);
        int c = 0xDDDDDD;
        c |= (int)(255.0f * visibilityPermCharge) << 24;
        if ((double)visibilityPermCharge > 1.0E-5) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(strLevel, 0.0f, 0.0f, c);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        TextureHelper.refreshTextureBindState();
        Blending.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouse(MouseEvent event) {
        if (ClientCameraManager.getInstance().hasActiveTransformer()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderPlayerEvent.Post event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (event.getEntityPlayer().func_110124_au().hashCode() != 1529485240) {
            return;
        }
        if (event.getEntityPlayer().func_184218_aH() || event.getEntityPlayer().func_184613_cA()) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
        boolean f = event.getEntityPlayer().field_71075_bZ.field_75100_b;
        double ma = f ? 15.0 : 5.0;
        double r = ma * ((double)Math.abs(ClientScheduler.getClientTick() % 80L - 40L) / 40.0) + (65.0 - ma) * Math.max(0.0, Math.min(1.0, new Vector3(event.getEntityPlayer().field_70159_w, 0.0, event.getEntityPlayer().field_70179_y).length()));
        float rot = RenderingUtils.interpolateRotation(event.getEntityPlayer().field_70760_ar, event.getEntityPlayer().field_70761_aq, event.getPartialRenderTick());
        GlStateManager.func_179114_b((float)(180.0f - rot), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.07, (double)0.07, (double)0.07);
        GlStateManager.func_179137_b((double)0.0, (double)5.5, (double)(0.7 - (double)((float)(r / ma)) * (f ? 0.5 : 0.2)));
        if (dList == -1) {
            dList = GLAllocation.func_74526_a((int)2);
            GlStateManager.func_187423_f((int)dList, (int)4864);
            obj.renderOnly(true, "wR");
            GlStateManager.func_187415_K();
            GlStateManager.func_187423_f((int)(dList + 1), (int)4864);
            obj.renderOnly(true, "wL");
            GlStateManager.func_187415_K();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)((float)(20.0 + r)), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)dList);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)((float)(20.0 + r)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)(dList + 1));
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    static {
        WavefrontObject buf;
        texChargeFrame = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "hud_charge_frame");
        texChargeCharge = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "hud_charge_charge");
        texHUDItemFrame = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "hud_item_frame");
        texHUDItemFrameEx = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "hud_item_frame_extender");
        ongoingItemRenders = new HashMap<ItemHudRender, ItemStackHudRenderInstance>();
        rand = new Random();
        chargePermRevealTicks = 0;
        visibilityPermCharge = 0.0f;
        chargeTempRevealTicks = 0;
        visibilityTempCharge = 0.0f;
        ResourceLocation mod = new ResourceLocation("astralsorcery:models/obj/modelassec.obj");
        try {
            buf = new WavefrontObject("astralSorcery:wrender", new GZIPInputStream(Minecraft.func_71410_x().func_110442_L().func_110536_a(mod).func_110527_b()));
        }
        catch (Exception exc) {
            buf = null;
        }
        obj = buf;
        tex = new ResourceLocation("astralsorcery:textures/models/texw.png");
        dList = -1;
    }

    private static class ItemStackHudRenderInstance {
        private ItemStack stack;
        private float visibility = 0.0f;
        private float visibilityChange;
        private boolean active = true;

        private ItemStackHudRenderInstance(ItemStack stack, float visibilityChange) {
            this.stack = stack;
            this.visibilityChange = visibilityChange;
        }
    }
}

