/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.network;

import io.netty.buffer.ByteBuf;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.network.PacketHandler;
import mcjty.lostcities.network.PacketReturnProfileToClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestProfile
implements IMessage {
    private int dimension;

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
    }

    public PacketRequestProfile() {
    }

    public PacketRequestProfile(int dimension) {
        this.dimension = dimension;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestProfile, IMessage> {
        public IMessage onMessage(PacketRequestProfile message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestProfile message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            LostCityProfile profile = WorldTypeTools.getProfile((World)DimensionManager.getWorld((int)message.dimension));
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketReturnProfileToClient(message.dimension, profile.getName()), player);
        }
    }
}

