/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.energy.tiles.TileEngineElectric;

public abstract class CircuitElectricChange
extends Circuit {
    private int euChange = 7;
    private int rfChange = 20;

    protected CircuitElectricChange(String uid) {
        super(uid);
    }

    protected void configureChange(int euChange, int rfChange) {
        this.euChange = euChange;
        this.rfChange = rfChange;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof TileEngineElectric;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        TileEngineElectric engine = (TileEngineElectric)tile;
        engine.changeEnergyConfig(this.euChange, this.rfChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        TileEngineElectric engine = (TileEngineElectric)tile;
        engine.changeEnergyConfig(-this.euChange, -this.rfChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

