/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.IWindowElement;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.widgets.IScrollable;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class ScrollBarElement
extends ElementGroup {
    private final GuiElement slider;
    private boolean isScrolling;
    private boolean wasClicked;
    private boolean vertical = false;
    private int currentValue;
    private final ElementGroup interactionField;
    private int initialMouseClick;
    @Nullable
    private IScrollable listener;
    private int minValue;
    private int maxValue;
    private int step;
    private boolean initialised = false;

    public ScrollBarElement(int xPos, int yPos, int width, int height, Drawable sliderTexture) {
        super(xPos, yPos, width, height);
        this.interactionField = this.add(new ElementGroup(0, 0, width, height));
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.slider = this.interactionField.drawable(sliderTexture);
    }

    public ScrollBarElement(int xPos, int yPos, Drawable backgroundTexture, boolean hasBorder, Drawable sliderTexture) {
        super(xPos, yPos, backgroundTexture.uWidth, backgroundTexture.vHeight);
        int offset = hasBorder ? 1 : 0;
        this.interactionField = new ElementGroup(offset, offset, hasBorder ? this.width - 2 : this.width, hasBorder ? this.height - 2 : this.height);
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.drawable(backgroundTexture);
        this.slider = this.interactionField.drawable(sliderTexture);
        this.add(this.interactionField);
    }

    public ScrollBarElement setVertical() {
        this.vertical = true;
        return this;
    }

    public ScrollBarElement setParameters(IScrollable listener, int minValue, int maxValue, int step) {
        this.listener = listener;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        if (this.initialised) {
            this.setValue(this.currentValue);
        }
        return this;
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)this.currentValue, (int)this.minValue, (int)this.maxValue);
    }

    public ScrollBarElement setValue(int value) {
        this.initialised = true;
        this.currentValue = MathHelper.func_76125_a((int)value, (int)this.minValue, (int)this.maxValue);
        if (this.listener != null) {
            this.listener.onScroll(this.currentValue);
        }
        if (this.vertical) {
            int offset = value >= this.maxValue ? this.interactionField.getWidth() - this.slider.width : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.interactionField.getWidth() - this.slider.width)));
            this.slider.setXPosition(offset);
        } else {
            int offset = value >= this.maxValue ? this.interactionField.getHeight() - this.slider.height : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.interactionField.getHeight() - this.slider.height)));
            this.slider.setYPosition(offset);
        }
        return this;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        IWindowElement window = this.getWindow();
        this.updateSlider(window.getRelativeMouseX(this.interactionField), window.getRelativeMouseY(this.interactionField));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawElement(mouseX, mouseY);
    }

    private void updateSlider(int mouseX, int mouseY) {
        int pos;
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (this.listener == null || this.listener.isFocused(mouseX, mouseY)) {
            int wheel = Mouse.getDWheel();
            if (wheel > 0) {
                this.setValue(this.currentValue - this.step);
                return;
            }
            if (wheel < 0) {
                this.setValue(this.currentValue + this.step);
                return;
            }
        }
        int n = pos = this.vertical ? mouseX - this.interactionField.getX() : mouseY - this.interactionField.getY();
        if (!mouseDown && this.wasClicked) {
            this.wasClicked = false;
        }
        if (!mouseDown && this.isScrolling) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            int range = this.maxValue - this.minValue;
            float value = (float)(pos - this.initialMouseClick) / (float)(this.vertical ? this.interactionField.getWidth() - this.slider.width : this.interactionField.getHeight() - this.slider.height);
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
        } else if (this.slider.isMouseOver()) {
            if (mouseDown) {
                this.isScrolling = true;
                this.initialMouseClick = this.vertical ? pos - this.slider.getX() : pos - this.slider.getY();
            }
        } else if (mouseDown && !this.wasClicked && this.isMouseOver()) {
            int range = this.maxValue - this.minValue;
            float value = ((float)pos - (float)(this.vertical ? this.slider.width : this.slider.height) / 2.0f) / (float)(this.vertical ? this.interactionField.getWidth() - this.slider.width : this.interactionField.getHeight() - this.slider.height);
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
            this.wasClicked = true;
        }
    }
}

