/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.items.armor.Boots;
import c4.conarm.common.items.armor.Chestplate;
import c4.conarm.common.items.armor.Helmet;
import c4.conarm.common.items.armor.Leggings;
import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import pl.asie.tinkeredhegemony.DisabledItemClass;
import pl.asie.tinkeredhegemony.MaterialMatcher;
import pl.asie.tinkeredhegemony.RecipeDummy;
import pl.asie.tinkeredhegemony.RecipeReplacement;
import pl.asie.tinkeredhegemony.RecipeTAPatchwork;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;
import slimeknights.tconstruct.tools.melee.item.BattleSign;
import slimeknights.tconstruct.tools.melee.item.BroadSword;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;
import slimeknights.tconstruct.tools.ranged.item.ShortBow;
import slimeknights.tconstruct.tools.tools.Hatchet;
import slimeknights.tconstruct.tools.tools.Mattock;
import slimeknights.tconstruct.tools.tools.Pickaxe;
import slimeknights.tconstruct.tools.tools.Shovel;

@Mod(modid="tinkeredhegemony", name="Tinkered Hegemony", dependencies="required-after:tconstruct", version="@VERSION@", updateJSON="http://asie.pl/files/minecraft/update/tinkeredhegemony.json", acceptedMinecraftVersions="[1.12.2]")
public class TinkeredHegemony {
    public static Logger logger;
    private static Configuration config;
    protected static final TObjectIntMap<Item> originalDurabilities;
    protected static final Set<DisabledItemClass> classMap;
    protected static final Set<Item> itemSet;
    static boolean lastSave;
    private boolean performRecipeReplacement;
    private boolean performRecipePatchwork;
    private boolean performItemDisabling;
    private boolean performItemNeutralizing;

    private void addIfConfigured(DisabledItemClass disabledItemClass, boolean def) {
        if (config.getBoolean(disabledItemClass.getName(), "disabledTypes", def, "")) {
            classMap.add(disabledItemClass);
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static Set<Item> getDisabledItems() {
        return itemSet;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        lastSave = false;
        this.performItemDisabling = config.getBoolean("performItemDisabling", "general", true, "Should vanilla item recipes be removed?");
        this.performItemNeutralizing = config.getBoolean("performItemNeutralizing", "general", true, "Should vanilla tool items be effectively nullified (maximum damage set to 1)?");
        this.performRecipePatchwork = config.getBoolean("performRecipePatchwork", "general", true, "Should Tinkers' Construct items be capable of replacing vanilla equivalents in recipes?");
        this.performRecipeReplacement = config.getBoolean("performRecipeReplacement", "general", true, "Should ingredients be replaced in compatible recipes? This will primarily affect recipe guides.");
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        if (this.performRecipePatchwork) {
            event.getRegistry().register(new RecipeTAPatchwork().setRegistryName("tinkeredhegemony:replacement"));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.addIfConfigured(new DisabledItemClass("pickaxe", i -> i instanceof ItemPickaxe, (Item)TinkerHarvestTools.pickaxe, Pickaxe.class, new IToolPart[]{TinkerTools.pickHead}), true);
        this.addIfConfigured(new DisabledItemClass("axe", i -> i instanceof ItemAxe, (Item)TinkerHarvestTools.hatchet, Hatchet.class, new IToolPart[]{TinkerTools.axeHead}), true);
        this.addIfConfigured(new DisabledItemClass("sword", i -> i instanceof ItemSword, (Item)TinkerMeleeWeapons.broadSword, BroadSword.class, new IToolPart[]{TinkerTools.swordBlade}), true);
        this.addIfConfigured(new DisabledItemClass("hoe", i -> i instanceof ItemHoe, (Item)TinkerHarvestTools.mattock, Mattock.class, new IToolPart[]{TinkerTools.axeHead, TinkerTools.shovelHead}), true);
        this.addIfConfigured(new DisabledItemClass("shovel", i -> i instanceof ItemSpade, (Item)TinkerHarvestTools.shovel, Shovel.class, new IToolPart[]{TinkerTools.shovelHead}), true);
        this.addIfConfigured(new DisabledItemClass("bow", i -> i instanceof ItemBow, (Item)TinkerRangedWeapons.shortBow, ShortBow.class, new IToolPart[]{TinkerTools.bowLimb}), true);
        this.addIfConfigured(new DisabledItemClass("shield", i -> i instanceof ItemShield, (Item)TinkerMeleeWeapons.battleSign, BattleSign.class, new IToolPart[]{TinkerTools.signHead}), false);
        if (Loader.isModLoaded((String)"conarm")) {
            this.supportConarm();
        }
        MaterialMatcher.init(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Optional.Method(modid="conarm")
    private void supportConarm() {
        this.addIfConfigured(new DisabledItemClass("helmet", i -> i instanceof ItemArmor && !(i instanceof ITinkerable) && ((ItemArmor)i).field_77881_a == EntityEquipmentSlot.HEAD, (Item)ConstructsRegistry.helmet, Helmet.class, new IToolPart[]{ConstructsRegistry.helmetCore}), true);
        this.addIfConfigured(new DisabledItemClass("chestplate", i -> i instanceof ItemArmor && !(i instanceof ITinkerable) && ((ItemArmor)i).field_77881_a == EntityEquipmentSlot.CHEST, (Item)ConstructsRegistry.chestplate, Chestplate.class, new IToolPart[]{ConstructsRegistry.chestCore}), true);
        this.addIfConfigured(new DisabledItemClass("leggings", i -> i instanceof ItemArmor && !(i instanceof ITinkerable) && ((ItemArmor)i).field_77881_a == EntityEquipmentSlot.LEGS, (Item)ConstructsRegistry.leggings, Leggings.class, new IToolPart[]{ConstructsRegistry.leggingsCore}), true);
        this.addIfConfigured(new DisabledItemClass("boots", i -> i instanceof ItemArmor && !(i instanceof ITinkerable) && ((ItemArmor)i).field_77881_a == EntityEquipmentSlot.FEET, (Item)ConstructsRegistry.boots, Boots.class, new IToolPart[]{ConstructsRegistry.bootsCore}), true);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        itemSet.clear();
        for (Item i : ForgeRegistries.ITEMS) {
            Optional<DisabledItemClass> optc = classMap.stream().filter(c -> c.getItemPredicate().test(i)).findFirst();
            if (!optc.isPresent() || !config.getBoolean(i.getRegistryName().toString(), "disabledItems", true, "")) continue;
            DisabledItemClass c2 = optc.get();
            if (this.performItemNeutralizing) {
                originalDurabilities.put((Object)i, i.getMaxDamage(new ItemStack(i)));
                i.func_77656_e(1);
            }
            itemSet.add(i);
        }
        HashSet itemsNotified = Sets.newHashSet(itemSet);
        if (this.performItemDisabling) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                ItemStack output = recipe.func_77571_b();
                if (output.func_190926_b() || !itemSet.contains(output.func_77973_b())) continue;
                ForgeRegistries.RECIPES.register(new RecipeDummy(recipe.func_193358_e()).setRegistryName(recipe.getRegistryName()));
                logger.info("Disabled " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)output.func_77973_b())).toString() + " (removed recipe)");
                itemsNotified.remove(output.func_77973_b());
            }
        }
        if (this.performItemNeutralizing || this.performItemDisabling) {
            for (Item i : itemsNotified) {
                logger.info("Disabled " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)i)).toString());
            }
        }
        for (DisabledItemClass c3 : classMap) {
            c3.updateItemSet(itemSet);
        }
        if (this.performRecipeReplacement) {
            new RecipeReplacement().process((Iterable<IRecipe>)ForgeRegistries.RECIPES);
        }
        if (config.hasChanged()) {
            config.save();
        }
        lastSave = true;
    }

    static {
        originalDurabilities = new TObjectIntHashMap();
        classMap = new HashSet<DisabledItemClass>();
        itemSet = new HashSet<Item>();
    }
}

