/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield;

import ca.glasspelican.loginshield.ConfigurationManager;
import ca.glasspelican.loginshield.PlayerManager;
import ca.glasspelican.loginshield.server.LgsCommand;
import ca.glasspelican.loginshield.status;
import ca.glasspelican.loginshield.util.LogHelper;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="login_shield", version="1.12.2-3-g7c6e7ac", acceptableRemoteVersions="*", guiFactory="ca.glasspelican.loginshield.client.ConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class loginshield {
    public static final String MODID = "login_shield";
    public static final String VERSION = "1.12.2-3-g7c6e7ac";
    public static final String CHARSET = "UTF-8";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigurationManager.loadConfiguration(config);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        status thisPlayer = PlayerManager.add(event.player);
        World entityWorld = thisPlayer.getPlayerEntity().func_130014_f_();
        if (!entityWorld.func_175623_d(thisPlayer.getStartBlockPos()) || !entityWorld.func_175623_d(thisPlayer.getAboveStartBlockPos())) {
            LogHelper.debug("Block conflicting with player");
            if (ConfigurationManager.isBlockConflict()) {
                PlayerManager.teleportPlayer(thisPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerManager.remove(event.player.func_145782_y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!ConfigurationManager.isVoidTeleport()) {
            return;
        }
        int removePlayer = 0;
        List<Integer> list = PlayerManager.getProtectedPlayerCache();
        synchronized (list) {
            for (Integer entityID : PlayerManager.getProtectedPlayerCache()) {
                status thisPlayer = PlayerManager.get(entityID);
                if (thisPlayer == null) {
                    LogHelper.error("If you see this tell Glasspelican that the Player Manager returned a NULL player");
                    removePlayer = entityID;
                    continue;
                }
                if (!thisPlayer.hasInteracted.booleanValue()) {
                    if (thisPlayer.getStartX().intValue() != thisPlayer.getCurrentPos().func_177958_n() || thisPlayer.getStartZ().intValue() != thisPlayer.getCurrentPos().func_177952_p()) {
                        thisPlayer.hasInteracted = true;
                    }
                    if (!thisPlayer.isTimeProtected() || thisPlayer.getCurrentPos().func_177956_o() >= 0) continue;
                    PlayerManager.teleportPlayerSpawn(thisPlayer);
                    PlayerManager.sendChatMessage(thisPlayer, ConfigurationManager.getVoidRescueMessage());
                    continue;
                }
                removePlayer = entityID;
            }
        }
        if (removePlayer != 0) {
            PlayerManager.removePlayerCache(removePlayer);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        Integer entityID;
        if (event.getEntityLiving() instanceof EntityPlayer && PlayerManager.isProtected(entityID = Integer.valueOf(event.getEntityLiving().func_145782_y()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent event) {
        BlockPos blockPos;
        World world;
        if (ConfigurationManager.isSquidControl() && event.getEntityLiving() instanceof EntitySquid && (world = event.getWorld()).func_180495_p(blockPos = event.getEntity().func_180425_c()).func_185904_a() == Material.field_151586_h) {
            event.getEntity().func_174812_G();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.hasInteracted = true;
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.hasInteracted = true;
        }
    }

    @SubscribeEvent
    public void onPlayerItemDrop(ItemTossEvent event) {
        status player = PlayerManager.get(event.getPlayer().func_145782_y());
        if (player == null) {
            return;
        }
        player.hasInteracted = true;
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        status player = PlayerManager.get(event.player.func_145782_y());
        if (player == null) {
            return;
        }
        int dimensionTime = ConfigurationManager.getDimensionTime();
        if (dimensionTime >= 0) {
            player.hasInteracted = false;
            player.setTimeProtected(dimensionTime);
            PlayerManager.addPlayerCache(event.player.func_145782_y());
            player.setStartBlockPos(event.player.func_180425_c());
        }
    }

    @SubscribeEvent
    public void onAiTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && ConfigurationManager.isMobProtection() && PlayerManager.isProtected(event.getTarget().func_145782_y())) {
            event.getEntityLiving().func_70604_c(null);
            event.getEntityLiving().func_130011_c(null);
            if (event.getEntityLiving() instanceof EntityLiving) {
                ((EntityLiving)event.getEntityLiving()).field_70696_bz = null;
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigurationManager.save();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new LgsCommand());
    }
}

