/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield;

import ca.glasspelican.loginshield.ConfigurationManager;
import ca.glasspelican.loginshield.FindVoid;
import ca.glasspelican.loginshield.status;
import ca.glasspelican.loginshield.util.LogHelper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

class PlayerManager {
    private static final Map<Integer, status> players = new ConcurrentHashMap<Integer, status>();
    private static final List<Integer> protectedPlayerCache = Collections.synchronizedList(new LinkedList());

    private PlayerManager() {
    }

    static status get(Integer entityID) {
        return players.get(entityID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static status add(EntityPlayer player) {
        status status2 = new status(player);
        status2.setTimeProtected(ConfigurationManager.getProtectTime());
        List<Integer> list = protectedPlayerCache;
        synchronized (list) {
            players.put(player.func_145782_y(), status2);
            protectedPlayerCache.add(player.func_145782_y());
        }
        return status2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Integer entityID) {
        List<Integer> list = protectedPlayerCache;
        synchronized (list) {
            PlayerManager.removePlayerCache(entityID);
            players.remove(entityID);
        }
    }

    static boolean isProtected(Integer entityID) {
        status playerStatus = players.get(entityID);
        if (playerStatus == null) {
            return false;
        }
        return playerStatus.isTimeProtected() && playerStatus.hasInteracted == false;
    }

    static List<Integer> getProtectedPlayerCache() {
        return protectedPlayerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removePlayerCache(Integer entityID) {
        List<Integer> list = protectedPlayerCache;
        synchronized (list) {
            if (protectedPlayerCache.contains(entityID)) {
                protectedPlayerCache.remove(protectedPlayerCache.indexOf(entityID));
            }
        }
    }

    static void addPlayerCache(Integer entityID) {
        protectedPlayerCache.add(entityID);
    }

    static void teleportPlayerSpawn(status player) {
        PlayerManager.teleportPlayer(player, true);
    }

    static void teleportPlayer(status player) {
        PlayerManager.teleportPlayer(player, false);
    }

    private static void teleportPlayer(status player, boolean spawn) {
        BlockPos targetBlockPos;
        World playerWorld = player.getPlayerEntity().func_130014_f_();
        int dim = playerWorld.func_175624_G().func_82747_f();
        if (spawn) {
            try {
                targetBlockPos = playerWorld.func_175694_M();
            }
            catch (Exception exp) {
                LogHelper.error("Error getting spawn point for player: Aborting");
                LogHelper.error(exp);
                return;
            }
        } else {
            targetBlockPos = player.getPlayerEntity().func_180425_c();
        }
        BlockPos blockPos = FindVoid.findVoid(playerWorld, targetBlockPos);
        player.getPlayerEntity().func_70634_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
        player.setStartBlockPos(blockPos);
        LogHelper.info("Teleporting player: " + player.getPlayerEntity().getDisplayNameString() + " in dim: " + dim);
    }

    static void sendChatMessage(status player, String msg) {
        if (msg.isEmpty()) {
            return;
        }
        player.getPlayerEntity().func_145747_a((ITextComponent)new TextComponentString(msg));
    }
}

