/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.item;

import betterwithmods.util.item.Stack;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraftforge.oredict.OreDictionary;

public class StackMap<T>
implements Map<Stack, T> {
    private final HashMap<Stack, T> map = new HashMap();
    private T defaultValue;

    public StackMap(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public T put(ItemStack stack, T t) {
        return this.put(new Stack(stack), t);
    }

    public T put(Item item, int meta, T t) {
        return this.put(new Stack(item, meta), t);
    }

    @Override
    public T put(Item item, T value) {
        return this.put(item, 0, value);
    }

    @Override
    public T put(Block block, T value) {
        return this.put(block, 0, value);
    }

    public T put(Block block, int meta, T value) {
        try {
            Stack stack = new Stack(block, meta);
            return this.put(stack, value);
        }
        catch (NullPointerException e) {
            CrashReport report = new CrashReport("The block " + block.getRegistryName() + " cannot be converted into an item.", (Throwable)e);
            throw new ReportedException(report);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public T get(Object o) {
        if (this.containsKey(o)) {
            return this.map.get(o);
        }
        return this.defaultValue;
    }

    public T get(Item item, int meta) {
        return this.get(new Stack(item, meta));
    }

    public T get(ItemStack stack) {
        return this.get(new Stack(stack));
    }

    @Override
    public T put(Stack stack, T t) {
        return this.map.put(stack, t);
    }

    @Override
    public T put(String oreDictName, T t) {
        OreDictionary.getOres((String)oreDictName).forEach(s -> this.put(new Stack((ItemStack)s), t));
        return t;
    }

    @Override
    public T remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends Stack, ? extends T> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Stack> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Stack, T>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }
}

