/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryIterator
implements Iterator<ItemStack> {
    private final ItemStackHandler handler;
    private final int end;
    private int index;

    public static Stream<ItemStack> stream(ItemStackHandler handler) {
        return InventoryIterator.stream(handler, 0, handler.getSlots());
    }

    public static Stream<ItemStack> stream(ItemStackHandler handler, int start, int end) {
        InventoryIterator iterator = new InventoryIterator(handler, start, end);
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private InventoryIterator(ItemStackHandler handler, int start, int end) {
        this.handler = handler;
        this.index = start;
        this.end = end;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end;
    }

    @Override
    public ItemStack next() {
        return this.handler.getStackInSlot(this.index++);
    }
}

