/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.module.Feature;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class EnchantmentTooltip
extends Feature {
    @SideOnly(value=Side.CLIENT)
    public static String getTranslatedEnchantment(@Nullable Enchantment enchantment) {
        if (enchantment != null && enchantment.field_77351_y != null) {
            String name = enchantment.field_77351_y.name().toLowerCase();
            String key = String.format("bwm.enchantment.type.%s", name);
            if (I18n.func_188566_a((String)key)) {
                return I18n.func_135052_a((String)key, (Object[])new Object[0]);
            }
            return StringUtils.capitalize((String)name.replace("_", " "));
        }
        return null;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Enchantment enchantment;
        String tooltip;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
            NBTTagList nbttaglist = ItemEnchantedBook.func_92110_g((ItemStack)stack);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                short j = nbttagcompound.func_74765_d("id");
                Enchantment enchantment2 = Enchantment.func_185262_c((int)j);
                String tooltip2 = EnchantmentTooltip.getTranslatedEnchantment(enchantment2);
                if (tooltip2 == null) continue;
                event.getToolTip().add(tooltip2);
            }
        } else if (stack.func_77973_b() instanceof ItemArcaneScroll && (tooltip = EnchantmentTooltip.getTranslatedEnchantment(enchantment = ItemArcaneScroll.getEnchantment(stack))) != null) {
            event.getToolTip().add(tooltip);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Add a tooltip to Enchantment source items (Scrolls, Books) to show what type of tool the enchantment can be used on.";
    }
}

