/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.api.util.IWood;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.crafting.ChoppingRecipe;
import betterwithmods.common.registry.crafting.RecipeArmorDye;
import betterwithmods.module.Feature;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CraftingRecipes
extends Feature {
    public CraftingRecipes() {
        this.canDisable = false;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMRecipes.addRecipe(new RecipeArmorDye(Ingredient.func_193368_a((Item[])new Item[]{BWMItems.LEATHER_TANNED_HELMET, BWMItems.LEATHER_TANNED_CHEST, BWMItems.LEATHER_TANNED_PANTS, BWMItems.LEATHER_TANNED_BOOTS})));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.PADDING), "XXX", "XXX", "XXX", Character.valueOf('X'), "padding");
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.SOAP), "XXX", "XXX", "XXX", Character.valueOf('X'), "soap");
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.FLINT), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack(Items.field_151145_ak));
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.ROPE), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack(BWMBlocks.ROPE));
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.HELLFIRE), "XXX", "XXX", "XXX", Character.valueOf('X'), "ingotConcentratedHellfire");
        BWMRecipes.addOreRecipe(BlockAesthetic.getStack(BlockAesthetic.EnumType.ENDERBLOCK), "XXX", "XXX", "XXX", Character.valueOf('X'), "enderpearl");
        GameRegistry.addSmelting((Item)BWMItems.RAW_EGG, (ItemStack)new ItemStack(BWMItems.COOKED_EGG), (float)0.1f);
        GameRegistry.addSmelting((Item)BWMItems.RAW_SCRAMBLED_EGG, (ItemStack)new ItemStack(BWMItems.COOKED_SCRAMBLED_EGG), (float)0.1f);
        GameRegistry.addSmelting((Item)BWMItems.RAW_OMELET, (ItemStack)new ItemStack(BWMItems.COOKED_OMELET), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHER_SLUDGE), (ItemStack)new ItemStack(Items.field_151130_bT), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BWMBlocks.AESTHETIC, 1, 7), (ItemStack)new ItemStack(BWMBlocks.AESTHETIC, 1, 6), (float)0.1f);
        GameRegistry.addSmelting((Item)BWMItems.WOLF_CHOP, (ItemStack)new ItemStack(BWMItems.COOKED_WOLF_CHOP), (float)0.5f);
        GameRegistry.addSmelting((Item)BWMItems.MYSTERY_MEAT, (ItemStack)new ItemStack(BWMItems.COOKED_MYSTERY_MEAT), (float)0.5f);
        GameRegistry.addSmelting((Item)BWMItems.BAT_WING, (ItemStack)new ItemStack(BWMItems.COOKED_BAT_WING), (float)0.5f);
        GameRegistry.addSmelting((Item)BWMItems.RAW_KEBAB, (ItemStack)new ItemStack(BWMItems.COOKED_KEBAB), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.CAKE), (ItemStack)new ItemStack(Items.field_151105_aU), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD), (ItemStack)new ItemStack(Items.field_151025_P), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.APPLE), (ItemStack)new ItemStack(BWMItems.APPLE_PIE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.PUMPKIN), (ItemStack)new ItemStack(Items.field_151158_bO), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.COOKIE), (ItemStack)new ItemStack(Items.field_151106_aX, 4), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BWMBlocks.COBBLE, 1, 0), (ItemStack)new ItemStack(Blocks.field_150348_b, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BWMBlocks.COBBLE, 1, 1), (ItemStack)new ItemStack(Blocks.field_150348_b, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BWMBlocks.COBBLE, 1, 2), (ItemStack)new ItemStack(Blocks.field_150348_b, 1, 5), (float)0.1f);
    }

    public boolean hasLog(IRecipe recipe, ItemStack log) {
        NonNullList ingredients = recipe.func_192400_c();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.func_193365_a().length <= 0) continue;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (!stack.func_77969_a(log)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        for (IRecipe recipe : BWOreDictionary.logRecipes) {
            ItemStack plank = recipe.func_77571_b();
            BWOreDictionary.woods.stream().filter(w -> w.getPlank(4).func_77969_a(plank) && this.hasLog(recipe, w.getLog(1))).forEach(wood -> this.addHardcoreRecipe((IRecipe)new ChoppingRecipe((IWood)wood).setRegistryName(new ResourceLocation("betterwithmods", recipe.getRegistryName().func_110623_a()))));
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Adds basic crafting recipes";
    }
}

