/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.manager;

import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.tile.IHeated;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCookingPot;
import betterwithmods.common.registry.bulk.manager.CraftingManagerBulk;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CookingPotManager
extends CraftingManagerBulk<CookingPotRecipe> {
    public CookingPotRecipe addRecipe(List<Ingredient> inputs, IRecipeOutputs outputs, int heat) {
        return this.addRecipe(new CookingPotRecipe(inputs, outputs, heat));
    }

    public CookingPotRecipe addRecipe(List<Ingredient> inputs, List<ItemStack> outputs, int heat) {
        return this.addRecipe(new CookingPotRecipe(inputs, outputs, heat));
    }

    public CookingPotRecipe addStokedRecipe(ItemStack input, ItemStack ... output) {
        return this.addStokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input.func_77946_l())}), (List<ItemStack>)Lists.newArrayList((Object[])output));
    }

    public CookingPotRecipe addStokedRecipe(ItemStack input, List<ItemStack> output) {
        return this.addStokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input.func_77946_l())}), output);
    }

    public CookingPotRecipe addStokedRecipe(ItemStack input, ItemStack output) {
        return this.addStokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input)}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public CookingPotRecipe addStokedRecipe(Ingredient ingredient, ItemStack output) {
        return this.addStokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{ingredient}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public CookingPotRecipe addStokedRecipe(Ingredient ingredient, List<ItemStack> outputs) {
        return this.addStokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{ingredient}), outputs);
    }

    public CookingPotRecipe addStokedRecipe(List<Ingredient> inputs, List<ItemStack> outputs) {
        return this.addRecipe(inputs, outputs, 2);
    }

    public CookingPotRecipe addStokedRecipe(List<Ingredient> inputs, IRecipeOutputs outputs) {
        return this.addRecipe(inputs, outputs, 2);
    }

    public CookingPotRecipe addUnstokedRecipe(List<Ingredient> inputs, ItemStack output) {
        return this.addUnstokedRecipe(inputs, (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public CookingPotRecipe addUnstokedRecipe(ItemStack input, ItemStack ... output) {
        return this.addUnstokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input.func_77946_l())}), (List<ItemStack>)Lists.newArrayList((Object[])output));
    }

    public CookingPotRecipe addUnstokedRecipe(ItemStack input, List<ItemStack> output) {
        return this.addUnstokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input)}), output);
    }

    public CookingPotRecipe addUnstokedRecipe(ItemStack input, ItemStack output) {
        return this.addUnstokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input)}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public CookingPotRecipe addUnstokedRecipe(Ingredient ingredient, ItemStack output) {
        return this.addUnstokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{ingredient}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public CookingPotRecipe addUnstokedRecipe(Ingredient ingredient, List<ItemStack> outputs) {
        return this.addUnstokedRecipe((List<Ingredient>)Lists.newArrayList((Object[])new Ingredient[]{ingredient}), outputs);
    }

    public CookingPotRecipe addUnstokedRecipe(List<Ingredient> inputs, List<ItemStack> outputs) {
        return this.addRecipe(inputs, outputs, 1);
    }

    public CookingPotRecipe addUnstokedRecipe(List<Ingredient> inputs, IRecipeOutputs outputs) {
        return this.addRecipe(inputs, outputs, 1);
    }

    public CookingPotRecipe addHeatlessRecipe(List<Ingredient> inputs, List<ItemStack> outputs, int heat) {
        return this.addRecipe(inputs, outputs, heat).setIgnoreHeat(true);
    }

    @Override
    public boolean craftRecipe(World world, TileEntity tile, ItemStackHandler inv) {
        if (tile instanceof TileEntityCookingPot) {
            TileEntityCookingPot pot = (TileEntityCookingPot)tile;
            CookingPotRecipe r = (CookingPotRecipe)this.findRecipe(tile, inv);
            if (this.canCraft(r, tile, inv)) {
                if (pot.cookProgress >= pot.getMax()) {
                    InvUtils.insert(world, pot.getBlockPos().func_177984_a(), (IItemHandler)inv, this.craftItem(r, world, tile, inv), false);
                    pot.cookProgress = 0;
                    return true;
                }
                ++pot.cookProgress;
            } else {
                pot.cookProgress = 0;
            }
        }
        return false;
    }

    @Override
    protected Optional<CookingPotRecipe> findRecipe(List<CookingPotRecipe> recipes, TileEntity tile, ItemStackHandler inv) {
        if (tile instanceof IHeated) {
            List r1 = recipes.stream().filter(r -> r.canCraft((IHeated)tile, tile.func_145831_w(), tile.func_174877_v())).collect(Collectors.toList());
            return super.findRecipe(r1, tile, inv);
        }
        return Optional.empty();
    }

    public List<CookingPotRecipe> getRecipesForHeat(int heat) {
        return this.getRecipes().stream().filter(r -> r.getHeat() == heat).collect(Collectors.toList());
    }
}

