/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.penalties;

import betterwithmods.common.penalties.attribute.Attribute;
import betterwithmods.common.penalties.attribute.IAttribute;
import betterwithmods.common.penalties.attribute.IAttributeInstance;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Range;

public class Penalty<T extends Number>
implements Comparable<Penalty> {
    private Range<T> range;
    private float severity;
    private Map<IAttribute<?>, IAttributeInstance<?>> attributeMap = Maps.newHashMap();
    private String name;

    public Penalty(String name, float severity, Range<T> range, IAttributeInstance<?> ... attributes) {
        this.name = name;
        this.severity = severity;
        this.range = range;
        Arrays.stream(attributes).forEach(a -> this.attributeMap.put(a.getParent(), (IAttributeInstance<?>)a));
    }

    public Range<T> getRange() {
        return this.range;
    }

    public boolean inRange(T t) {
        return this.range.contains(t);
    }

    public float getSeverity() {
        return this.severity;
    }

    public IAttributeInstance<?> getAttribute(Attribute<?> attribute) {
        return this.attributeMap.get(attribute);
    }

    public IAttributeInstance<Boolean> getBoolean(Attribute<Boolean> attribute) {
        return this.getAttribute(attribute);
    }

    public IAttributeInstance<Float> getFloat(Attribute<Float> attribute) {
        return this.getAttribute(attribute);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(@Nonnull Penalty penalty) {
        return Float.compare(this.getSeverity(), penalty.getSeverity());
    }
}

