/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockStakeString;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStake
extends BWMBlock {
    public static PropertyBool[] Z_ROTATE = new PropertyBool[]{DirUtils.SOUTH, DirUtils.NORTH, DirUtils.DOWN, DirUtils.UP, DirUtils.EAST, DirUtils.WEST};
    public static PropertyBool[] X_ROTATE = new PropertyBool[]{DirUtils.SOUTH, DirUtils.NORTH, DirUtils.WEST, DirUtils.EAST, DirUtils.DOWN, DirUtils.UP};

    public BlockStake() {
        super(Material.field_151575_d);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing.func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184614_ca();
        if (stack.func_77969_a(new ItemStack(Items.field_151007_F))) {
            return this.placeString(worldIn, pos, side, stack);
        }
        return false;
    }

    public boolean placeString(World world, BlockPos pos, EnumFacing facing, ItemStack stack) {
        int count = stack.func_190916_E();
        int build = -1;
        for (int i = 1; i <= 64; ++i) {
            IBlockState stake = world.func_180495_p(pos.func_177967_a(facing, i));
            if (stake.func_177230_c() instanceof BlockStake) {
                build = i;
                break;
            }
            if (world.func_175623_d(pos.func_177967_a(facing, i)) || stake.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177967_a(facing, i)) || stake.func_177230_c() == BWMBlocks.STAKE_STRING) continue;
            return false;
        }
        if (build > -1 && count >= build - 1) {
            int remove = 0;
            for (int i = 1; i < build; ++i) {
                if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() == BWMBlocks.STAKE_STRING) continue;
                world.func_175656_a(pos.func_177967_a(facing, i), BWMBlocks.STAKE_STRING.func_176223_P());
                ++remove;
            }
            stack.func_190918_g(remove);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)) {
            default: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
            }
            case UP: {
                return new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 1.0, 0.625);
            }
            case NORTH: {
                return new AxisAlignedBB(0.375, 0.375, 0.75, 0.625, 0.625, 0.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.375, 0.375, 0.25, 0.625, 0.625, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.75, 0.375, 0.375, 0.0, 0.625, 0.625);
            }
            case EAST: 
        }
        return new AxisAlignedBB(0.25, 0.375, 0.375, 1.0, 0.625, 0.625);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
        EnumFacing.Axis axis = facing.func_176740_k();
        boolean inverted = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        PropertyBool[] transform = DirUtils.DIR_PROP;
        if (axis == EnumFacing.Axis.Z) {
            transform = Z_ROTATE;
        } else if (axis == EnumFacing.Axis.X) {
            transform = X_ROTATE;
        }
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing front = EnumFacing.func_82600_a((int)i);
            if (inverted && (axis != EnumFacing.Axis.Y && front.func_176740_k() != EnumFacing.Axis.Y || axis == EnumFacing.Axis.Y && front.func_176740_k() != EnumFacing.Axis.X)) {
                front = front.func_176734_d();
            }
            newState = newState.func_177226_a((IProperty)transform[i], (Comparable)Boolean.valueOf(BlockStake.getDirection(worldIn, pos, front)));
        }
        return newState;
    }

    public static boolean getDirection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof BlockStakeString;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175685_c(pos, (Block)this, true);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Block block = worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!(block instanceof BlockStakeString)) continue;
            ((BlockStakeString)block).drop(worldIn, pos.func_177972_a(facing));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean isSupported(World world, BlockPos pos, IBlockState state) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
        return world.isSideSolid(pos.func_177972_a(side), side.func_176734_d());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.isSupported(worldIn, pos, state)) {
            InvUtils.ejectStackWithOffset(worldIn, pos, this.func_185473_a(worldIn, pos, state));
            worldIn.func_175698_g(pos);
        }
    }
}

