/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.capability.RingCharge;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.lib.Utils;
import zabi.minecraft.extraalchemy.potion.NoncontinuousEffect;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble")
public class ItemPotionRing
extends Item
implements IBauble {
    private static final ArrayList<String> whitelist = Lists.newArrayList();
    private static final ArrayList<String> blacklist = Lists.newArrayList();

    public ItemPotionRing() {
        this.func_77625_d(1);
        this.func_77637_a(ExtraAlchemy.TAB);
        this.setRegistryName(new ResourceLocation("extraalchemy", "potion_ring"));
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && ModConfig.options.enablePotionRings) {
            whitelist.stream().filter(s -> !blacklist.contains(s)).map(s -> new ResourceLocation(s)).map(rl -> (PotionType)ForgeRegistries.POTION_TYPES.getValue(rl)).filter(pt -> pt != null).filter(pt -> pt.func_185170_a().size() == 1).forEach(pt -> this.addPotionRing(items, (PotionType)pt));
        }
    }

    private void addPotionRing(NonNullList<ItemStack> items, PotionType pt) {
        ItemStack stack = new ItemStack((Item)this);
        PotionUtils.func_185188_a((ItemStack)stack, (PotionType)pt);
        items.add((Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (PotionUtils.func_185191_c((ItemStack)stack).func_185170_a().size() != 1) {
            return I18n.func_135052_a((String)"item.potion_ring_ea.uncraftable.name", (Object[])new Object[0]);
        }
        String potName = I18n.func_135052_a((String)((PotionEffect)PotionUtils.func_185191_c((ItemStack)stack).func_185170_a().get(0)).func_76453_d(), (Object[])new Object[0]);
        String potLvl = I18n.func_135052_a((String)("potion.potency." + ((PotionEffect)PotionUtils.func_185191_c((ItemStack)stack).func_185170_a().get(0)).func_76458_c()), (Object[])new Object[0]);
        return I18n.func_135052_a((String)"item.potion_ring_ea.name", (Object[])new Object[]{potName, potLvl}).trim();
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        super.onEquipped(itemstack, player);
        if (!player.field_70170_p.field_72995_K && this.shouldTickAsBauble() && player instanceof EntityPlayer) {
            this.applyLogic((EntityPlayer)player, itemstack);
        }
    }

    public boolean shouldTickAsBauble() {
        return ModConfig.options.enableBaubleInteraction && Loader.isModLoaded((String)"baubles");
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        super.onWornTick(itemstack, player);
        if (!player.field_70170_p.field_72995_K && this.shouldTickAsBauble() && player instanceof EntityPlayer && this.shouldApplyNow((Entity)player)) {
            this.applyLogic((EntityPlayer)player, itemstack);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!entityIn.field_70170_p.field_72995_K && !this.shouldTickAsBauble() && entityIn instanceof EntityPlayer && this.shouldApplyNow(entityIn)) {
            this.applyLogic((EntityPlayer)entityIn, stack);
        }
    }

    @Optional.Method(modid="baubles")
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        for (int i : this.getBaubleType(null).getValidSlots()) {
            if (!BaublesApi.getBaublesHandler((EntityPlayer)playerIn).insertItem(i, playerIn.func_184586_b(handIn), false).func_190926_b()) continue;
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    private void applyLogic(EntityPlayer p, ItemStack stack) {
        PotionType type = PotionUtils.func_185191_c((ItemStack)stack);
        for (PotionEffect pe : type.func_185170_a()) {
            int cost;
            int lvl = pe.func_76458_c() + 1;
            if (lvl > 2 || !this.drainXp(p, cost = lvl == 1 ? ModConfig.options.ringXpConsumptionFirstLevel : (lvl == 2 ? ModConfig.options.ringXpConsumptionSecondLevel : Integer.MAX_VALUE), pe.func_188419_a())) continue;
            p.func_70690_d(new PotionEffect(pe.func_188419_a(), 120, lvl - 1, false, false));
        }
    }

    private boolean shouldApplyNow(Entity p) {
        return p.field_70173_aa % 100 == 0;
    }

    private boolean drainXp(EntityPlayer p, int amount, Potion potion) {
        if (p.func_184812_l_()) {
            return true;
        }
        if (potion instanceof NoncontinuousEffect && !((NoncontinuousEffect)potion).isEffectActive((EntityLivingBase)p)) {
            return true;
        }
        RingCharge rc = (RingCharge)((Object)p.getCapability(RingCharge.CAPABILITY, null));
        if (rc.charges > 0) {
            --rc.charges;
            rc.markDirty((byte)1);
            return true;
        }
        if (amount > Utils.getPlayerXP(p)) {
            return false;
        }
        Utils.addPlayerXP(p, -amount);
        rc.charges = 5;
        return true;
    }

    public static void addToWhitelist(String registryName) {
        whitelist.add(registryName);
    }

    public static void removeFromWhitelist(String name) {
        blacklist.add(name);
        whitelist.remove(name);
    }

    public static void addRecipes() {
        whitelist.stream().filter(s -> !blacklist.contains(s)).map(s -> new ResourceLocation(s)).map(rl -> (PotionType)ForgeRegistries.POTION_TYPES.getValue(rl)).filter(pt -> pt != null).filter(pt -> pt.func_185170_a().size() == 1).forEach(pt -> ItemPotionRing.addRecipeForType(pt));
    }

    private static void addRecipeForType(PotionType pt) {
        ItemStack result = new ItemStack(ModItems.potion_ring);
        PotionUtils.func_185188_a((ItemStack)result, (PotionType)pt);
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)potion, (PotionType)pt);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("extraalchemy", pt.getRegistryName().toString().replace(':', '_')), null, (ItemStack)result, (Ingredient[])new Ingredient[]{new IngredientNBT(potion){}, Ingredient.func_193367_a((Item)ModItems.empty_ring)});
    }

    static {
        whitelist.add("minecraft:night_vision");
        whitelist.add("minecraft:invisibility");
        whitelist.add("minecraft:leaping");
        whitelist.add("minecraft:strong_leaping");
        whitelist.add("minecraft:fire_resistance");
        whitelist.add("minecraft:swiftness");
        whitelist.add("minecraft:strong_swiftness");
        whitelist.add("minecraft:slowness");
        whitelist.add("minecraft:water_breathing");
        whitelist.add("minecraft:regeneration");
        whitelist.add("minecraft:strong_regeneration");
        whitelist.add("minecraft:strength");
        whitelist.add("minecraft:strong_strength");
        whitelist.add("minecraft:weakness");
        whitelist.add("extraalchemy:magnetism_normal");
        whitelist.add("extraalchemy:magnetism_strong");
        whitelist.add("extraalchemy:crumbling_normal");
        whitelist.add("extraalchemy:crumbling_strong");
        whitelist.add("extraalchemy:dislocation_normal");
        whitelist.add("extraalchemy:dislocation_strong");
        whitelist.add("extraalchemy:gravity_normal");
        whitelist.add("extraalchemy:gravity_strong");
        whitelist.add("extraalchemy:hurry_normal");
        whitelist.add("extraalchemy:hurry_strong");
        whitelist.add("extraalchemy:learning_normal");
        whitelist.add("extraalchemy:learning_strong");
        whitelist.add("extraalchemy:leech_normal");
        whitelist.add("extraalchemy:leech_strong");
        whitelist.add("extraalchemy:photosynthesis_normal");
        whitelist.add("extraalchemy:photosynthesis_strong");
        whitelist.add("extraalchemy:reincarnation_normal");
        whitelist.add("extraalchemy:reincarnation_strong");
        whitelist.add("extraalchemy:sails_normal");
        whitelist.add("extraalchemy:sails_strong");
        whitelist.add("extraalchemy:sinking_normal");
        whitelist.add("extraalchemy:sinking_strong");
    }
}

