/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.events.QuestEvent;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenTest;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNone;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetBulkSync;
import betterquesting.network.handlers.NetNameSync;
import betterquesting.network.handlers.NetNotices;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();
    private final ArrayDeque<EntityPlayerMP> opQueue = new ArrayDeque();
    private boolean openToLAN = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BQ_Keybindings.openQuests.func_151468_f()) {
            if (mc.field_71439_g.func_70093_af() && mc.field_71439_g.func_70005_c_().equalsIgnoreCase("Funwayguy")) {
                mc.func_147108_a((GuiScreen)new GuiScreenTest(mc.field_71462_r));
            } else if (BQ_Settings.useBookmark && GuiHome.bookmark != null) {
                mc.func_147108_a(GuiHome.bookmark);
            } else {
                mc.func_147108_a(ThemeRegistry.INSTANCE.getGui(PresetGUIs.HOME, GArgsNone.NONE));
            }
        }
    }

    @SubscribeEvent
    public void onCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(CapabilityProviderQuestCache.LOC_QUEST_CACHE, (ICapabilityProvider)new CapabilityProviderQuestCache());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        QuestCache oCache = (QuestCache)event.getOriginal().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        QuestCache nCache = (QuestCache)event.getEntityPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (oCache != null && nCache != null) {
            nCache.deserializeNBT(oCache.serializeNBT());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            if (event.getEntityLiving().field_70173_aa % 20 != 0) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
            if (qc == null) {
                return;
            }
            List activeQuests = QuestDatabase.INSTANCE.bulkLookup(qc.getActiveQuests());
            List pendingAutoClaims = QuestDatabase.INSTANCE.bulkLookup(qc.getPendingAutoClaims());
            QuestCache.QResetTime[] pendingResets = qc.getScheduledResets();
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
            boolean refreshCache = false;
            if (!editMode && player.field_70173_aa % 60 == 0) {
                ArrayList<Integer> com = new ArrayList<Integer>();
                for (DBEntry quest : activeQuests) {
                    if (!((IQuest)quest.getValue()).isUnlocked(uuid)) continue;
                    if (((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) {
                        ((IQuest)quest.getValue()).update((EntityPlayer)player);
                    }
                    if (!((IQuest)quest.getValue()).isComplete(uuid) || ((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) continue;
                    refreshCache = true;
                    qc.markQuestDirty(quest.getID());
                    com.add(quest.getID());
                    if (((IQuest)quest.getValue()).getProperty(NativeProps.SILENT).booleanValue()) continue;
                    EventHandler.postPresetNotice((IQuest)quest.getValue(), (EntityPlayer)player, 2);
                }
                MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.COMPLETED, uuid, com));
            }
            if (!editMode && player.func_184102_h() != null) {
                ArrayList<Integer> res = new ArrayList<Integer>();
                long totalTime = System.currentTimeMillis();
                for (QuestCache.QResetTime rTime : pendingResets) {
                    IQuest entry = (IQuest)QuestDatabase.INSTANCE.getValue(rTime.questID);
                    if (totalTime < rTime.time || entry.canSubmit((EntityPlayer)player)) break;
                    if (entry.getProperty(NativeProps.GLOBAL).booleanValue()) {
                        entry.resetUser(null, false);
                    } else {
                        entry.resetUser(uuid, false);
                    }
                    refreshCache = true;
                    qc.markQuestDirty(rTime.questID);
                    res.add(rTime.questID);
                    if (entry.getProperty(NativeProps.SILENT).booleanValue()) continue;
                    EventHandler.postPresetNotice(entry, (EntityPlayer)player, 1);
                }
                MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.RESET, uuid, res));
            }
            if (!editMode) {
                for (DBEntry entry : pendingAutoClaims) {
                    if (!((IQuest)entry.getValue()).canClaim((EntityPlayer)player)) continue;
                    ((IQuest)entry.getValue()).claimReward((EntityPlayer)player);
                    refreshCache = true;
                    qc.markQuestDirty(entry.getID());
                }
            }
            if (refreshCache || player.field_70173_aa % 200 == 0) {
                qc.updateCache((EntityPlayer)player);
            }
            if (qc.getDirtyQuests().length > 0) {
                NetQuestSync.sendSync(player, qc.getDirtyQuests(), false, true);
            }
            qc.cleanAllQuests();
        }
    }

    private static void postPresetNotice(IQuest quest, EntityPlayer player, int preset) {
        EntityPlayerMP[] entityPlayerMPArray;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack icon = quest.getProperty(NativeProps.ICON).getBaseStack();
        String mainText = "";
        String subText = quest.getProperty(NativeProps.NAME);
        String sound = "";
        switch (preset) {
            case 0: {
                mainText = "betterquesting.notice.unlock";
                sound = quest.getProperty(NativeProps.SOUND_UNLOCK);
                break;
            }
            case 1: {
                mainText = "betterquesting.notice.update";
                sound = quest.getProperty(NativeProps.SOUND_UPDATE);
                break;
            }
            case 2: {
                mainText = "betterquesting.notice.complete";
                sound = quest.getProperty(NativeProps.SOUND_COMPLETE);
            }
        }
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            entityPlayerMPArray = null;
        } else {
            EntityPlayerMP[] entityPlayerMPArray2 = new EntityPlayerMP[1];
            entityPlayerMPArray = entityPlayerMPArray2;
            entityPlayerMPArray2[0] = (EntityPlayerMP)player;
        }
        NetNotices.sendNotice(entityPlayerMPArray, icon, mainText, subText, sound);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && BQ_Settings.curWorldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            SaveLoadHandler.INSTANCE.saveDatabases();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.player.func_184102_h() == null || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
        if (BetterQuesting.proxy.isClient() && !mpPlayer.func_184102_h().func_71262_S() && event.player.func_184102_h().func_71214_G().equals(mpPlayer.func_146103_bH().getName())) {
            NameCache.INSTANCE.updateName(mpPlayer);
            return;
        }
        NetBulkSync.sendReset(mpPlayer, true, true);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            int lives = LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            if (lives <= 0) {
                MinecraftServer server = mpPlayer.func_184102_h();
                if (server == null) {
                    return;
                }
                mpPlayer.func_71033_a(GameType.SPECTATOR);
                if (!server.func_71262_S()) {
                    mpPlayer.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
                }
            } else if (lives == 1) {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString("This is your last life!"), true);
            } else {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString(lives + " lives remaining!"), true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.getEntityLiving());
            int lives = LifeDatabase.INSTANCE.getLives(uuid);
            LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(FluidPlaceholder.fluidPlaceholder.getStill());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            Minecraft.func_71410_x().func_152344_a(((INeedsRefresh)screen)::refreshGui);
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        EntityPlayerMP playerMP;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (event.getCommand().func_71517_b().equalsIgnoreCase("op") || event.getCommand().func_71517_b().equalsIgnoreCase("deop")) && (playerMP = server.func_184103_al().func_152612_a(event.getParameters()[0])) != null) {
            this.opQueue.add(playerMP);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.openToLAN) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server.func_71262_S()) {
                this.openToLAN = true;
            } else if (((IntegratedServer)server).func_71344_c()) {
                this.openToLAN = true;
                this.opQueue.addAll(server.func_184103_al().func_181057_v());
            }
        }
        while (!this.opQueue.isEmpty()) {
            EntityPlayerMP playerMP = this.opQueue.poll();
            if (playerMP == null || !NameCache.INSTANCE.updateName(playerMP)) continue;
            DBEntry<IParty> party = PartyManager.INSTANCE.getParty(QuestingAPI.getQuestingUUID((EntityPlayer)playerMP));
            if (party != null) {
                NetNameSync.quickSync(null, party.getID());
                continue;
            }
            NetNameSync.sendNames(new EntityPlayerMP[]{playerMP}, new UUID[]{QuestingAPI.getQuestingUUID((EntityPlayer)playerMP)}, null);
        }
    }
}

