/*
 * Decompiled with CFR 0.152.
 */
package com.gr8pefish.portablecrafting.inventory;

import com.gr8pefish.portablecrafting.items.craftingBenches.ItemPortableCrafter;
import com.gr8pefish.portablecrafting.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class InventoryPortableCrafting
extends InventoryCrafting {
    public ItemStack parent;
    public EntityPlayer player;
    protected NonNullList<ItemStack> inventory;
    private Container eventHandler;

    public InventoryPortableCrafting(EntityPlayer player, ItemStack itemStack) {
        super(null, 3, 3);
        this.parent = itemStack;
        this.player = player;
        this.inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        this.readFromNBT(this.parent.func_77978_p());
    }

    public void setEventHandler(Container eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory.set(slotIndex, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        this.eventHandler.func_75130_a((IInventory)this);
    }

    public ItemStack func_70463_b(int row, int col) {
        if (row >= 0 && row < 3) {
            int k = row + col * 3;
            return this.func_70301_a(k);
        }
        return null;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= this.func_70302_i_() ? null : (ItemStack)this.inventory.get(slotIndex);
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (!((ItemStack)this.inventory.get(slotIndex)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(slotIndex)).func_190916_E() <= amount) {
                ItemStack itemstack = (ItemStack)this.inventory.get(slotIndex);
                this.inventory.set(slotIndex, (Object)ItemStack.field_190927_a);
                this.eventHandler.func_75130_a((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(slotIndex)).func_77979_a(amount);
            if (((ItemStack)this.inventory.get(slotIndex)).func_190916_E() == 0) {
                this.inventory.set(slotIndex, (Object)ItemStack.field_190927_a);
            }
            this.eventHandler.func_75130_a((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public String func_70005_c_() {
        return "crafting.inventory";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        if (!this.parent.func_190926_b()) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.parent)) {
            UUID parentUUID = new UUID(this.parent.func_77978_p().func_74763_f("MostSigUUID"), this.parent.func_77978_p().func_74763_f("LeastSigUUID"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemPortableCrafter) || !NBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("MostSigUUID") != parentUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("LeastSigUUID") != parentUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.parent = this.findParentItemStack(this.player);
        if (!this.parent.func_190926_b() && (nbtTagCompound = this.parent.func_77978_p()) != null && nbtTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte j = stackTag.func_74771_c("Slot");
                if (i < 0 || i > this.inventory.size()) continue;
                this.inventory.set((int)j, (Object)new ItemStack(stackTag));
            }
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parent.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        this.writeToNBT(nbtTagCompound);
        this.parent.func_77982_d(nbtTagCompound);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = this.findParentItemStack(this.player).func_77978_p();
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }
}

