/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app.data;

import com.bartz24.externaltweaker.app.Strings;
import com.bartz24.externaltweaker.app.data.ETRecipeData;

public class ETActualRecipe {
    private String recipeFormat;
    private String[] parameters;

    public ETActualRecipe(String format, String ... curParameters) {
        this.recipeFormat = format;
        this.parameters = curParameters;
    }

    public String recipeToString(ETRecipeData linkedRecipe) {
        String base = this.getRecipeFormat();
        String string = base.substring(0, base.indexOf("(") + 1);
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!Strings.isNullOrEmpty(this.parameters[i])) {
                if (this.parameters[i].equals("~")) {
                    string = string.substring(0, string.length() - 2);
                    break;
                }
                string = string + this.parameters[i];
            } else {
                string = string + linkedRecipe.getParameterTypes()[i];
            }
            if (i >= this.parameters.length - 1) continue;
            string = string + ", ";
        }
        return string + ");";
    }

    public String getRecipeFormat() {
        return this.recipeFormat;
    }

    public String getParameterData(int index) {
        return this.parameters[index];
    }

    public void setParameterData(int index, String value) {
        this.parameters[index] = value;
    }

    public ETActualRecipe clone() {
        ETActualRecipe r = new ETActualRecipe("", new String[this.parameters.length]);
        r.recipeFormat = this.recipeFormat;
        for (int i = 0; i < this.parameters.length; ++i) {
            r.setParameterData(i, this.parameters[i]);
        }
        return r;
    }
}

