/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker.app;

import com.bartz24.externaltweaker.app.JPlaceholderTextField;
import com.bartz24.externaltweaker.app.Strings;
import com.bartz24.externaltweaker.app.data.ETActualRecipe;
import com.bartz24.externaltweaker.app.data.ETRecipeData;
import com.bartz24.externaltweaker.app.data.ETScript;
import com.bartz24.externaltweaker.app.panels.PanelImportExportDialog;
import com.bartz24.externaltweaker.app.panels.PanelParameterEdit;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class AppFrame
extends JFrame {
    Object[][] itemMappings;
    Object[][] fluidMappings;
    Object[][] oreDictMappings;
    public JTable table;
    public JScrollPane tableScroll;
    public JList listMethods;
    public JScrollPane scrollMethods;
    public final ButtonGroup buttonGroup = new ButtonGroup();
    public List<PanelParameterEdit> paramPanels = new ArrayList<PanelParameterEdit>();
    public List<ETRecipeData> recipeData = new ArrayList<ETRecipeData>();
    public List<ETScript> scripts = new ArrayList<ETScript>();
    public JPanel pnlRecipeEdit;
    public JLabel labelRecipe;
    public JComboBox comboRecipes;
    public JRadioButton rdbtnItems;
    public JRadioButton rdbtnFluids;
    public JRadioButton rdbtnOreDict;
    public JPlaceholderTextField txtSearchTable;
    public JButton btnDeleteRecipe;
    public JButton btnDupeRecipe;
    private final ButtonGroup buttonGroup_1 = new ButtonGroup();
    public JRadioButton btnRecipeRemove;
    public JRadioButton btnRecipeAdd;
    private JTextField recipeDisplay;
    public boolean updatingParameters;
    public String copyData;
    public String copyType;
    public JLabel lblCopying;
    public JComboBox comboScripts;
    private JMenuItem mntmDeleteScript;
    private JMenuItem mntmSaveAllScripts;
    private JMenu menuHelp;
    private JMenuItem mntmHelp;
    private JMenuItem mntmDownload;
    public JButton btnNewRecipe;
    private JMenuItem mntmAbout;
    private JMenu mnOther;
    private JMenuItem mntmExportRecipesTo;
    private JMenuItem mntmExportCurrentTable;
    private JMenuItem mntmRenameCurrentScript;

    public AppFrame(Object[][] itemMappings, Object[][] fluidMappings, Object[][] oreDictMappings, List<String> methods) {
        this.setTitle("External Tweaker");
        this.itemMappings = itemMappings;
        this.fluidMappings = fluidMappings;
        this.oreDictMappings = oreDictMappings;
        this.setPreferredSize(new Dimension(1200, 800));
        for (String string : methods) {
            this.recipeData.add(new ETRecipeData(string, new String[0], true));
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String s : this.methodDisplays()) {
            model.addElement(s);
        }
        this.listMethods = new JList(model);
        this.listMethods.setSelectionMode(0);
        this.listMethods.setBorder(new BevelBorder(1, null, null, null, null));
        this.listMethods.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AppFrame.this.btnNewRecipe.setEnabled(AppFrame.this.comboScripts.getSelectedIndex() >= 0 && AppFrame.this.listMethods.getModel().getSize() > 0);
            }
        });
        this.scrollMethods = new JScrollPane(this.listMethods);
        this.comboRecipes = new JComboBox();
        this.comboRecipes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !AppFrame.this.updatingParameters) {
                    AppFrame.this.updateCurrentRecipe();
                }
            }
        });
        this.labelRecipe = new JLabel("Current Recipe");
        this.labelRecipe.setHorizontalAlignment(11);
        this.table = new JTable(new Object[0][0], new String[]{"ID", "Name"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.loadTable("Items", "");
        this.table.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (AppFrame.this.table.getSelectedRow() >= 0 && AppFrame.this.table.getSelectedColumn() >= 0) {
                    AppFrame.this.table.setToolTipText("Currently Selected: " + AppFrame.this.table.getValueAt(AppFrame.this.table.getSelectedRow(), 0) + " (" + AppFrame.this.table.getValueAt(AppFrame.this.table.getSelectedRow(), 1) + ")");
                } else {
                    AppFrame.this.table.setToolTipText("Currently Selected: None");
                }
                AppFrame.this.updateParameters();
            }
        });
        this.tableScroll = new JScrollPane(this.table);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton aBtn = (AbstractButton)actionEvent.getSource();
                AppFrame.this.loadTable(aBtn.getText(), AppFrame.this.txtSearchTable.getText());
            }
        };
        this.rdbtnItems = new JRadioButton("Items");
        this.rdbtnItems.setSelected(true);
        this.rdbtnItems.addActionListener(actionListener);
        this.buttonGroup.add(this.rdbtnItems);
        this.rdbtnFluids = new JRadioButton("Fluids");
        this.rdbtnFluids.addActionListener(actionListener);
        this.buttonGroup.add(this.rdbtnFluids);
        this.rdbtnOreDict = new JRadioButton("Ore Dict");
        this.rdbtnOreDict.addActionListener(actionListener);
        this.buttonGroup.add(this.rdbtnOreDict);
        this.btnNewRecipe = new JButton("Add New Recipe Using Selected Type");
        this.btnNewRecipe.setEnabled(false);
        this.btnNewRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppFrame.this.listMethods.getSelectedIndex() >= 0 && AppFrame.this.getCurrentScript() != null) {
                    ETRecipeData data = AppFrame.this.recipeData.get(AppFrame.this.listMethods.getSelectedIndex());
                    AppFrame.this.getCurrentScript().recipes.add(new ETActualRecipe(data.getRecipeFormat(), new String[data.getParameterCount()]));
                    AppFrame.this.updateRecipesList(false);
                    AppFrame.this.comboRecipes.setSelectedIndex(AppFrame.this.getCurrentScript().recipes.size() - 1);
                    AppFrame.this.updateCurrentRecipe();
                }
            }
        });
        this.pnlRecipeEdit = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.pnlRecipeEdit);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.txtSearchTable = new JPlaceholderTextField("Search");
        this.txtSearchTable.setDisabledTextColor(UIManager.getColor("Button.disabledText"));
        JButton btnSearchTable = new JButton("Search Table");
        btnSearchTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppFrame.this.loadTable(AppFrame.this.rdbtnItems.isSelected() ? "Items" : (AppFrame.this.rdbtnFluids.isSelected() ? "Fluids" : "Ore Dict"), AppFrame.this.txtSearchTable.getText().trim().toLowerCase());
            }
        });
        ActionListener recipeTypeSelect = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int index;
                if (AppFrame.this.comboRecipes.getSelectedIndex() >= 0 && (index = AppFrame.this.indexOfRecipeFormat(AppFrame.this.getCurrentScript().recipes.get(AppFrame.this.comboRecipes.getSelectedIndex()).getRecipeFormat())) >= 0) {
                    AppFrame.this.recipeData.get(index).setAddRecipe(AppFrame.this.btnRecipeAdd.isSelected());
                }
            }
        };
        this.btnRecipeRemove = new JRadioButton("Remove");
        this.btnRecipeRemove.addActionListener(recipeTypeSelect);
        this.buttonGroup_1.add(this.btnRecipeRemove);
        this.btnRecipeAdd = new JRadioButton("Add/Other");
        this.btnRecipeRemove.addActionListener(recipeTypeSelect);
        this.buttonGroup_1.add(this.btnRecipeAdd);
        JPanel panel = new JPanel();
        this.recipeDisplay = new JTextField();
        this.recipeDisplay.setEditable(false);
        this.recipeDisplay.setColumns(10);
        this.lblCopying = new JLabel("Currently Copying: ");
        this.comboScripts = new JComboBox();
        this.comboScripts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppFrame.this.btnNewRecipe.setEnabled(AppFrame.this.comboScripts.getSelectedIndex() >= 0 && AppFrame.this.listMethods.getModel().getSize() > 0);
                if (e.getStateChange() == 1 && !AppFrame.this.updatingParameters) {
                    AppFrame.this.comboRecipes.setSelectedIndex(-1);
                    AppFrame.this.updateRecipesList(false);
                    AppFrame.this.comboRecipes.setSelectedIndex(-1);
                    AppFrame.this.updateCurrentRecipe();
                }
            }
        });
        JLabel lblCurrentScript = new JLabel("Current Script");
        lblCurrentScript.setHorizontalAlignment(11);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tableScroll, -2, 332, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.rdbtnItems, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtnFluids, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtnOreDict, -2, 79, -2)).addComponent(this.txtSearchTable, -1, 217, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnSearchTable))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(scrollPane, -1, 563, Short.MAX_VALUE).addGap(6)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.btnRecipeRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRecipeAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recipeDisplay, -1, 398, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblCurrentScript, -2, 95, -2).addComponent(this.labelRecipe, -2, 95, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboScripts, GroupLayout.Alignment.TRAILING, 0, 446, Short.MAX_VALUE).addComponent(this.comboRecipes, 0, 446, Short.MAX_VALUE)))).addGap(16)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblCopying).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnNewRecipe, -1, 254, Short.MAX_VALUE).addComponent(this.scrollMethods, GroupLayout.Alignment.TRAILING, -1, 254, Short.MAX_VALUE)).addGap(11)).addGroup(groupLayout.createSequentialGroup().addGap(0).addComponent(panel, -1, 253, Short.MAX_VALUE).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblCopying).addGap(28)).addComponent(panel, -2, 38, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNewRecipe)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSearchTable, -2, 19, -2).addComponent(btnSearchTable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboScripts, -2, 18, -2).addComponent(lblCurrentScript).addComponent(this.rdbtnItems).addComponent(this.rdbtnFluids).addComponent(this.rdbtnOreDict)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollMethods, -1, 639, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableScroll, -1, 639, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelRecipe).addComponent(this.comboRecipes, -2, 18, -2)).addGap(6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRecipeRemove).addComponent(this.btnRecipeAdd).addComponent(this.recipeDisplay, -2, -1, -2)).addGap(9).addComponent(scrollPane, -1, 582, Short.MAX_VALUE)))).addGap(0)));
        this.btnDeleteRecipe = new JButton("Delete Recipe");
        this.btnDeleteRecipe.setAlignmentX(0.5f);
        this.btnDeleteRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppFrame.this.comboRecipes.getSelectedIndex() >= 0) {
                    AppFrame.this.getCurrentScript().recipes.remove(AppFrame.this.comboRecipes.getSelectedIndex());
                    AppFrame.this.comboRecipes.setSelectedIndex(-1);
                    AppFrame.this.updateRecipesList(false);
                    AppFrame.this.comboRecipes.setSelectedIndex(-1);
                    AppFrame.this.updateCurrentRecipe();
                }
            }
        });
        this.btnDupeRecipe = new JButton("Duplicate Recipe");
        this.btnDupeRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppFrame.this.comboRecipes.getSelectedIndex() >= 0) {
                    AppFrame.this.getCurrentScript().recipes.add(AppFrame.this.getCurrentScript().recipes.get(AppFrame.this.comboRecipes.getSelectedIndex()).clone());
                    AppFrame.this.updateRecipesList(false);
                    AppFrame.this.comboRecipes.setSelectedIndex(AppFrame.this.getCurrentScript().recipes.size() - 1);
                    AppFrame.this.updateCurrentRecipe();
                }
            }
        });
        this.btnDupeRecipe.setAlignmentX(0.5f);
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addComponent(this.btnDeleteRecipe, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnDupeRecipe, -1, 135, Short.MAX_VALUE).addGap(0)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(6).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDeleteRecipe).addComponent(this.btnDupeRecipe))));
        panel.setLayout(gl_panel);
        this.pnlRecipeEdit.setLayout(new BoxLayout(this.pnlRecipeEdit, 1));
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.getContentPane().setLayout(groupLayout);
        this.pack();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        JMenuItem menuItemNew = new JMenuItem("New Script");
        menuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuFile.add(menuItemNew);
        menuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.newScript();
            }
        });
        JMenuItem menuItemOpen = new JMenuItem("Open Scripts");
        menuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuFile.add(menuItemOpen);
        menuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.openScripts();
            }
        });
        JMenuItem menuItemSave = new JMenuItem("Save Current Script");
        menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuFile.add(menuItemSave);
        menuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.saveScript(AppFrame.this.getCurrentScript());
            }
        });
        JMenuItem menuItemSaveAs = new JMenuItem("Save Current Script As");
        menuItemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        menuFile.add(menuItemSaveAs);
        menuItemSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.saveCurScriptAs();
            }
        });
        this.mntmSaveAllScripts = new JMenuItem("Save All Scripts");
        this.mntmSaveAllScripts.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        menuFile.add(this.mntmSaveAllScripts);
        this.mntmSaveAllScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.saveAllScripts();
            }
        });
        this.mntmDeleteScript = new JMenuItem("Delete Current Script");
        this.mntmDeleteScript.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        menuFile.add(this.mntmDeleteScript);
        this.mntmDeleteScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.deleteScript();
            }
        });
        JMenuItem mntmImportData = new JMenuItem("Import Obj Data");
        mntmImportData.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        menuFile.add(mntmImportData);
        mntmImportData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.importData();
            }
        });
        JMenuItem mntmExportData = new JMenuItem("Export Obj Data");
        mntmExportData.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuFile.add(mntmExportData);
        mntmExportData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.exportData();
            }
        });
        this.mnOther = new JMenu("Other");
        menuBar.add(this.mnOther);
        this.mntmRenameCurrentScript = new JMenuItem("Rename Current Script");
        this.mnOther.add(this.mntmRenameCurrentScript);
        this.mntmRenameCurrentScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.renameFile();
            }
        });
        this.mntmExportRecipesTo = new JMenuItem("Create Text File Of Recipes");
        this.mnOther.add(this.mntmExportRecipesTo);
        this.mntmExportRecipesTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AppFrame.this.recipeData.size() > 0) {
                    AppFrame.this.sendRecipesToTextFile();
                } else {
                    JOptionPane.showOptionDialog(AppFrame.this, "No Recipes!", "Message", 0, -1, null, new Object[]{"OK"}, "OK");
                }
            }
        });
        this.mntmExportCurrentTable = new JMenuItem("Create Text File Of Current Table");
        this.mnOther.add(this.mntmExportCurrentTable);
        this.mntmExportCurrentTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AppFrame.this.recipeData.size() > 0) {
                    AppFrame.this.sendTableToTextFile();
                } else {
                    JOptionPane.showOptionDialog(AppFrame.this, "Table is Empty!", "Message", 0, -1, null, new Object[]{"OK"}, "OK");
                }
            }
        });
        this.menuHelp = new JMenu("Help");
        menuBar.add(this.menuHelp);
        this.mntmHelp = new JMenuItem("Open Help Wiki");
        this.menuHelp.add(this.mntmHelp);
        this.mntmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.help();
            }
        });
        this.mntmAbout = new JMenuItem("About External Tweaker");
        this.menuHelp.add(this.mntmAbout);
        this.mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.about();
            }
        });
        this.mntmDownload = new JMenuItem("Download External Tweaker");
        this.menuHelp.add(this.mntmDownload);
        this.mntmDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AppFrame.this.download();
            }
        });
        this.setVisible(true);
        this.updateParameters();
        this.updateCurrentRecipe();
    }

    public void updateParameters() {
        for (int i = 0; i < this.paramPanels.size(); ++i) {
            this.paramPanels.get((int)i).editPanel.update();
            this.paramPanels.get((int)i).btnPaste.setEnabled(this.paramPanels.get((int)i).paramType.equals(this.copyType));
            if (this.comboRecipes.getSelectedIndex() < 0 || this.getCurrentScript().recipes.size() <= 0) continue;
            this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).setParameterData(i, this.paramPanels.get(i).exportData());
        }
    }

    public void updateRecipesList(boolean updating) {
        int comboIndex = -1;
        if (updating) {
            comboIndex = this.comboRecipes.getSelectedIndex();
            this.updatingParameters = true;
        }
        String[] displays = new String[this.getCurrentScript() == null ? 0 : this.getCurrentScript().recipes.size()];
        for (int i = 0; i < (this.getCurrentScript() == null ? 0 : this.getCurrentScript().recipes.size()); ++i) {
            if (comboIndex < 0 || this.comboRecipes.getSelectedIndex() == i) {
                int index = this.indexOfRecipeFormat(this.getCurrentScript().recipes.get(i).getRecipeFormat());
                if (index >= 0) {
                    displays[i] = this.getCurrentScript().recipes.get(i).recipeToString(this.recipeData.get(index));
                    String[] split = displays[i].substring(0, displays[i].indexOf("(")).split("\\.");
                    displays[i] = "#" + Integer.toString(i + 1) + "  " + split[split.length - 2] + "." + split[split.length - 1] + displays[i].substring(displays[i].indexOf("("), displays[i].length());
                    ArrayList mappings = new ArrayList();
                    mappings.addAll(new ArrayList(Arrays.asList(this.itemMappings)));
                    mappings.addAll(new ArrayList(Arrays.asList(this.fluidMappings)));
                    mappings.addAll(new ArrayList(Arrays.asList(this.oreDictMappings)));
                    for (int x = 0; x < mappings.size(); ++x) {
                        if (index < 0) continue;
                        List<String> paramTypes = Arrays.asList(this.recipeData.get(index).getParameterTypes());
                        String newVal = "";
                        while (!newVal.equals(displays[i])) {
                            if (!newVal.equals("")) {
                                displays[i] = newVal;
                            }
                            newVal = displays[i].replace(((Object[])mappings.get(x))[0].toString(), ((Object[])mappings.get(x))[1].toString());
                        }
                    }
                    continue;
                }
                displays[i] = "#" + Integer.toString(i + 1) + "  " + this.getCurrentScript().recipes.get(i).getRecipeFormat() + " ERROR: DID NOT FIND RECIPE FORMAT";
                continue;
            }
            displays[i] = (String)this.comboRecipes.getModel().getElementAt(i);
        }
        if (this.comboRecipes.getSelectedIndex() >= 0) {
            int index = this.indexOfRecipeFormat(this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).getRecipeFormat());
            if (index >= 0) {
                this.recipeDisplay.setText(this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).recipeToString(this.recipeData.get(index)));
            } else {
                this.recipeDisplay.setText("");
            }
        } else {
            this.recipeDisplay.setText("");
        }
        this.comboRecipes.setModel(new DefaultComboBoxModel<String>(displays));
        if (updating) {
            this.comboRecipes.setSelectedIndex(comboIndex);
            this.updatingParameters = false;
        }
    }

    public void updateScriptsList(boolean updating) {
        int comboIndex = 0;
        if (updating) {
            comboIndex = this.comboScripts.getSelectedIndex();
            this.updatingParameters = true;
        }
        String[] displays = new String[this.scripts.size()];
        for (int i = 0; i < this.scripts.size(); ++i) {
            displays[i] = "#" + Integer.toString(i + 1) + "  " + this.scripts.get((int)i).filePath + (Strings.isNullOrEmpty(this.scripts.get((int)i).filePath) ? "" : File.separator) + this.scripts.get((int)i).fileName;
        }
        this.comboScripts.setModel(new DefaultComboBoxModel<String>(displays));
        if (updating) {
            this.comboScripts.setSelectedIndex(comboIndex);
            this.updatingParameters = false;
        }
    }

    private void updateCurrentRecipe() {
        this.pnlRecipeEdit.removeAll();
        this.paramPanels.clear();
        if (this.comboRecipes.getSelectedIndex() >= 0) {
            int index = this.indexOfRecipeFormat(this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).getRecipeFormat());
            if (index >= 0) {
                for (String s : this.recipeData.get(index).getParameterTypes()) {
                    this.addParameter(s);
                }
                for (int i = 0; i < this.paramPanels.size(); ++i) {
                    this.btnRecipeAdd.setSelected(this.recipeData.get(index).isAddRecipe());
                    this.btnRecipeRemove.setSelected(!this.recipeData.get(index).isAddRecipe());
                    this.paramPanels.get((int)i).txtName.setText(this.recipeData.get(index).getParamName(i));
                    this.paramPanels.get(i).importData(this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).getParameterData(i));
                }
                this.updateParameters();
                this.recipeDisplay.setText(this.getCurrentScript().recipes.get(this.comboRecipes.getSelectedIndex()).recipeToString(this.recipeData.get(index)));
            } else {
                this.recipeDisplay.setText("");
            }
        }
        this.btnDeleteRecipe.setEnabled(this.comboRecipes.getSelectedIndex() >= 0);
        this.btnDupeRecipe.setEnabled(this.comboRecipes.getSelectedIndex() >= 0);
        this.btnRecipeAdd.setEnabled(this.comboRecipes.getSelectedIndex() >= 0);
        this.btnRecipeRemove.setEnabled(this.comboRecipes.getSelectedIndex() >= 0);
        this.pnlRecipeEdit.revalidate();
        this.pnlRecipeEdit.repaint();
    }

    private void loadTable(String type, String filter) {
        Object[][] array;
        ArrayList keys;
        List<Object> list = keys = this.table.getRowSorter() != null ? ((DefaultRowSorter)this.table.getRowSorter()).getSortKeys() : new ArrayList();
        Object[][] objectArray = type.equals("Items") ? this.itemMappings : (type.equals("Fluids") ? this.fluidMappings : (array = type.equals("Ore Dict") ? this.oreDictMappings : (Object[][])null));
        if (array == null) {
            return;
        }
        if (!Strings.isNullOrEmpty(filter)) {
            ArrayList<Integer> indexesValid = new ArrayList<Integer>();
            for (int i = 0; i < array.length; ++i) {
                if (!array[i][0].toString().toLowerCase().contains(filter) && !array[i][1].toString().toLowerCase().contains(filter)) continue;
                indexesValid.add(i);
            }
            Object[][] newArray = new Object[indexesValid.size()][2];
            for (int i = 0; i < indexesValid.size(); ++i) {
                newArray[i][0] = array[(Integer)indexesValid.get(i)][0];
                newArray[i][1] = array[(Integer)indexesValid.get(i)][1];
            }
            array = newArray;
        }
        this.table.setModel(new DefaultTableModel(array, new String[]{"ID", "Name"}));
        if (this.table.getRowSorter() != null) {
            DefaultRowSorter sorter = (DefaultRowSorter)this.table.getRowSorter();
            sorter.setSortKeys(keys);
            sorter.sort();
        }
    }

    private List<String> methodDisplays() {
        ArrayList<String> displays = new ArrayList<String>();
        ArrayList<ETRecipeData> recipeDataNew = new ArrayList<ETRecipeData>();
        for (ETRecipeData data : this.recipeData) {
            displays.add(data.getRecipeDisplay());
        }
        Collections.sort(displays);
        for (String s : displays) {
            for (ETRecipeData data : this.recipeData) {
                if (!data.getRecipeDisplay().equals(s)) continue;
                recipeDataNew.add(data);
            }
        }
        this.recipeData = recipeDataNew;
        return displays;
    }

    public int indexOfRecipeFormat(String format) {
        for (int i = 0; i < this.recipeData.size(); ++i) {
            if (!this.recipeData.get(i).getRecipeFormat().equals(format)) continue;
            return i;
        }
        return -1;
    }

    private void addParameter(String type) {
        String subtype = (type = type.trim()).startsWith("optional.") ? type.substring("optional.".length()) : type;
        PanelParameterEdit p = new PanelParameterEdit(this.paramPanels.size() + 1, type, this);
        p.setListeners();
        this.pnlRecipeEdit.add(p);
        this.paramPanels.add(p);
    }

    public ETScript getCurrentScript() {
        if (this.comboScripts.getSelectedIndex() >= 0) {
            return this.scripts.get(this.comboScripts.getSelectedIndex());
        }
        return null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppFrame frame = new AppFrame(new Object[0][0], new Object[0][0], new Object[0][0], new ArrayList<String>());
                frame.setVisible(true);
                frame.setDefaultCloseOperation(3);
            }
        });
    }

    private void newScript() {
        String fileName = JOptionPane.showInputDialog(this, "New script file name", "New Script.zs");
        if (Strings.isNullOrEmpty(fileName)) {
            return;
        }
        if (!fileName.trim().endsWith(".zs")) {
            fileName = fileName.trim() + ".zs";
        }
        this.scripts.add(new ETScript("", fileName));
        this.updateScriptsList(false);
        this.comboScripts.setSelectedIndex(this.scripts.size() - 1);
        this.comboRecipes.setSelectedIndex(-1);
        this.updateRecipesList(false);
        this.comboRecipes.setSelectedIndex(-1);
        this.updateCurrentRecipe();
        this.btnNewRecipe.setEnabled(this.comboScripts.getSelectedIndex() >= 0 && this.listMethods.getModel().getSize() > 0);
    }

    private void deleteScript() {
        int dialogResult;
        if (this.scripts.size() > 0 && this.comboScripts.getSelectedIndex() >= 0 && (dialogResult = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this script? \n \n This will also delete the actual file!", "Warning", 0)) == 0) {
            if (!Strings.isNullOrEmpty(this.getCurrentScript().filePath)) {
                new File(this.getCurrentScript().filePath + File.separator + this.getCurrentScript().fileName).delete();
            }
            this.scripts.remove(this.comboScripts.getSelectedIndex());
            this.comboScripts.setSelectedIndex(-1);
            this.updateScriptsList(false);
            this.comboScripts.setSelectedIndex(-1);
            this.comboRecipes.setSelectedIndex(-1);
            this.updateRecipesList(false);
            this.comboRecipes.setSelectedIndex(-1);
            this.updateCurrentRecipe();
        }
    }

    private void exportData() {
        PanelImportExportDialog dataPanel = new PanelImportExportDialog(false);
        int input = JOptionPane.showOptionDialog(this, dataPanel, "Exporting Data", 2, -1, null, new Object[]{"Export", "Cancel"}, "Export");
        boolean[] settings = dataPanel.getSettings();
        if (!(input != 0 || !Strings.isNullOrEmpty(dataPanel.txtPath.getText().trim()) && dataPanel.txtPath.getText().trim().endsWith(".etd") && (settings[0] || settings[1] || settings[2] || settings[3]))) {
            JOptionPane.showOptionDialog(this, "Invalid file path", "Error", 0, 0, null, new Object[]{"OK"}, "OK");
            return;
        }
        if (input != 0) {
            return;
        }
        boolean fileExists = new File(dataPanel.txtPath.getText().trim()).isFile();
        try {
            if (settings[4]) {
                FileOutputStream file = new FileOutputStream(dataPanel.txtPath.getText().trim());
                ObjectOutputStream save = new ObjectOutputStream(file);
                this.exportOverride(settings, save);
                save.close();
            } else if (fileExists) {
                FileInputStream curFile = new FileInputStream(dataPanel.txtPath.getText().trim());
                ObjectInputStream cur = new ObjectInputStream(curFile);
                this.exportAdd(settings, dataPanel.txtPath.getText().trim(), cur);
            } else {
                FileOutputStream file = new FileOutputStream(dataPanel.txtPath.getText().trim());
                ObjectOutputStream save = new ObjectOutputStream(file);
                this.exportOverride(settings, save);
                save.close();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showOptionDialog(this, exc.getLocalizedMessage(), "Error! Try exporting from the game again! Report this issue if that fails!", 0, 0, null, new Object[]{"OK"}, "OK");
        }
        JOptionPane.showOptionDialog(this, "Export Finished!", "Done", 0, -1, null, new Object[]{"OK"}, "OK");
    }

    private void exportOverride(boolean[] settings, ObjectOutputStream save) throws IOException {
        if (settings[1] && this.itemMappings != null) {
            save.writeObject(this.itemMappings);
        } else {
            save.writeObject(new Object[0][0]);
        }
        if (settings[2] && this.fluidMappings != null) {
            save.writeObject(this.fluidMappings);
        } else {
            save.writeObject(new Object[0][0]);
        }
        if (settings[3] && this.oreDictMappings != null) {
            save.writeObject(this.oreDictMappings);
        } else {
            save.writeObject(new Object[0][0]);
        }
        if (settings[0] && this.recipeData != null) {
            save.writeObject(this.recipeData);
        } else {
            save.writeObject(new ArrayList());
        }
    }

    private void exportAdd(boolean[] settings, String savePath, ObjectInputStream cur) throws IOException, ClassNotFoundException {
        int i2;
        boolean contains;
        int i;
        ArrayList iMap = new ArrayList(Arrays.asList((Object[][])cur.readObject()));
        ArrayList fMap = new ArrayList(Arrays.asList((Object[][])cur.readObject()));
        ArrayList oMap = new ArrayList(Arrays.asList((Object[][])cur.readObject()));
        ArrayList rList = (ArrayList)cur.readObject();
        cur.close();
        FileOutputStream file = new FileOutputStream(savePath);
        ObjectOutputStream save = new ObjectOutputStream(file);
        if (settings[1]) {
            for (i = 0; i < this.itemMappings.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < iMap.size(); ++i2) {
                    if (!this.itemMappings[i][0].equals(((Object[])iMap.get(i2))[0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                iMap.add(this.itemMappings[i]);
            }
            save.writeObject(iMap.toArray((T[])new Object[iMap.size()][2]));
        } else {
            save.writeObject(iMap.toArray((T[])new Object[iMap.size()][2]));
        }
        if (settings[2]) {
            for (i = 0; i < this.fluidMappings.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < fMap.size(); ++i2) {
                    if (!this.fluidMappings[i][0].equals(((Object[])fMap.get(i2))[0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                fMap.add(this.fluidMappings[i]);
            }
            save.writeObject(fMap.toArray((T[])new Object[fMap.size()][2]));
        } else {
            save.writeObject(fMap.toArray((T[])new Object[fMap.size()][2]));
        }
        if (settings[3]) {
            for (i = 0; i < this.oreDictMappings.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < oMap.size(); ++i2) {
                    if (!this.oreDictMappings[i][0].equals(((Object[])oMap.get(i2))[0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                oMap.add(this.oreDictMappings[i]);
            }
            save.writeObject(oMap.toArray((T[])new Object[oMap.size()][2]));
        } else {
            save.writeObject(oMap.toArray((T[])new Object[oMap.size()][2]));
        }
        if (settings[0]) {
            for (i = 0; i < this.recipeData.size(); ++i) {
                contains = false;
                for (i2 = 0; i2 < rList.size(); ++i2) {
                    if (!((ETRecipeData)rList.get(i2)).getRecipeFormat().equals(this.recipeData.get(i).getRecipeFormat())) continue;
                    contains = true;
                    for (int x = 0; x < ((ETRecipeData)rList.get(i2)).getParameterTypes().length; ++x) {
                        if (!Strings.isNullOrEmpty(((ETRecipeData)rList.get(i2)).getParamName(x))) continue;
                        ((ETRecipeData)rList.get(i2)).setParamName(x, this.recipeData.get(i).getParamName(x));
                    }
                    break;
                }
                if (contains) continue;
                rList.add(this.recipeData.get(i));
            }
            save.writeObject(rList);
        } else {
            save.writeObject(rList);
        }
        save.close();
    }

    private void importData() {
        PanelImportExportDialog dataPanel = new PanelImportExportDialog(true);
        int input = JOptionPane.showOptionDialog(this, dataPanel, "Importing Data", 2, -1, null, new Object[]{"Import", "Cancel"}, "Import");
        boolean[] settings = dataPanel.getSettings();
        if (!(input != 0 || !Strings.isNullOrEmpty(dataPanel.txtPath.getText().trim()) && dataPanel.txtPath.getText().trim().endsWith(".etd") && (settings[0] || settings[1] || settings[2] || settings[3]))) {
            JOptionPane.showOptionDialog(this, "Invalid file path", "Error", 0, 0, null, new Object[]{"OK"}, "OK");
            return;
        }
        if (input != 0) {
            return;
        }
        try {
            FileInputStream saveFile = new FileInputStream(dataPanel.txtPath.getText().trim());
            ObjectInputStream save = new ObjectInputStream(saveFile);
            if (settings[4]) {
                this.importOverride(settings, save);
            } else {
                this.importAdd(settings, save);
            }
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String s : this.methodDisplays()) {
                model.addElement(s);
            }
            this.listMethods.setModel(model);
            this.txtSearchTable.setText("");
            this.loadTable(this.rdbtnItems.isSelected() ? "Items" : (this.rdbtnFluids.isSelected() ? "Fluids" : "Ore Dict"), "");
            save.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showOptionDialog(this, exc.getLocalizedMessage(), "Error! Try importing from the game again! Especially if you updated this program!\nReport this issue if this fails!", 0, 0, null, new Object[]{"OK"}, "OK");
        }
        JOptionPane.showOptionDialog(this, "Import Finished!", "Done", 0, -1, null, new Object[]{"OK"}, "OK");
    }

    private void importOverride(boolean[] settings, ObjectInputStream save) throws IOException, ClassNotFoundException {
        if (settings[1]) {
            this.itemMappings = (Object[][])save.readObject();
        } else {
            save.readObject();
        }
        if (settings[2]) {
            this.fluidMappings = (Object[][])save.readObject();
        } else {
            save.readObject();
        }
        if (settings[3]) {
            this.oreDictMappings = (Object[][])save.readObject();
        } else {
            save.readObject();
        }
        if (settings[0]) {
            this.recipeData = (ArrayList)save.readObject();
        } else {
            save.readObject();
        }
    }

    private void importAdd(boolean[] settings, ObjectInputStream save) throws IOException, ClassNotFoundException {
        int i2;
        boolean contains;
        int i;
        if (settings[1]) {
            Object[][] iMap = (Object[][])save.readObject();
            ArrayList iMappings = new ArrayList(Arrays.asList(this.itemMappings));
            for (i = 0; i < iMap.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < iMappings.size(); ++i2) {
                    if (!((Object[])iMappings.get(i2))[0].equals(iMap[i][0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                iMappings.add(iMap[i]);
            }
            this.itemMappings = (Object[][])iMappings.toArray((T[])new Object[iMappings.size()][2]);
        } else {
            save.readObject();
        }
        if (settings[2]) {
            Object[][] fMap = (Object[][])save.readObject();
            ArrayList fMappings = new ArrayList(Arrays.asList(this.fluidMappings));
            for (i = 0; i < fMap.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < fMappings.size(); ++i2) {
                    if (!((Object[])fMappings.get(i2))[0].equals(fMap[i][0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                fMappings.add(fMap[i]);
            }
            this.fluidMappings = (Object[][])fMappings.toArray((T[])new Object[fMappings.size()][2]);
        } else {
            save.readObject();
        }
        if (settings[3]) {
            Object[][] oMap = (Object[][])save.readObject();
            ArrayList oMappings = new ArrayList(Arrays.asList(this.oreDictMappings));
            for (i = 0; i < oMap.length; ++i) {
                contains = false;
                for (i2 = 0; i2 < oMappings.size(); ++i2) {
                    if (!((Object[])oMappings.get(i2))[0].equals(oMap[i][0])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                oMappings.add(oMap[i]);
            }
            this.oreDictMappings = (Object[][])oMappings.toArray((T[])new Object[oMappings.size()][2]);
        } else {
            save.readObject();
        }
        if (settings[0]) {
            ArrayList rList = (ArrayList)save.readObject();
            for (int i22 = 0; i22 < rList.size(); ++i22) {
                boolean contains2 = false;
                for (int i3 = 0; i3 < this.recipeData.size(); ++i3) {
                    if (!((ETRecipeData)rList.get(i22)).getRecipeFormat().equals(this.recipeData.get(i3).getRecipeFormat())) continue;
                    contains2 = true;
                    for (int x = 0; x < ((ETRecipeData)rList.get(i22)).getParameterTypes().length; ++x) {
                        if (!Strings.isNullOrEmpty(this.recipeData.get(i3).getParamName(x))) continue;
                        this.recipeData.get(i3).setParamName(x, ((ETRecipeData)rList.get(i22)).getParamName(x));
                    }
                    break;
                }
                if (contains2) continue;
                this.recipeData.add((ETRecipeData)rList.get(i22));
            }
        } else {
            save.readObject();
        }
    }

    private void saveScript(ETScript script) {
        if (Strings.isNullOrEmpty(script.filePath)) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(!Strings.isNullOrEmpty(script.filePath) ? script.filePath + File.separator + script.fileName : System.getProperty("user.dir") + File.separator + script.filePath));
            fc.setSelectedFile(new File(script.fileName));
            fc.setFileFilter(new FileNameExtensionFilter("ZS Scripts", "zs"));
            if (fc.showSaveDialog(this) == 0) {
                script.filePath = fc.getSelectedFile().getAbsolutePath().substring(0, fc.getSelectedFile().getAbsolutePath().lastIndexOf(File.separator));
                script.fileName = fc.getSelectedFile().getAbsolutePath().substring(fc.getSelectedFile().getAbsolutePath().lastIndexOf(File.separator) + 1);
                if (!script.fileName.endsWith(".zs")) {
                    script.fileName = script.fileName + ".zs";
                }
            } else {
                return;
            }
        }
        BufferedWriter writer = null;
        try {
            int index;
            writer = new BufferedWriter(new FileWriter(new File(script.filePath + File.separator + script.fileName)));
            writer.write("# CREATED USING EXTERNAL TWEAKER\n");
            for (ETActualRecipe r : script.recipes) {
                index = this.indexOfRecipeFormat(r.getRecipeFormat());
                if (index < 0 || this.recipeData.get(index).isAddRecipe()) continue;
                writer.write(r.recipeToString(this.recipeData.get(index)) + "\n");
            }
            writer.write("\n");
            for (ETActualRecipe r : script.recipes) {
                index = this.indexOfRecipeFormat(r.getRecipeFormat());
                if (index >= 0) {
                    if (!this.recipeData.get(index).isAddRecipe()) continue;
                    writer.write(r.recipeToString(this.recipeData.get(index)) + "\n");
                    continue;
                }
                writer.write(r.recipeToString(this.recipeData.get(index)) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showOptionDialog(this, e.getLocalizedMessage(), "Error! Report this issue if you can!", 0, 0, null, new Object[]{"OK"}, "OK");
        }
    }

    private void openScripts() {
        File[] files = null;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileNameExtensionFilter("ZS Scripts", "zs"));
        fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (fc.showOpenDialog(this) == 0) {
            files = fc.getSelectedFiles();
        }
        if (files == null) {
            return;
        }
        ArrayList<File> allScripts = new ArrayList<File>();
        for (File f : files) {
            allScripts.addAll(f.isDirectory() ? this.getScripts(f) : Collections.singletonList(f));
        }
        boolean ignoreErrors = false;
        for (File f : allScripts) {
            ETScript script = new ETScript(f.getAbsolutePath().substring(0, f.getAbsolutePath().lastIndexOf(File.separator)), f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf(File.separator) + 1));
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showOptionDialog(this, e.getLocalizedMessage(), "Error! Report this issue if you can!", 0, 0, null, new Object[]{"OK"}, "OK");
            }
            boolean skippingScript = false;
            int lineNum = 0;
            String lastLine = "";
            HashMap<String, String> variables = new HashMap<String, String>();
            for (String string : lines) {
                try {
                    ++lineNum;
                    if (Strings.isNullOrEmpty(string) || string.startsWith("#") || string.startsWith("//") || string.startsWith("/*") || string.endsWith("*/")) continue;
                    if (!(lastLine + string).endsWith(";")) {
                        lastLine = lastLine + string;
                        continue;
                    }
                    String s = lastLine + string;
                    lastLine = "";
                    if (s.startsWith("val ") && s.contains("=")) {
                        String[] variable = s.trim().substring(4, s.trim().length() - 1).split("=");
                        variables.put(variable[0].trim(), variable[1].trim());
                        continue;
                    }
                    ETRecipeData d = this.findRecipeDataForRecipe(s);
                    if (d != null) {
                        String params = s.substring(s.indexOf("(") + 1, s.lastIndexOf(")"));
                        HashMap<Integer, Object> arrayIndexes = new HashMap<Integer, Object>();
                        ArrayList<Object> paramList = new ArrayList<String>();
                        boolean varGoThroughAgain = true;
                        while (varGoThroughAgain) {
                            varGoThroughAgain = false;
                            boolean changedSomething = true;
                            while (changedSomething) {
                                Object arg;
                                changedSomething = false;
                                while (params.contains(".withTag(") && params.contains(")") && params.indexOf(".withTag(") < params.indexOf(")") && !params.substring(params.indexOf(".withTag("), params.indexOf(")") + 1).contains(".onlyWithTag(")) {
                                    arg = params.substring(params.indexOf(".withTag("), params.indexOf(")") + 1);
                                    params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                    arrayIndexes.put(arrayIndexes.size(), arg);
                                    changedSomething = true;
                                }
                                if (!changedSomething) {
                                    while (params.contains("\"") && params.substring(params.indexOf("\"") + 1).contains("\"")) {
                                        arg = params.substring(params.indexOf("\""), params.indexOf("\"", params.indexOf("\"") + 1) + 1);
                                        params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                        arrayIndexes.put(arrayIndexes.size(), arg);
                                        changedSomething = true;
                                    }
                                }
                                if (!changedSomething) {
                                    while (params.contains(".onlyWithTag(") && params.contains(")") && params.indexOf(".onlyWithTag(") < params.indexOf(")")) {
                                        arg = params.substring(params.indexOf(".onlyWithTag("), params.indexOf(")") + 1);
                                        params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                        arrayIndexes.put(arrayIndexes.size(), arg);
                                        changedSomething = true;
                                    }
                                }
                                if (!changedSomething) {
                                    while (params.contains("<") && params.contains(">") && params.indexOf("<") < params.indexOf(">")) {
                                        arg = params.substring(params.indexOf("<"), params.indexOf(">") + 1);
                                        params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                        arrayIndexes.put(arrayIndexes.size(), arg);
                                        changedSomething = true;
                                    }
                                }
                                if (!changedSomething) {
                                    for (String var : variables.keySet()) {
                                        while (params.contains(var)) {
                                            varGoThroughAgain = true;
                                            for (String var2 : variables.keySet()) {
                                                String[] splitVar = ((String)variables.get(var)).split("\\.");
                                                if (var.equals(var2) || splitVar.length <= 1 || !splitVar[0].equals(var2)) continue;
                                                splitVar[0] = (String)variables.get(var2);
                                                String arg2 = "";
                                                for (int i = 0; i < splitVar.length; ++i) {
                                                    arg2 = arg2 + splitVar[i];
                                                    if (i >= splitVar.length - 1) continue;
                                                    arg2 = arg2 + ".";
                                                }
                                                params = params.replace(var, arg2);
                                                changedSomething = true;
                                            }
                                            if (changedSomething) break;
                                            String arg3 = (String)variables.get(var);
                                            params = params.replace(var, "~" + arrayIndexes.size() + "~");
                                            arrayIndexes.put(arrayIndexes.size(), arg3);
                                            changedSomething = true;
                                        }
                                        if (!changedSomething) continue;
                                        break;
                                    }
                                }
                                if (!changedSomething) {
                                    while (params.contains("[[") && params.contains("]]") && params.indexOf("[[") < params.indexOf("]]")) {
                                        arg = params.substring(params.indexOf("[["), params.indexOf("]]") + 2);
                                        params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                        arrayIndexes.put(arrayIndexes.size(), arg);
                                        changedSomething = true;
                                    }
                                }
                                if (changedSomething) continue;
                                while (params.contains("[") && params.contains("]") && params.indexOf("[") < params.indexOf("]")) {
                                    arg = params.substring(params.indexOf("["), params.indexOf("]") + 1);
                                    params = params.replace((CharSequence)arg, "~" + arrayIndexes.size() + "~");
                                    arrayIndexes.put(arrayIndexes.size(), arg);
                                    changedSomething = true;
                                }
                            }
                            paramList = new ArrayList<String>(Arrays.asList(params.split(",")));
                            for (int i = 0; i < paramList.size(); ++i) {
                                paramList.set(i, ((String)paramList.get(i)).trim());
                                boolean changed = true;
                                String p = ((String)paramList.get(i)).substring(0, ((String)paramList.get(i)).length());
                                while (changed) {
                                    changed = false;
                                    for (int i2 = 0; i2 < arrayIndexes.size(); ++i2) {
                                        if (!p.contains("~" + i2 + "~")) continue;
                                        p = p.replace("~" + i2 + "~", (CharSequence)arrayIndexes.get(i2));
                                        changed = true;
                                    }
                                }
                                paramList.set(i, p);
                            }
                        }
                        while (paramList.size() < d.getParameterCount()) {
                            paramList.add("~");
                        }
                        script.recipes.add(new ETActualRecipe(this.findRecipeDataForRecipe(s).getRecipeFormat(), paramList.toArray(new String[paramList.size()])));
                        continue;
                    }
                    if (ignoreErrors) continue;
                    int result = JOptionPane.showOptionDialog(this, "The line: " + s + " in " + script.fileName + " at line " + lineNum + " \n could not be loaded into External Tweaker. Make sure to import all the recipes you need first.\n Any recipes not loaded will be lost if you DO save over the script. \n Make a backup of the script if you have parts you want to keep.", "Script Loading Error", 0, -1, null, new Object[]{"Cancel Loading Of Scripts", "Skip loading this Script", "Ignore Once and Continue", "Ignore Everything and Continue"}, "Ignore Once and Continue");
                    if (result == 0) {
                        return;
                    }
                    if (result == 1) {
                        skippingScript = true;
                        break;
                    }
                    if (result != 3) continue;
                    ignoreErrors = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showOptionDialog(this, e.getLocalizedMessage() + " when loading " + script.fileName + " at line " + lineNum, "Error! Report this issue if you can!", 0, 0, null, new Object[]{"OK"}, "OK");
                    return;
                }
            }
            if (skippingScript) continue;
            boolean replaced = false;
            for (int i = 0; i < this.scripts.size(); ++i) {
                if (!this.scripts.get((int)i).fileName.equals(script.fileName) || !this.scripts.get((int)i).filePath.equals(script.filePath)) continue;
                this.scripts.set(i, script);
                replaced = true;
            }
            if (!replaced) {
                this.scripts.add(script);
            }
            this.updateScriptsList(false);
            this.comboScripts.setSelectedIndex(0);
            this.comboRecipes.setSelectedIndex(-1);
            this.updateRecipesList(false);
            this.comboRecipes.setSelectedIndex(-1);
            this.updateCurrentRecipe();
            this.btnNewRecipe.setEnabled(this.comboScripts.getSelectedIndex() >= 0 && this.listMethods.getModel().getSize() > 0);
        }
    }

    public ETRecipeData findRecipeDataForRecipe(String recipe) {
        if (!recipe.contains("(")) {
            return null;
        }
        String begin = recipe.substring(0, recipe.indexOf("("));
        String params = recipe.substring(recipe.indexOf("(") + 1, recipe.lastIndexOf(")"));
        while (params.contains("[[") && params.contains("]]")) {
            params = params.replace(params.substring(params.indexOf("[["), params.indexOf("]]") + 2), " ");
        }
        while (params.contains("[") && params.contains("]")) {
            params = params.replace(params.substring(params.indexOf("["), params.indexOf("]") + 1), " ");
        }
        int numParam = params.split(",").length;
        for (ETRecipeData d : this.recipeData) {
            if (!d.getRecipeFormat().startsWith(begin) || numParam > d.getParameterCount() || numParam < d.getParameterCountOptMin()) continue;
            return d;
        }
        return null;
    }

    public List<File> getScripts(File ... files) {
        ArrayList<File> scriptFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                scriptFiles.addAll(this.getScripts(file.listFiles()));
                continue;
            }
            if (!file.getAbsolutePath().endsWith(".zs")) continue;
            scriptFiles.add(file);
        }
        return scriptFiles;
    }

    private void saveAllScripts() {
        for (ETScript s : this.scripts) {
            this.saveScript(s);
        }
    }

    private void saveCurScriptAs() {
        ETScript script = this.getCurrentScript().clone();
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(!Strings.isNullOrEmpty(script.filePath) ? script.filePath + File.separator + script.fileName : System.getProperty("user.dir") + File.separator + script.filePath));
        fc.setSelectedFile(new File(script.fileName));
        fc.setFileFilter(new FileNameExtensionFilter("ZS Scripts", "zs"));
        if (fc.showSaveDialog(this) == 0) {
            script.filePath = fc.getSelectedFile().getAbsolutePath().substring(0, fc.getSelectedFile().getAbsolutePath().lastIndexOf(File.separator));
            script.fileName = fc.getSelectedFile().getAbsolutePath().substring(fc.getSelectedFile().getAbsolutePath().lastIndexOf(File.separator) + 1);
            if (!script.fileName.endsWith(".zs")) {
                script.fileName = script.fileName + ".zs";
            }
            this.saveScript(script);
        }
    }

    private void help() {
        JOptionPane.showOptionDialog(this, "Currently Unimplemented in this version. Coming soon...", "RIP", 0, -1, null, new Object[]{"OK"}, "OK");
    }

    private void download() {
        if (JOptionPane.showConfirmDialog(this, "Go to download page?\nhttps://minecraft.curseforge.com/projects/external-tweaker/files\nProgram files found under additional files of 1.10.2 versions", "Download", 0, -1) == 0) {
            try {
                Desktop.getDesktop().browse(new URI("https://minecraft.curseforge.com/projects/external-tweaker/files"));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void about() {
        JOptionPane.showOptionDialog(this, "Made by Bartz24\nPlease make sure versions are the same in the mod and app", "Version 0.3", 0, -1, null, new Object[]{"OK"}, "OK");
    }

    private void sendTableToTextFile() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(System.getProperty("user.dir") + File.separator + "tableList.txt"));
        fc.setSelectedFile(new File("tableList.txt"));
        fc.setFileFilter(new FileNameExtensionFilter("Text File", "txt"));
        String filePath = "";
        if (fc.showSaveDialog(this) == 0) {
            filePath = fc.getSelectedFile().getAbsolutePath();
            if (!filePath.endsWith(".txt")) {
                filePath = filePath + ".txt";
            }
        } else {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(filePath)));
            writer.write("TABLE DATA FROM EXTERNAL TWEAKER (" + (this.rdbtnItems.isSelected() ? "Items" : (this.rdbtnFluids.isSelected() ? "Fluids" : "Ore Dict")) + ")\n");
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                writer.write(this.table.getValueAt(i, 0) + ": " + this.table.getValueAt(i, 1) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showOptionDialog(this, e.getLocalizedMessage(), "Error! Report this issue if you can!", 0, 0, null, new Object[]{"OK"}, "OK");
        }
    }

    private void sendRecipesToTextFile() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(System.getProperty("user.dir") + File.separator + "recipeList.txt"));
        fc.setSelectedFile(new File("recipeList.txt"));
        fc.setFileFilter(new FileNameExtensionFilter("Text File", "txt"));
        String filePath = "";
        if (fc.showSaveDialog(this) == 0) {
            filePath = fc.getSelectedFile().getAbsolutePath();
            if (!filePath.endsWith(".txt")) {
                filePath = filePath + ".txt";
            }
        } else {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(filePath)));
            writer.write("RECIPE DATA FROM EXTERNAL TWEAKER\n");
            for (int i = 0; i < this.recipeData.size(); ++i) {
                writer.write(this.recipeData.get(i).getRecipeFormat() + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showOptionDialog(this, e.getLocalizedMessage(), "Error! Report this issue if you can!", 0, 0, null, new Object[]{"OK"}, "OK");
        }
    }

    private void renameFile() {
        ETScript script = this.getCurrentScript();
        if (script != null) {
            File file;
            String fileName = JOptionPane.showInputDialog(this, "Rename script file name", script.fileName);
            if (!fileName.trim().endsWith(".zs")) {
                fileName = fileName.trim() + ".zs";
            }
            if (!Strings.isNullOrEmpty(script.filePath) && !(file = new File(script.filePath + File.separator + script.fileName)).renameTo(new File(script.filePath + File.separator + fileName))) {
                JOptionPane.showOptionDialog(this, "Failed to rename script!", "Error!", 0, 0, null, new Object[]{"OK"}, "OK");
            }
            script.fileName = fileName;
            this.updateScriptsList(false);
        }
    }
}

