/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.externaltweaker;

import com.bartz24.externaltweaker.OpenTweakerCmd;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@Mod(modid="externaltweaker", name="External Tweaker", version="0.3", dependencies="required-after:crafttweaker", useMetadata=true, acceptedMinecraftVersions="[1.12]")
public class ExternalTweaker {
    public static final String MODID = "externaltweaker";
    public static final String MODNAME = "External Tweaker";
    public static final String VERSION = "0.3";
    public static List<String> methodList;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.loadMethodList(event);
    }

    @Mod.EventHandler
    public void serverLoading(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new OpenTweakerCmd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMethodList(FMLPreInitializationEvent event) {
        ArrayList<String> methods = new ArrayList<String>();
        Set asmDatas = event.getAsmData().getAll(ZenClass.class.getCanonicalName());
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> zenClass = Class.forName(asmData.getClassName());
                for (Method method : zenClass.getMethods()) {
                    if (!method.isAnnotationPresent(ZenMethod.class)) continue;
                    String param = "";
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        if (i > 0) {
                            param = param + ", ";
                        }
                        Class<?> paramType = method.getParameterTypes()[i];
                        param = param + (this.hasOptAnnot(method, i) ? "optional." : "") + paramType.getSimpleName();
                    }
                    String methodForThing = this.getClassName(zenClass.getAnnotation(ZenClass.class).value()) + "." + method.getName() + "(" + param + ");";
                    if (this.isBlacklisted(methodForThing)) continue;
                    methods.add(methodForThing);
                }
            }
            catch (Throwable throwable) {
            }
        }
        methodList = methods;
    }

    private boolean hasOptAnnot(Method method, int paramIndex) {
        for (int a = 0; a < method.getParameterAnnotations()[paramIndex].length; ++a) {
            if (!(method.getParameterAnnotations()[paramIndex][a] instanceof Optional)) continue;
            return true;
        }
        return false;
    }

    private String getClassName(String name) {
        if (name.startsWith("crafttweaker.recipes.IRecipeManager")) {
            return "recipes";
        }
        if (name.startsWith("crafttweaker.recipes.IFurnaceManager")) {
            return "furnace";
        }
        return name;
    }

    private boolean isBlacklisted(String name) {
        String check = "crafttweaker.";
        return name.startsWith(check) && ((name = name.substring(check.length())).startsWith("event") || name.startsWith("data") || name.startsWith("game") || name.startsWith("container") || name.startsWith("container") || name.startsWith("entity") || name.startsWith("liquid") || name.startsWith("item") || name.startsWith("block") || name.startsWith("vanilla") || name.startsWith("server") || name.startsWith("world") || name.startsWith("recipes") || name.startsWith("player") || name.startsWith("IMineTweaker") || name.startsWith("oredict"));
    }
}

