/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import com.google.common.collect.Lists;
import ferro2000.immersivetech.api.ITUtils;
import ferro2000.immersivetech.api.client.MechanicalEnergyAnimation;
import ferro2000.immersivetech.api.energy.MechanicalEnergy;
import ferro2000.immersivetech.api.energy.SteamHandler;
import ferro2000.immersivetech.common.Config;
import ferro2000.immersivetech.common.blocks.ITBlockInterface;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockSteamTurbine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntitySteamTurbine
extends TileEntityMultiblockMetal<TileEntitySteamTurbine, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
ITBlockInterface.IMechanicalEnergy {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public MechanicalEnergy mechanicalEnergy = new MechanicalEnergy();
    MechanicalEnergyAnimation animation = new MechanicalEnergyAnimation();
    private boolean active = false;

    public TileEntitySteamTurbine() {
        super((MultiblockHandler.IMultiblock)MultiblockSteamTurbine.instance, new int[]{4, 10, 3}, 0, true);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.active = nbt.func_74767_n("active");
        this.mechanicalEnergy.readFromNBT(nbt);
        this.animation.readFromNBT(nbt);
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("active", this.active);
        this.mechanicalEnergy.writeToNBT(nbt);
        this.animation.writeToNBT(nbt);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        this.animation = ITUtils.setRotationAngle(this.animation, this.active);
        if (!this.field_145850_b.field_72995_K) {
            boolean prevActive = this.active;
            if (!this.isRSDisabled() && this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != null && ITUtils.checkMechanicalEnergyReceiver(this.field_145850_b, this.func_174877_v()) && ITUtils.checkAlternatorStatus(this.field_145850_b, this.func_174877_v())) {
                int burnTime = SteamHandler.getBurnTime(this.tanks[0].getFluid().getFluid());
                if (burnTime > 0) {
                    int fluidConsumed = 1000 / burnTime / 2 * Config.ITConfig.Machines.steamTurbine_burnTimeModifier;
                    if (this.tanks[0].getFluidAmount() >= fluidConsumed) {
                        if (!this.active) {
                            this.active = true;
                            this.animation.setAnimationFadeIn(80);
                        }
                        this.mechanicalEnergy.setMechanicalEnergy(Config.ITConfig.Machines.steamTurbine_maxTorque, Config.ITConfig.Machines.steamTurbine_maxSpeed);
                        this.tanks[0].drain(fluidConsumed, true);
                    } else if (this.active) {
                        this.mechanicalEnergy.setMechanicalEnergy(0, 0);
                        this.active = false;
                        this.animation.setAnimationFadeOut(160);
                    }
                }
            } else if (this.active) {
                this.active = false;
                this.animation.setAnimationFadeOut(160);
                this.mechanicalEnergy.setMechanicalEnergy(0, 0);
            }
            if (prevActive != this.active) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    public float[] getBlockBounds() {
        return null;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntitySteamTurbine master = (TileEntitySteamTurbine)this.master();
        if (master != null && this.field_174879_c == 30 && (side == null || side == this.facing.func_176734_d())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        if (resources == null) {
            return false;
        }
        return SteamHandler.isValidSteam(resources.getFluid());
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        double[] boundingArray = new double[6];
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c <= 2) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.5, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 1) {
                boundingArray = ITUtils.smartBoundingBox(0.25, 0.125, 0.125, 0.125, 0.625, 1.0, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.0, 0.0, 0.5, 1.0, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            if (this.field_174879_c == 2) {
                boundingArray = ITUtils.smartBoundingBox(0.125, 0.75, 0.625, 0.125, 0.5, 1.0, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                boundingArray = ITUtils.smartBoundingBox(0.75, 0.125, 0.625, 0.125, 0.5, 1.0, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 3 || this.field_174879_c == 5) {
            if (this.field_174879_c == 5) {
                fw = fw.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.5, 0.0, 0.0, 1.0, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 6 || this.field_174879_c == 8 || this.field_174879_c == 18 || this.field_174879_c == 20 || this.field_174879_c == 21 || this.field_174879_c == 23) {
            if (this.field_174879_c == 8 || this.field_174879_c == 20 || this.field_174879_c == 23) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c == 18 || this.field_174879_c == 20) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.5, 0.0, 0.0, 1.0, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.5, 0.0, 0.5, 0.0, 1.0, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 30) {
            boundingArray = ITUtils.smartBoundingBox(0.875, 0.0, 0.125, 0.125, 0.125, 0.875, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.125, 0.25, 0.25, 0.25, 0.75, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            boundingArray = ITUtils.smartBoundingBox(0.375, 0.25, 0.3125, 0.3125, 0.75, 0.875, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            boundingArray = ITUtils.smartBoundingBox(0.4375, 0.3125, 0.375, 0.375, 0.875, 1.0, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 31) {
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.125, 0.125, 0.125, 0.0, 0.375, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.0, 0.0, 0.0, 0.5, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            boundingArray = ITUtils.smartBoundingBox(0.375, 0.25, 0.3125, 0.3125, 0.375, 0.5, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            boundingArray = ITUtils.smartBoundingBox(0.4375, 0.3125, 0.375, 0.375, 0.5, 1.0, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 32) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.5, 0.0, 0.0, 1.0, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 33) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.25, 0.25, 0.25, 0.75, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.25, 0.75, 0.0, 0.0, 0.75, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 34) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.25, 0.0, 0.0, 0.0, 1.0, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.75, 0.0, 0.0, 0.0, 0.0, 0.5, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 35) {
            fw = fw.func_176734_d();
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.25, 0.75, 0.0, 0.0, 0.75, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 36 || this.field_174879_c == 38 || this.field_174879_c == 48 || this.field_174879_c == 50 || this.field_174879_c == 51 || this.field_174879_c == 53) {
            if (this.field_174879_c == 38 || this.field_174879_c == 50 || this.field_174879_c == 53) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c == 48 || this.field_174879_c == 50) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.0, 0.75, 0.0, 0.0, 0.75, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.25, 0.0, 0.0, 1.0, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if (this.field_174879_c == 36) {
                boundingArray = ITUtils.smartBoundingBox(0.75, 0.0, 0.25, 0.25, 0.25, 0.75, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 37 || this.field_174879_c == 49 || this.field_174879_c == 52) {
            if (this.field_174879_c == 49) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.0, 0.0, 0.0, 0.75, 1.0, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 39 || this.field_174879_c == 41 || this.field_174879_c == 45 || this.field_174879_c == 47 || this.field_174879_c == 54 || this.field_174879_c == 56) {
            if (this.field_174879_c == 41 || this.field_174879_c == 47 || this.field_174879_c == 56) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c == 45 || this.field_174879_c == 47) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.0, 0.25, 0.0, 0.0, 1.0, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 60 || this.field_174879_c == 61) {
            if (this.field_174879_c == 61) {
                fw = fw.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.4375, 0.3125, 0.375, 0.375, 0.0, 0.125, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.375, 0.25, 0.3125, 0.3125, 0.125, 0.5, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            boundingArray = ITUtils.smartBoundingBox(0.4375, 0.3125, 0.6875, 0.0, 0.1875, 0.4375, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 66 || this.field_174879_c == 68 || this.field_174879_c == 78 || this.field_174879_c == 80 || this.field_174879_c == 81 || this.field_174879_c == 83) {
            if (this.field_174879_c == 68 || this.field_174879_c == 80 || this.field_174879_c == 83) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c == 78 || this.field_174879_c == 80) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.5, 0.0, 0.0, 0.4375, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 67) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.0, 0.0, 0.0, 0.5, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 69 || this.field_174879_c == 71 || this.field_174879_c == 75 || this.field_174879_c == 77 || this.field_174879_c == 84 || this.field_174879_c == 86) {
            if (this.field_174879_c == 71 || this.field_174879_c == 77 || this.field_174879_c == 86) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c == 75 || this.field_174879_c == 77) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.0, 0.5, 0.0, 0.0, 0.4375, fl, fw);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 79 || this.field_174879_c == 82) {
            if (this.field_174879_c == 82) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.25, 0.25, 0.0, 1.0, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.75, 0.0, 0.0, 0.0, 0.0, 0.5, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 70 || this.field_174879_c == 76 || this.field_174879_c == 85) {
            if (this.field_174879_c == 76) {
                fl = fl.func_176734_d();
            }
            boundingArray = ITUtils.smartBoundingBox(0.25, 0.0, 0.0, 0.0, 0.0, 0.5, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 70) {
                boundingArray = ITUtils.smartBoundingBox(0.5, 0.0, 0.25, 0.25, 0.5, 1.0, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 100) {
            boundingArray = ITUtils.smartBoundingBox(0.5, 0.0, 0.25, 0.25, 0.0, 0.75, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.5, 0.125, 0.125, 0.125, 0.875, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 103 || this.field_174879_c == 106 || this.field_174879_c == 109) {
            boundingArray = ITUtils.smartBoundingBox(0.0, 0.0, 0.125, 0.125, 0.125, 0.875, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 109) {
                boundingArray = ITUtils.smartBoundingBox(0.0, 0.75, 0.25, 0.25, 0.0, 0.125, fl, fw);
                list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 112) {
            boundingArray = ITUtils.smartBoundingBox(0.625, 0.0, 0.125, 0.125, 0.125, 0.875, fl, fw);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            boundingArray = ITUtils.smartBoundingBox(0.75, 0.0, 0.25, 0.25, 0.0, 0.125, fl, fw);
            list.add(new AxisAlignedBB(boundingArray[0], boundingArray[1], boundingArray[2], boundingArray[3], boundingArray[4], boundingArray[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        return null;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    public int[] getEnergyPos() {
        return new int[0];
    }

    public int[] getRedstonePos() {
        return new int[]{32};
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 0;
    }

    public int getProcessQueueMaxLength() {
        return 0;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean isMechanicalEnergyTransmitter() {
        return true;
    }

    @Override
    public boolean isMechanicalEnergyReceiver() {
        return false;
    }

    @Override
    public EnumFacing getMechanicalEnergyOutputFacing() {
        return this.facing;
    }

    @Override
    public EnumFacing getMechanicalEnergyInputFacing() {
        return null;
    }

    @Override
    public int inputToCenterDistance() {
        return -1;
    }

    @Override
    public int outputToCenterDistance() {
        return 9;
    }

    @Override
    public MechanicalEnergy getEnergy() {
        return this.mechanicalEnergy;
    }

    @Override
    public MechanicalEnergyAnimation getAnimation() {
        return this.animation;
    }
}

