/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.chisel;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.plugin.chisel.items.ItemChisel;
import knightminer.tcomplement.plugin.chisel.modifiers.ModHitech;
import knightminer.tcomplement.shared.CommonsModule;
import knightminer.tcomplement.steelworks.SteelworksModule;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="ChiselPlugin", description="Add a Tinkers version of the Chisel Chisel", modsRequired="chisel")
public class ChiselPlugin
extends PulseBase {
    public static final String modid = "chisel";
    public static final String pulseID = "ChiselPlugin";
    @SidedProxy(clientSide="knightminer.tcomplement.plugin.chisel.ChiselPluginClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static ToolPart chiselHead;
    public static ToolCore chisel;
    public static Modifier modHitech;
    public static final Category CHISEL;
    public static final ModifierAspect CHISEL_ONLY;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (ChiselPlugin.isToolsLoaded()) {
            chiselHead = ChiselPlugin.registerItem((IForgeRegistry<Item>)r, new ToolPart(144), "chisel_head");
            chiselHead.func_77637_a((CreativeTabs)TCompRegistry.tabTools);
            chisel = (ToolCore)ChiselPlugin.registerItem((IForgeRegistry<Item>)r, new ItemChisel(), modid);
            modHitech = new ModHitech();
            modHitech.addItem(CommonsModule.iModifier, 1, 1);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (ChiselPlugin.isToolsLoaded()) {
            TinkerRegistry.registerToolCrafting((ToolCore)chisel);
            ChiselPlugin.registerStencil(chiselHead);
            TCompRegistry.tabTools.setDisplayIcon(chisel.buildItem((List)ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.iron)));
        }
        if (ChiselPlugin.isSteelworksLoaded()) {
            for (BlockSeared.SearedType type : BlockSeared.SearedType.values()) {
                if (type == BlockSeared.SearedType.COBBLE) continue;
                this.addChiselVariation((Block)SteelworksModule.scorchedBlock, type.getMeta(), "scorched_block");
            }
        }
        proxy.init();
    }

    protected void addChiselVariation(Block block, int meta, String groupName) {
        if (block != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("group", groupName);
            nbt.func_74782_a("stack", (NBTBase)new ItemStack(block, 1, meta).func_77955_b(new NBTTagCompound()));
            nbt.func_74778_a("block", block.getRegistryName().toString());
            nbt.func_74768_a("meta", meta);
            FMLInterModComms.sendMessage((String)modid, (String)"add_variation", (NBTTagCompound)nbt);
        }
    }

    static {
        CHISEL = new Category(modid);
        CHISEL_ONLY = new ModifierAspect.CategoryAspect(new Category[]{CHISEL});
    }
}

