/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.armor;

import com.google.common.eventbus.Subscribe;
import knightminer.tcomplement.armor.items.ItemArmorBase;
import knightminer.tcomplement.armor.items.ItemKnightSlimeArmor;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.shared.CommonsModule;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="ModuleArmor", description="Adds KnightSlime and Manyullyn vanilla style armors")
public class ArmorModule
extends PulseBase {
    public static final String pulseID = "ModuleArmor";
    @SidedProxy(clientSide="knightminer.tcomplement.armor.ArmorClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static ItemArmor.ArmorMaterial manyullynArmor;
    public static Item manyullynHelmet;
    public static Item manyullynChestplate;
    public static Item manyullynLeggings;
    public static Item manyullynBoots;
    public static ItemArmor.ArmorMaterial knightSlimeArmor;
    public static Item knightSlimeHelmet;
    public static Item knightSlimeChestplate;
    public static Item knightSlimeLeggings;
    public static Item knightSlimeBoots;
    public static ItemArmor.ArmorMaterial steelArmor;
    public static Item steelHelmet;
    public static Item steelChestplate;
    public static Item steelLeggings;
    public static Item steelBoots;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        manyullynArmor = EnumHelper.addArmorMaterial((String)Util.prefix("manyullyn"), (String)Util.resource("manyullyn"), (int)21, (int[])new int[]{3, 6, 8, 3}, (int)7, (SoundEvent)SoundEvents.field_187725_r, (float)3.0f);
        knightSlimeArmor = EnumHelper.addArmorMaterial((String)Util.prefix("knightslime"), (String)Util.resource("knightslime"), (int)15, (int[])new int[]{2, 4, 5, 1}, (int)6, (SoundEvent)SoundEvents.field_187884_fr, (float)1.0f);
        if (ArmorModule.isSteelworksLoaded()) {
            steelArmor = EnumHelper.addArmorMaterial((String)Util.prefix("steel"), (String)Util.resource("steel"), (int)20, (int[])new int[]{2, 5, 7, 2}, (int)7, (SoundEvent)SoundEvents.field_187725_r, (float)1.5f);
        }
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        manyullynHelmet = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(manyullynArmor, EntityEquipmentSlot.HEAD), "manyullyn_helmet");
        manyullynChestplate = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(manyullynArmor, EntityEquipmentSlot.CHEST), "manyullyn_chestplate");
        manyullynLeggings = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(manyullynArmor, EntityEquipmentSlot.LEGS), "manyullyn_leggings");
        manyullynBoots = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(manyullynArmor, EntityEquipmentSlot.FEET), "manyullyn_boots");
        ItemStack manyullyn = GameRegistry.makeItemStack((String)"tconstruct:ingots", (int)2, (int)1, null);
        if (!manyullyn.func_190926_b()) {
            manyullynArmor.setRepairItem(manyullyn);
        }
        knightSlimeHelmet = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemKnightSlimeArmor(EntityEquipmentSlot.HEAD), "knightslime_helmet");
        knightSlimeChestplate = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemKnightSlimeArmor(EntityEquipmentSlot.CHEST), "knightslime_chestplate");
        knightSlimeLeggings = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemKnightSlimeArmor(EntityEquipmentSlot.LEGS), "knightslime_leggings");
        knightSlimeBoots = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemKnightSlimeArmor(EntityEquipmentSlot.FEET), "knightslime_boots");
        ItemStack knightSlime = GameRegistry.makeItemStack((String)"tconstruct:ingots", (int)3, (int)1, null);
        if (!knightSlime.func_190926_b()) {
            knightSlimeArmor.setRepairItem(knightSlime);
        }
        if (ArmorModule.isSteelworksLoaded()) {
            steelHelmet = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(steelArmor, EntityEquipmentSlot.HEAD), "steel_helmet");
            steelChestplate = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(steelArmor, EntityEquipmentSlot.CHEST), "steel_chestplate");
            steelLeggings = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(steelArmor, EntityEquipmentSlot.LEGS), "steel_leggings");
            steelBoots = ArmorModule.registerItem((IForgeRegistry<Item>)r, new ItemArmorBase(steelArmor, EntityEquipmentSlot.FEET), "steel_boots");
            steelArmor.setRepairItem(CommonsModule.steelIngot);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(ItemKnightSlimeArmor.class);
        proxy.postInit();
    }
}

