/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.config.ModConfig;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class FeatureToolInfo {
    public static final String[] DEFAULT_VALUES = new String[]{"0=Stone", "1=Iron", "2=Diamond", "3=Obsidian"};
    public static Map<Integer, String> names = new HashMap<Integer, String>();

    public static void configure(Configuration config) {
        ConfigCategory category = config.getCategory("features");
        String[] values = config.get(category.getName(), "mining_level_names", DEFAULT_VALUES).getStringList();
        category.get("mining_level_names").setComment("Here you can define custom names for the mining levels displayed in the 'tool_info_tooltip'.\n- Syntax: level=name\n- 'name' should be exactly how you want it to appear ingame.\n- Example: 0=Literal Trash\n- Levels not defined here will show the numerical value.");
        for (String value : values) {
            int level;
            String[] parts = value.split("=");
            if (parts.length != 2) continue;
            String name = parts[1];
            try {
                level = Integer.valueOf(parts[0]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            names.put(level, name);
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!ModConfig.confToolInfoTooltip) {
            return;
        }
        if (!(event.getState().func_185887_b(event.getWorld(), event.getPos()) > 0.0f)) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTool) {
            NBTTagCompound tag = stack.func_190925_c("pickletweaks");
            tag.func_74768_a("BlocksBroken", tag.func_74762_e("BlocksBroken") + 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addToolInfoTooltip(ItemTooltipEvent event) {
        if (!ModConfig.confToolInfoTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ListIterator<String> tooltip = event.getToolTip().listIterator();
        if (stack.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)stack.func_77973_b();
            boolean shift = false;
            if (Keyboard.isCreated()) {
                boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            }
            if (tooltip.hasNext()) {
                tooltip.next();
                if (shift) {
                    String toolClass = tool.getToolClasses(stack).toArray().length > 0 ? tool.getToolClasses(stack).toArray()[0].toString() : "";
                    tooltip.add(Utils.localize((String)"tooltip.pt.mining_level") + " " + "\u00a7f" + this.getMiningLevelName(stack, toolClass));
                    tooltip.add(Utils.localize((String)"tooltip.pt.mining_speed") + " " + "\u00a7f" + this.getMiningSpeed(tool));
                    tooltip.add(Utils.localize((String)"tooltip.pt.durability") + " " + "\u00a7f" + this.getDurability(stack));
                    tooltip.add(Utils.localize((String)"tooltip.pt.blocks_broken") + " " + "\u00a7f" + this.getBlocksBroken(stack));
                } else {
                    tooltip.add(Utils.localize((String)"tooltip.pt.hold_shift_for_info"));
                }
            }
        }
    }

    public String getMiningLevelName(ItemStack stack, String toolClass) {
        ItemTool tool = (ItemTool)stack.func_77973_b();
        if (toolClass.equals("")) {
            int level;
            if (this.getToolMaterial(tool) != null && names.containsKey(level = this.getToolMaterial(tool).func_77996_d())) {
                return names.get(level);
            }
            return "?";
        }
        int level = tool.getHarvestLevel(stack, toolClass, null, null);
        if (names.containsKey(level)) {
            return names.get(level);
        }
        return level + "";
    }

    public Item.ToolMaterial getToolMaterial(ItemTool item) {
        return item.field_77862_b;
    }

    public float getMiningSpeed(ItemTool item) {
        Item.ToolMaterial mat = this.getToolMaterial(item);
        if (mat == null) {
            return -1.0f;
        }
        return mat.func_77998_b();
    }

    public String getDurability(ItemStack stack) {
        if (stack.func_77958_k() == -1) {
            return Utils.localize((String)"tooltip.pt.unbreakable");
        }
        int durability = stack.func_77958_k() - stack.func_77952_i();
        return durability + "\u00a77" + "/" + "\u00a7f" + stack.func_77958_k();
    }

    public int getBlocksBroken(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("pickletweaks");
        if (tag != null && tag.func_74764_b("BlocksBroken")) {
            return tag.func_74762_e("BlocksBroken");
        }
        return 0;
    }
}

