/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.OTG;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.MaterialSetEntry;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class MaterialSet {
    public static final String ALL_MATERIALS = "All";
    public static final String SOLID_MATERIALS = "Solid";
    public static final String NON_SOLID_MATERIALS = "NonSolid";
    private boolean allMaterials = false;
    private boolean allSolidMaterials = false;
    private boolean allNonSolidMaterials = false;
    private int[] materialIntSet = new int[0];
    private Set<MaterialSetEntry> materials = new LinkedHashSet<MaterialSetEntry>();
    private boolean intSetUpToDate = true;

    public void parseAndAdd(String input) throws InvalidConfigException {
        if (input.equalsIgnoreCase(ALL_MATERIALS)) {
            this.allMaterials = true;
            return;
        }
        if (input.equalsIgnoreCase(SOLID_MATERIALS)) {
            this.allSolidMaterials = true;
            return;
        }
        if (input.equalsIgnoreCase(NON_SOLID_MATERIALS)) {
            this.allNonSolidMaterials = true;
            return;
        }
        LocalMaterialData material = OTG.readMaterial(input);
        boolean checkIncludesBlockData = StringHelper.specifiesBlockData(input);
        this.add(new MaterialSetEntry(material, checkIncludesBlockData));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allMaterials ? 1231 : 1237);
        result = 31 * result + (this.allNonSolidMaterials ? 1231 : 1237);
        result = 31 * result + (this.allSolidMaterials ? 1231 : 1237);
        result = 31 * result + this.materials.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialSet other = (MaterialSet)obj;
        if (this.allMaterials != other.allMaterials) {
            return false;
        }
        if (this.allNonSolidMaterials != other.allNonSolidMaterials) {
            return false;
        }
        if (this.allSolidMaterials != other.allSolidMaterials) {
            return false;
        }
        return this.materials.equals(other.materials);
    }

    public void add(MaterialSetEntry entry) {
        this.intSetUpToDate = false;
        this.materials.add(entry);
    }

    private void updateIntSet() {
        if (this.intSetUpToDate) {
            return;
        }
        this.materialIntSet = new int[this.materials.size()];
        int i = 0;
        for (MaterialSetEntry entry : this.materials) {
            this.materialIntSet[i] = entry.hashCode();
            ++i;
        }
        Arrays.sort(this.materialIntSet);
        this.intSetUpToDate = true;
    }

    public boolean contains(LocalMaterialData material) {
        if (material == null) {
            return false;
        }
        if (this.allMaterials && !material.isAir()) {
            return true;
        }
        if (this.allSolidMaterials && material.isSolid()) {
            return true;
        }
        if (this.allNonSolidMaterials && !material.isSolid()) {
            return true;
        }
        this.updateIntSet();
        if (Arrays.binarySearch(this.materialIntSet, material.hashCodeWithoutBlockData()) >= 0) {
            return true;
        }
        return Arrays.binarySearch(this.materialIntSet, material.hashCode()) >= 0;
    }

    public String toString() {
        if (this.allMaterials) {
            return ALL_MATERIALS;
        }
        StringBuilder builder = new StringBuilder();
        if (this.allSolidMaterials) {
            builder.append(SOLID_MATERIALS).append(',');
        }
        if (this.allNonSolidMaterials) {
            builder.append(NON_SOLID_MATERIALS).append(',');
        }
        for (MaterialSetEntry material : this.materials) {
            builder.append(material.toString()).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public MaterialSet rotate() {
        MaterialSet rotated = new MaterialSet();
        if (this.allMaterials) {
            rotated.allMaterials = true;
        }
        if (this.allSolidMaterials) {
            rotated.allSolidMaterials = true;
        }
        if (this.allNonSolidMaterials) {
            rotated.allNonSolidMaterials = true;
        }
        rotated.intSetUpToDate = false;
        for (MaterialSetEntry material : this.materials) {
            rotated.materials.add(material.rotate());
        }
        return rotated;
    }
}

