/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.terrain;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.terrain.TerrainGenBase;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.Random;

public class CavesGen
extends TerrainGenBase {
    private WorldConfig worldSettings;

    public CavesGen(WorldConfig wrk, LocalWorld world) {
        super(world);
        this.worldSettings = wrk;
    }

    protected void generateLargeCaveNode(long seed, ChunkBuffer generatingChunkBuffer, double x, double y, double z) {
        this.generateCaveNode(seed, generatingChunkBuffer, x, y, z, 1.0f + this.random.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, ChunkBuffer generatingChunkBuffer, double x, double y, double z, float paramFloat1, float paramFloat2, float paramFloat3, int angle, int maxAngle, double paramDouble4) {
        boolean k;
        ChunkCoordinate generatingChunk = generatingChunkBuffer.getChunkCoordinate();
        double real_x = generatingChunk.getBlockXCenter();
        double real_z = generatingChunk.getBlockZCenter();
        float f1 = 0.0f;
        float f2 = 0.0f;
        Random localRandom = new Random(seed);
        if (maxAngle <= 0) {
            int checkAreaSize = this.checkAreaSize * 16 - 16;
            maxAngle = checkAreaSize - localRandom.nextInt(checkAreaSize / 4);
        }
        boolean isLargeCave = false;
        if (angle == -1) {
            angle = maxAngle / 2;
            isLargeCave = true;
        }
        int j = localRandom.nextInt(maxAngle / 2) + maxAngle / 4;
        boolean bl = k = localRandom.nextInt(6) == 0;
        while (angle < maxAngle) {
            double d3 = 1.5 + (double)(MathHelper.sin((float)angle * 3.141593f / (float)maxAngle) * paramFloat1 * 1.0f);
            double d4 = d3 * paramDouble4;
            float f3 = MathHelper.cos(paramFloat3);
            float f4 = MathHelper.sin(paramFloat3);
            x += (double)(MathHelper.cos(paramFloat2) * f3);
            y += (double)f4;
            z += (double)(MathHelper.sin(paramFloat2) * f3);
            paramFloat3 = k ? (paramFloat3 *= 0.92f) : (paramFloat3 *= 0.7f);
            paramFloat3 += f2 * 0.1f;
            paramFloat2 += f1 * 0.1f;
            f2 *= 0.9f;
            f1 *= 0.75f;
            f2 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 2.0f;
            f1 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 4.0f;
            if (!isLargeCave && angle == j && paramFloat1 > 1.0f && maxAngle > 0) {
                this.generateCaveNode(localRandom.nextLong(), generatingChunkBuffer, x, y, z, localRandom.nextFloat() * 0.5f + 0.5f, paramFloat2 - 1.570796f, paramFloat3 / 3.0f, angle, maxAngle, 1.0);
                this.generateCaveNode(localRandom.nextLong(), generatingChunkBuffer, x, y, z, localRandom.nextFloat() * 0.5f + 0.5f, paramFloat2 + 1.570796f, paramFloat3 / 3.0f, angle, maxAngle, 1.0);
                return;
            }
            if (isLargeCave || localRandom.nextInt(4) != 0) {
                double d5 = x - real_x;
                double d6 = z - real_z;
                double d7 = maxAngle - angle;
                double d8 = paramFloat1 + 2.0f + 16.0f;
                if (d5 * d5 + d6 * d6 - d7 * d7 > d8 * d8) {
                    return;
                }
                if (!(x < real_x - 16.0 - d3 * 2.0 || z < real_z - 16.0 - d3 * 2.0 || x > real_x + 16.0 + d3 * 2.0 || z > real_z + 16.0 + d3 * 2.0)) {
                    int local_x;
                    int m = MathHelper.floor(x - d3) - generatingChunk.getBlockX() - 1;
                    int n = MathHelper.floor(x + d3) - generatingChunk.getBlockX() + 1;
                    int maxDepth = MathHelper.floor(y - d4) - 1;
                    int minDepth = MathHelper.floor(y + d4) + 1;
                    int i3 = MathHelper.floor(z - d3) - generatingChunk.getBlockZ() - 1;
                    int i4 = MathHelper.floor(z + d3) - generatingChunk.getBlockZ() + 1;
                    if (m < 0) {
                        m = 0;
                    }
                    if (n > 16) {
                        n = 16;
                    }
                    if (maxDepth < 1) {
                        maxDepth = 1;
                    }
                    if (minDepth > this.worldSettings.worldHeightCap - 8) {
                        minDepth = this.worldSettings.worldHeightCap - 8;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i4 > 16) {
                        i4 = 16;
                    }
                    boolean waterFound = false;
                    for (local_x = m; !waterFound && local_x < n; ++local_x) {
                        for (int local_z = i3; !waterFound && local_z < i4; ++local_z) {
                            for (int local_y = minDepth + 1; !waterFound && local_y >= maxDepth - 1; --local_y) {
                                if (local_y < 0 || local_y >= this.worldSettings.worldHeightCap) continue;
                                LocalMaterialData material = generatingChunkBuffer.getBlock(local_x, local_y, local_z);
                                if (material.isMaterial(DefaultMaterial.WATER) || material.isMaterial(DefaultMaterial.STATIONARY_WATER)) {
                                    waterFound = true;
                                }
                                if (local_y == maxDepth - 1 || local_x == m || local_x == n - 1 || local_z == i3 || local_z == i4 - 1) continue;
                                local_y = maxDepth;
                            }
                        }
                    }
                    if (!waterFound) {
                        for (local_x = m; local_x < n; ++local_x) {
                            double d9 = ((double)(local_x + generatingChunk.getBlockX()) + 0.5 - x) / d3;
                            for (int local_z = i3; local_z < i4; ++local_z) {
                                LocalBiome biome = this.world.getBiome(local_x + generatingChunk.getBlockX(), local_z + generatingChunk.getBlockZ());
                                double d10 = ((double)(local_z + generatingChunk.getBlockZ()) + 0.5 - z) / d3;
                                boolean surfaceBlockFound = false;
                                if (!(d9 * d9 + d10 * d10 < 1.0)) continue;
                                for (int currentDepth = minDepth; currentDepth > maxDepth; --currentDepth) {
                                    double d11 = ((double)(currentDepth - 1) + 0.5 - y) / d4;
                                    if (!(d11 > -0.7) || !(d9 * d9 + d11 * d11 + d10 * d10 < 1.0)) continue;
                                    LocalMaterialData material = generatingChunkBuffer.getBlock(local_x, currentDepth, local_z);
                                    LocalMaterialData materialAbove = generatingChunkBuffer.getBlock(local_x, currentDepth + 1, local_z);
                                    if (!surfaceBlockFound && material.isMaterial(biome.getBiomeConfig().surfaceBlock.toDefaultMaterial())) {
                                        surfaceBlockFound = true;
                                    }
                                    if (!this.isSuitableBlock(material, materialAbove, biome)) continue;
                                    generatingChunkBuffer.setBlock(local_x, currentDepth, local_z, this.air);
                                    LocalMaterialData block = generatingChunkBuffer.getBlock(local_x, currentDepth - 1, local_z);
                                    if (!surfaceBlockFound || block.isLiquid() || block.isMaterial(DefaultMaterial.BEDROCK)) continue;
                                    generatingChunkBuffer.setBlock(local_x, currentDepth - 1, local_z, biome.getBiomeConfig().surfaceBlock);
                                }
                            }
                        }
                        if (isLargeCave) break;
                    }
                }
            }
            ++angle;
        }
    }

    protected boolean isSuitableBlock(LocalMaterialData material, LocalMaterialData materialAbove, LocalBiome biome) {
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        if (material.equals(biomeConfig.stoneBlock)) {
            return true;
        }
        if (material.canFall()) {
            return !materialAbove.isLiquid();
        }
        if (material.equals(biomeConfig.groundBlock)) {
            return true;
        }
        if (material.equals(biomeConfig.surfaceBlock)) {
            return true;
        }
        if (material.isMaterial(DefaultMaterial.HARD_CLAY)) {
            return true;
        }
        if (material.isMaterial(DefaultMaterial.SANDSTONE)) {
            return true;
        }
        if (material.isMaterial(DefaultMaterial.RED_SANDSTONE)) {
            return true;
        }
        return material.isMaterial(DefaultMaterial.SNOW);
    }

    @Override
    protected void generateChunk(ChunkCoordinate chunkCoord, ChunkBuffer generatingChunkBuffer) {
        int i = 0;
        if (this.worldSettings.caveRarity > 0 && this.worldSettings.caveFrequency > 0) {
            i = this.random.nextInt(this.random.nextInt(this.random.nextInt(this.worldSettings.caveFrequency) + 1) + 1);
            if (this.worldSettings.evenCaveDistribution) {
                i = this.worldSettings.caveFrequency;
            }
            if (this.random.nextInt(100) >= this.worldSettings.caveRarity) {
                i = 0;
            }
        }
        for (int j = 0; j < i; ++j) {
            double x = chunkCoord.getBlockX() + this.random.nextInt(16);
            double y = this.worldSettings.evenCaveDistribution ? (double)RandomHelper.numberInRange(this.random, this.worldSettings.caveMinAltitude, this.worldSettings.caveMaxAltitude) : (double)(this.random.nextInt(this.random.nextInt(this.worldSettings.caveMaxAltitude - this.worldSettings.caveMinAltitude + 1) + 1) + this.worldSettings.caveMinAltitude);
            double z = chunkCoord.getBlockZ() + this.random.nextInt(16);
            int count = this.worldSettings.caveSystemFrequency;
            boolean largeCaveSpawned = false;
            if (this.random.nextInt(100) <= this.worldSettings.individualCaveRarity) {
                this.generateLargeCaveNode(this.random.nextLong(), generatingChunkBuffer, x, y, z);
                largeCaveSpawned = true;
            }
            if (largeCaveSpawned || this.random.nextInt(100) <= this.worldSettings.caveSystemPocketChance - 1) {
                count += RandomHelper.numberInRange(this.random, this.worldSettings.caveSystemPocketMinSize, this.worldSettings.caveSystemPocketMaxSize);
            }
            while (count > 0) {
                --count;
                float f1 = this.random.nextFloat() * 3.141593f * 2.0f;
                float f2 = (this.random.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f3 = this.random.nextFloat() * 2.0f + this.random.nextFloat();
                this.generateCaveNode(this.random.nextLong(), generatingChunkBuffer, x, y, z, f3, f1, f2, 0, 0, 1.0);
            }
        }
    }
}

